/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.client.instance;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.neep.meatlib.client.RotationAxis;
import com.neep.neepbus.block.SlantedSliderBlock;
import com.neep.neepbus.block.SliderBlock;
import com.neep.neepbus.block.entity.SliderBlockEntity;
import com.neep.neepmeat.client.NMExtraModels;
import net.minecraft.class_1158;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class LinearLeverInstance
extends BlockEntityInstance<SliderBlockEntity>
implements DynamicInstance {
    private final ModelData handle;
    private final class_4587 matrixStack = new class_4587();
    private float lerpOffset = 0.0f;

    public LinearLeverInstance(MaterialManager materialManager, SliderBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
        this.handle = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(NMExtraModels.LINEAR_LEVER_HANDLE).createInstance();
    }

    public static float clamp(float value, float min, float max) {
        if (Float.isNaN(value)) {
            return min;
        }
        return value < min ? min : Math.min(value, max);
    }

    private static class_1158 euler(float xDeg, float yDeg) {
        class_1158 quaternion = class_1158.field_21493.method_23695();
        return LinearLeverInstance.rotateZYX(quaternion, xDeg * ((float)Math.PI / 180), yDeg * ((float)Math.PI / 180), 0.0f);
    }

    public static class_1158 rotateZYX(class_1158 q, float angleX, float angleY, float angleZ) {
        float sx = class_3532.method_15374((float)(angleX * 0.5f));
        float cx = LinearLeverInstance.cosFromSin(sx, angleX * 0.5f);
        float sy = class_3532.method_15374((float)(angleY * 0.5f));
        float cy = LinearLeverInstance.cosFromSin(sy, angleY * 0.5f);
        float sz = class_3532.method_15374((float)(angleZ * 0.5f));
        float cz = LinearLeverInstance.cosFromSin(sz, angleZ * 0.5f);
        float cycz = cy * cz;
        float sysz = sy * sz;
        float sycz = sy * cz;
        float cysz = cy * sz;
        float w = cx * cycz + sx * sysz;
        float x = sx * cycz - cx * sysz;
        float y = cx * sycz + sx * cysz;
        float z = cx * cysz - sx * sycz;
        return new class_1158(Math.fma(q.method_4924(), x, Math.fma(q.method_4921(), w, Math.fma(q.method_4922(), z, -q.method_4923() * y))), Math.fma(q.method_4924(), y, Math.fma(-q.method_4921(), z, Math.fma(q.method_4922(), w, q.method_4923() * x))), Math.fma(q.method_4924(), z, Math.fma(q.method_4921(), y, Math.fma(-q.method_4922(), x, q.method_4923() * w))), Math.fma(q.method_4924(), w, Math.fma(-q.method_4921(), x, Math.fma(-q.method_4922(), y, -q.method_4923() * z))));
    }

    private static float cosFromSin(float sin, float angle) {
        float cos = class_3532.method_15355((float)(1.0f - sin * sin));
        float a = angle + 1.5707964f;
        float b = a - (float)((int)(a / ((float)Math.PI * 2))) * ((float)Math.PI * 2);
        if ((double)b < 0.0) {
            b = (float)Math.PI * 2 + b;
        }
        if (b >= (float)Math.PI) {
            return -cos;
        }
        return cos;
    }

    protected void remove() {
        this.handle.delete();
    }

    public void beginFrame() {
        float f = 0.625f * LinearLeverInstance.clamp((((SliderBlockEntity)this.blockEntity).getValue() - ((SliderBlockEntity)this.blockEntity).getMinValue()) / (((SliderBlockEntity)this.blockEntity).getMaxValue() - ((SliderBlockEntity)this.blockEntity).getMinValue()), 0.0f, 1.0f);
        this.lerpOffset = class_3532.method_16439((float)0.4f, (float)this.lerpOffset, (float)f);
        if (this.blockState.method_26204() instanceof SliderBlock) {
            class_1158 facing = this.rotateThing((class_2350)this.blockState.method_11654((class_2769)class_2341.field_11177), (class_2738)this.blockState.method_11654((class_2769)class_2341.field_11007));
            ((ModelData)((ModelData)this.handle.loadIdentity().translate((class_2382)this.getInstancePosition())).centre()).multiply(facing).translate(0.0, 0.0, (double)this.lerpOffset).unCentre();
        } else if (this.blockState.method_26204() instanceof SlantedSliderBlock) {
            class_1158 facing = this.rotateSlanted((class_2350)this.blockState.method_11654((class_2769)SlantedSliderBlock.field_11177), (SlantedSliderBlock.Attachment)((Object)this.blockState.method_11654(SlantedSliderBlock.FACE)));
            ((ModelData)((ModelData)((ModelData)((ModelData)this.handle.loadIdentity().translate((class_2382)this.getInstancePosition())).centre()).multiply(facing).unCentre()).translate(0.0, 0.0625, 0.0).rotate(class_2350.field_11039, 0.7853982f)).translate(0.0, 0.0, 0.25).translate(0.0, 0.0, (double)this.lerpOffset);
        }
    }

    public void updateLight() {
        this.relight(this.getWorldPosition(), new FlatLit[]{this.handle});
    }

    private class_1158 rotateThing(class_2350 horFacing, class_2738 face) {
        if (face == class_2738.field_12471) {
            return switch (horFacing) {
                case class_2350.field_11043 -> LinearLeverInstance.euler(-90.0f, 0.0f);
                case class_2350.field_11035 -> LinearLeverInstance.euler(-90.0f, 180.0f);
                case class_2350.field_11034 -> LinearLeverInstance.euler(-90.0f, -90.0f);
                default -> LinearLeverInstance.euler(-90.0f, 90.0f);
            };
        }
        if (face == class_2738.field_12475) {
            return switch (horFacing) {
                case class_2350.field_11043 -> LinearLeverInstance.euler(0.0f, 180.0f);
                case class_2350.field_11035 -> LinearLeverInstance.euler(0.0f, 0.0f);
                case class_2350.field_11034 -> LinearLeverInstance.euler(0.0f, 90.0f);
                default -> LinearLeverInstance.euler(0.0f, -90.0f);
            };
        }
        return switch (horFacing) {
            case class_2350.field_11043 -> LinearLeverInstance.euler(180.0f, 0.0f);
            case class_2350.field_11035 -> LinearLeverInstance.euler(180.0f, 180.0f);
            case class_2350.field_11034 -> LinearLeverInstance.euler(180.0f, -90.0f);
            default -> LinearLeverInstance.euler(180.0f, 90.0f);
        };
    }

    private class_1158 rotateSlanted(class_2350 horFacing, SlantedSliderBlock.Attachment face) {
        if (face == SlantedSliderBlock.Attachment.FLOOR) {
            return switch (horFacing) {
                case class_2350.field_11043 -> RotationAxis.POSITIVE_Y.rotationDegrees(180.0f);
                case class_2350.field_11035 -> new class_1158(0.0f, 0.0f, 0.0f, 0.0f);
                case class_2350.field_11034 -> LinearLeverInstance.euler(0.0f, 90.0f);
                default -> LinearLeverInstance.euler(0.0f, -90.0f);
            };
        }
        return switch (horFacing) {
            case class_2350.field_11043 -> LinearLeverInstance.euler(180.0f, 0.0f);
            case class_2350.field_11035 -> LinearLeverInstance.euler(180.0f, 180.0f);
            case class_2350.field_11034 -> LinearLeverInstance.euler(180.0f, -90.0f);
            default -> LinearLeverInstance.euler(180.0f, 90.0f);
        };
    }
}

