/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.client.item;

import com.neep.meatlib.client.event.CrosshairRenderEvent;
import com.neep.meatlib.client.event.ScrollEvents;
import com.neep.meatlib.client.event.UseAttackCallback;
import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.neepbus.NeepBus;
import com.neep.neepbus.block.NeepBusProvider;
import com.neep.neepbus.network.NeepBusNetwork;
import com.neep.neepbus.util.ConfigEntry;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.util.NMMaths;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class NetworkingToolClient {
    @Nullable
    private static StoredConfig CONFIG;
    private static Mode mode;
    @Nullable
    private static StoredAddress address;
    private static int selected;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null && client.field_1724 != null) {
                class_1799 mainStack = client.field_1724.method_6047();
                if (mainStack.method_31574(NeepBus.NETWORKING_TOOL)) {
                    NetworkingToolClient.tick(client);
                } else {
                    CONFIG = null;
                }
            }
        });
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            class_1799 mainStack;
            class_310 client = class_310.method_1551();
            if (client.field_1687 != null && client.field_1724 != null && (mainStack = client.field_1724.method_6047()).method_31574(NeepBus.NETWORKING_TOOL)) {
                NetworkingToolClient.renderHud(drawContext, client, tickDelta);
            }
        });
        ScrollEvents.PRE_INGAME_SCROLL.register((client, world, player, window, amount) -> {
            if (client.method_18506() == null && CONFIG != null) {
                int newSelected = NetworkingToolClient.clampSelection(selected + (int)Math.round(amount), CONFIG.config());
                if (newSelected != selected) {
                    selected = newSelected;
                    client.method_1483().method_4873((class_1113)new class_1109(NMSounds.CLICK, class_3419.field_15248, 1.0f, 1.0f, class_1113.method_43221(), player.method_23317(), player.method_23318(), player.method_23321()));
                }
                return true;
            }
            return false;
        });
        UseAttackCallback.DO_USE.register((client, player) -> {
            if (NetworkingToolClient.override() && player.method_6047().method_31574(NeepBus.NETWORKING_TOOL)) {
                class_239 patt3839$temp;
                if (player.method_5715() && (patt3839$temp = client.field_1765) instanceof class_3965) {
                    class_3965 blockHitResult = (class_3965)patt3839$temp;
                    NeepBusNetwork.OPEN_CONFIG_SCREEN.emitter((class_1657)player).open(blockHitResult.method_17777());
                    return true;
                }
                if (CONFIG == null && address != null) {
                    NetworkingToolClient.clear();
                } else if (CONFIG != null) {
                    NetworkingToolClient.configClick(client, CONFIG.blockName(), CONFIG.config());
                }
                UseAttackCallback.swingHand(client, class_1268.field_5808);
                return false;
            }
            return true;
        });
        CrosshairRenderEvent.EVENT.register((context, player) -> NetworkingToolClient.override() && player.method_6047().method_31574(NeepBus.NETWORKING_TOOL));
    }

    private static void clear() {
        mode = Mode.SENDER;
        address = null;
    }

    private static void configClick(class_310 client, class_2561 blockName, NeepBusConfig config) {
        List<? extends ConfigEntry> entries;
        selected = NetworkingToolClient.clampSelection(selected, config);
        if (address == null) {
            List<? extends ConfigEntry> entries2;
            if (mode == Mode.SENDER && !(entries2 = config.getOutputs()).isEmpty()) {
                ConfigEntry entry = config.getOutputs().get(selected);
                address = new StoredAddress(blockName, entry);
                mode = Mode.RECEIVER;
                client.method_1483().method_4873((class_1113)new class_1109(NMSounds.UI_BEEP, class_3419.field_15248, 1.0f, 1.0f, class_1113.method_43221(), client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321()));
            }
        } else if (mode == Mode.RECEIVER && !(entries = config.getInputs()).isEmpty()) {
            class_239 class_2392 = client.field_1765;
            if (class_2392 instanceof class_3965) {
                class_3965 blockHitResult = (class_3965)class_2392;
                NeepBusNetwork.NT_CONNECT.emitter((class_1657)client.field_1724).send(blockHitResult.method_17777(), false, selected, address.address());
                client.method_1483().method_4873((class_1113)new class_1109(NMSounds.UI_BEEP, class_3419.field_15248, 1.0f, 1.0f, class_1113.method_43221(), client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321()));
            }
            mode = Mode.SENDER;
            address = null;
        }
    }

    private static void renderHud(class_4587 context, class_310 client, float tickDelta) {
        int labelY;
        ConfigEntry entry;
        int y;
        int i;
        int yStart;
        int xStart;
        int idx;
        class_1041 window = client.method_22683();
        int wWidth = window.method_4486();
        int wHeight = window.method_4502();
        class_327 textRenderer = client.field_1772;
        int entryHeight = 20;
        int entryStride = entryHeight + 1;
        int entryWidth = 120;
        if (address != null) {
            if (CONFIG == null) {
                NetworkingToolClient.renderInstructions(context, textRenderer, (class_2561)NeepMeat.translationKey("screen", "networking_tool.instructions.reset"));
            }
            int xStart2 = wWidth / 2 - entryWidth - 10;
            int yStart2 = (wHeight - entryStride) / 2;
            NetworkingToolClient.renderEntry(context, textRenderer, address, true, xStart2, yStart2, entryWidth, entryHeight);
            NetworkingToolClient.renderHeader(context, textRenderer, address.blockName(), xStart2, yStart2 - entryStride + 5, entryWidth, entryHeight);
        }
        if (address != null && CONFIG != null && mode == Mode.RECEIVER) {
            NetworkingToolClient.renderInstructions(context, textRenderer, (class_2561)NeepMeat.translationKey("screen", "networking_tool.instructions.receiver"));
            List<? extends ConfigEntry> inputs = CONFIG.config().getInputs();
            idx = NMMaths.clamp(selected, 0, inputs.size() - 1);
            xStart = wWidth / 2 + 10;
            yStart = (wHeight - entryStride) / 2 + idx * entryStride;
            i = 0;
            for (i = 0; i < inputs.size(); ++i) {
                y = yStart - i * entryStride;
                entry = inputs.get(i);
                NetworkingToolClient.renderEntry(context, textRenderer, entry, i == idx, xStart, y, entryWidth, entryHeight);
            }
            labelY = yStart - i * entryStride + 5;
            NetworkingToolClient.renderHeader(context, textRenderer, CONFIG.blockName(), xStart, labelY, entryWidth, entryHeight);
        }
        if (address == null && CONFIG != null && mode == Mode.SENDER) {
            NetworkingToolClient.renderInstructions(context, textRenderer, (class_2561)NeepMeat.translationKey("screen", "networking_tool.instructions.sender"));
            List<? extends ConfigEntry> outputs = CONFIG.config().getOutputs();
            idx = NMMaths.clamp(selected, 0, outputs.size() - 1);
            xStart = wWidth / 2 - entryWidth - 10;
            yStart = (wHeight - entryStride) / 2 + idx * entryStride;
            i = 0;
            for (i = 0; i < outputs.size(); ++i) {
                y = yStart - i * entryStride;
                entry = outputs.get(i);
                NetworkingToolClient.renderEntry(context, textRenderer, entry, i == idx, xStart, y, entryWidth, entryHeight);
            }
            labelY = yStart - i * entryStride + 5;
            NetworkingToolClient.renderHeader(context, textRenderer, CONFIG.blockName(), xStart, labelY, entryWidth, entryHeight);
        }
        if (NetworkingToolClient.override()) {
            String arrow = "\u2192";
            float f = (float)(wWidth - textRenderer.method_1727(arrow)) / 2.0f;
            Objects.requireNonNull(textRenderer);
            GUIUtil.drawText(context, textRenderer, arrow, f, (float)(wHeight - 9) / 2.0f + 1.0f, PLCCols.TEXT.col, true);
        }
    }

    private static void renderInstructions(class_4587 context, class_327 textRenderer, class_2561 instructions) {
        int yOff = 5;
        for (class_5481 text : textRenderer.method_1728((class_5348)instructions, 400)) {
            GUIUtil.drawText(context, textRenderer, text, 5.0f, (float)yOff, PLCCols.TEXT.col, true);
            Objects.requireNonNull(textRenderer);
            yOff += 9;
        }
    }

    private static void renderEntry(class_4587 context, class_327 textRenderer, ConfigEntry entry, boolean selected, int x, int y, int w, int h) {
        int col = selected ? PLCCols.SELECTED.col : PLCCols.TEXT.col;
        GUIUtil.fill(context, x, y, x + w, y + h, -1879048192);
        GUIUtil.renderBorderInner(context, x, y, w, h, col, 0);
        GUIUtil.drawText(context, textRenderer, entry.getName(), (float)(x + 2), (float)(y + 2), col, true);
        float f = x + 2;
        Objects.requireNonNull(textRenderer);
        GUIUtil.drawText(context, textRenderer, "\u2192", f, (float)(y + 2 + 9), PLCCols.INVALID.col, false);
        String address = entry.getAddress();
        int addressWidth = textRenderer.method_1727(address);
        float f2 = x + w - addressWidth - 2;
        Objects.requireNonNull(textRenderer);
        GUIUtil.drawText(context, textRenderer, address, f2, (float)(y + 9 + 2), PLCCols.TEXT.col, true);
    }

    private static void renderHeader(class_4587 context, class_327 textRenderer, class_2561 name, int x, int y, int w, int h) {
        GUIUtil.drawCenteredText(context, textRenderer, name, (float)x + (float)w / 2.0f, y, PLCCols.TEXT.col, true);
        GUIUtil.drawHorizontalLine1(context, x, x + w, y + 10, PLCCols.BORDER.col);
    }

    private static void tick(class_310 client) {
        NetworkingToolClient.updateConfig(client);
        NetworkingToolClient.updateSelection();
    }

    private static void updateSelection() {
        selected = NetworkingToolClient.clampSelection(selected, CONFIG != null ? NetworkingToolClient.CONFIG.config : null);
    }

    private static int clampSelection(int selected, NeepBusConfig config) {
        if (config != null) {
            return switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Mode.SENDER -> class_3532.method_15340((int)selected, (int)0, (int)(config.getOutputs().size() - 1));
                case Mode.RECEIVER -> class_3532.method_15340((int)selected, (int)0, (int)(config.getInputs().size() - 1));
            };
        }
        return 0;
    }

    private static void updateConfig(class_310 client) {
        NeepBusProvider provider;
        NeepBusConfig config;
        class_3965 hitResult;
        class_2338 pos;
        class_2680 state;
        class_2248 class_22482;
        class_239 class_2392 = client.field_1765;
        if (class_2392 instanceof class_3965 && (class_22482 = (state = client.field_1687.method_8320(pos = (hitResult = (class_3965)class_2392).method_17777())).method_26204()) instanceof NeepBusProvider && (config = (provider = (NeepBusProvider)class_22482).getConfig((class_1937)client.field_1687, pos, state, null)) != null) {
            CONFIG = new StoredConfig((class_2561)state.method_26204().method_9518(), config);
            return;
        }
        CONFIG = null;
    }

    public static boolean override() {
        return CONFIG != null || address != null;
    }

    static {
        mode = Mode.SENDER;
    }

    public static enum Mode {
        SENDER,
        RECEIVER;

    }

    private record StoredAddress(class_2561 blockName, String name, String address) implements ConfigEntry
    {
        public StoredAddress(class_2561 blockName, ConfigEntry entry) {
            this(blockName, entry.getName(), entry.getAddress());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getAddress() {
            return this.address;
        }

        @Override
        public void setAddress(String address) {
        }
    }

    private record StoredConfig(class_2561 blockName, NeepBusConfig config) {
    }
}

