/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.client.screen;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.meatlib.client.screen.widget.ParentWidget;
import com.neep.neepbus.screen.AddressConfigHandler;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.screen.NMTextField;
import com.neep.neepmeat.client.screen.util.Background;
import com.neep.neepmeat.client.screen.util.Border;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public class AddressConfigWidget
extends ParentWidget {
    private final AddressConfigHandler handler;

    public AddressConfigWidget(int x, int y, int w, int h, AddressConfigHandler handler) {
        super(x, y, w, h);
        this.handler = handler;
    }

    @Override
    public void init() {
        int finalI;
        int i;
        super.init();
        int headerHeight = 13;
        int entryHeight = 30;
        int columnWidth = 120;
        int numEntries = Math.max(this.handler.inputs.size(), this.handler.outputs.size());
        this.w = 2 * columnWidth;
        this.h = headerHeight + numEntries * entryHeight + 2;
        Background background = this.addChild(new Background(this.x, this.y, this.w, this.h, 6));
        Rectangle bounds = background.withoutPadding();
        int entryWidth = bounds.w() / 2;
        for (i = 0; i < this.handler.inputs.size(); ++i) {
            finalI = i;
            this.addChild(new EntryWidget(this.textRenderer, bounds.x(), bounds.y() + headerHeight + 2 + entryHeight * i, entryWidth - 1, entryHeight - 1, false, i, () -> this.handler.inputs.get(finalI)));
        }
        for (i = 0; i < this.handler.outputs.size(); ++i) {
            finalI = i;
            this.addChild(new EntryWidget(this.textRenderer, bounds.x() + bounds.w() / 2, bounds.y() + headerHeight + 2 + entryHeight * i, entryWidth - 1, entryHeight - 1, true, i, () -> this.handler.outputs.get(finalI)));
        }
    }

    @Override
    public void method_25394(class_4587 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int headerHeight = 13;
        GUIUtil.drawHorizontalLine1(context, this.x, this.x + this.w, this.y + headerHeight, PLCCols.BORDER.col);
        GUIUtil.drawVerticalLine1(context, this.x + this.w / 2, this.y - 1, this.y + this.h, PLCCols.BORDER.col);
        GUIUtil.drawCenteredText(context, this.textRenderer, class_2561.method_30163((String)"Input"), (float)this.x + (float)this.w / 4.0f, this.y + 2, PLCCols.TEXT.col, false);
        GUIUtil.drawCenteredText(context, this.textRenderer, class_2561.method_30163((String)"Output"), (float)this.x + (float)(3 * this.w) / 4.0f, this.y + 2, PLCCols.TEXT.col, false);
    }

    protected class EntryWidget
    extends NMTextField {
        private final Border border;
        private final Supplier<AddressConfigHandler.SyncEntry> entry;

        public EntryWidget(class_327 textRenderer, int x, int y, int width, int height, boolean isOutput, int idx, Supplier<AddressConfigHandler.SyncEntry> entry) {
            super(textRenderer, x, y, width, height, class_2561.method_30163((String)"ooer"));
            this.entry = entry;
            this.border = new Border(x, y, width, height, 0, () -> PLCCols.BORDER.col);
            this.drawFancyBackground(false);
            this.setText(entry.get().address());
            this.setChangedListener(newText -> AddressConfigWidget.this.handler.addressChangeC2S.emitter().onAddressChange(isOutput, idx, newText.strip()));
        }

        @Override
        public void renderButton(class_4587 context, int mouseX, int mouseY, float delta) {
            super.renderButton(context, mouseX, mouseY, delta);
            GUIUtil.drawText(context, this.textRenderer, class_2561.method_30163((String)(this.entry.get().name() + ": ")), (float)(this.x() + 2), (float)this.y(), PLCCols.TEXT.col, false);
        }

        @Override
        protected String getPrefix() {
            return "\u2192";
        }

        @Override
        protected int getTextY() {
            int n = this.y();
            Objects.requireNonNull(this.textRenderer);
            return n + 9;
        }

        @Override
        protected int getTextStart() {
            return this.w() - this.textRenderer.method_1727(this.text()) - (this.isFocused() ? 10 : 4);
        }

        @Override
        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 69) {
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        @Override
        public void playDownSound(class_1144 soundManager) {
        }
    }
}

