/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.util.message;

import com.neep.meatlib.api.network.ParamCodec;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public interface DataVariant {
    public static final DataVariant NULL = DataVariant.of(0.0f);
    public static final ParamCodec<DataVariant> PARAM_CODEC = ParamCodec.of(DataVariant.class, (o, b) -> b.method_10814(o.stringValue()), b -> DataVariant.of(b.method_19772()));
    public static final Pattern FLOAT_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?([eE]?\\d+)?");

    default public int intValue() {
        return Math.round(this.floatValue());
    }

    public float floatValue();

    public String stringValue();

    public static float toFloat(String s) {
        if (FLOAT_PATTERN.asMatchPredicate().test(s)) {
            try {
                return Float.parseFloat(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public static DataVariant of(float f) {
        return new FloatDataVariant(f);
    }

    public static DataVariant of(String s) {
        if (FLOAT_PATTERN.asMatchPredicate().test(s)) {
            try {
                return new FloatDataVariant(Float.parseFloat(s));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new StringDataVariant(s);
    }

    default public boolean isNumeric() {
        return FLOAT_PATTERN.asMatchPredicate().test(this.stringValue());
    }

    public record FloatDataVariant(float f) implements DataVariant
    {
        @Override
        public float floatValue() {
            return this.f;
        }

        @Override
        public String stringValue() {
            return String.valueOf(this.f);
        }

        @Override
        @NotNull
        public String toString() {
            return this.stringValue();
        }
    }

    public record StringDataVariant(String s) implements DataVariant
    {
        @Override
        public float floatValue() {
            return DataVariant.toFloat(this.s);
        }

        @Override
        public String stringValue() {
            return this.s;
        }

        @Override
        @NotNull
        public String toString() {
            return this.stringValue();
        }
    }
}

