/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.plc.robot;

import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.robot.RobotAction;
import com.neep.neepmeat.neepasm.NeepASM;
import java.util.List;
import net.minecraft.class_2487;

public class GroupedRobotAction
implements RobotAction,
NbtSerialisable {
    protected final List<RobotAction> actions;
    protected int index = 0;
    private boolean start;

    public GroupedRobotAction(List<RobotAction> actions) {
        this.actions = actions;
    }

    public static GroupedRobotAction of(RobotAction ... actions) {
        return new GroupedRobotAction(List.of(actions));
    }

    @Override
    public boolean finished(PLC plc) {
        return this.index >= this.actions.size();
    }

    @Override
    public void start(PLC plc) {
        this.start = true;
    }

    @Override
    public void tick(PLC plc) throws NeepASM.RuntimeException {
        if (this.index >= this.actions.size()) {
            return;
        }
        RobotAction action = this.actions.get(this.index);
        if (this.start) {
            action.start(plc);
            this.start = false;
        }
        action.tick(plc);
        if (action.finished(plc)) {
            action.end(plc);
            ++this.index;
            this.start = true;
        }
    }

    @Override
    public void end(PLC plc) {
        this.index = 0;
        this.start = true;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10569("index", this.index);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.index = nbt.method_10550("index");
    }

    public void setFinished(PLC plc) {
        this.index = this.actions.size();
    }
}

