/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.processing;

import com.neep.meatlib.api.event.DataPackPostProcess;
import com.neep.meatlib.network.PacketBufUtil;
import com.neep.meatlib.recipe.ingredient.Ingredients;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.mixin.loot.CombinedEntryAccessor;
import com.neep.neepmeat.mixin.loot.ConstantLootNumberProviderAccessor;
import com.neep.neepmeat.mixin.loot.ItemEntryAccessor;
import com.neep.neepmeat.mixin.loot.LeafEntryAccessor;
import com.neep.neepmeat.mixin.loot.SetCountLootFunctionAccessor;
import com.neep.neepmeat.mixin.loot.UniformLootNumberProviderAccessor;
import com.neep.neepmeat.recipe.AdvancedBlockCrushingRecipe;
import com.neep.neepmeat.recipe.BlockCrushingRecipe;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_60;
import net.minecraft.class_634;
import net.minecraft.class_65;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockCrushingRegistry {
    public static final class_2960 CHANNEL_ID = new class_2960("neepmeat", "block_crushing_sync");
    public static final BlockCrushingRegistry INSTANCE = new BlockCrushingRegistry();
    private final Map<ItemVariant, Entry> basicInputToEntry = new HashMap<ItemVariant, Entry>();
    private final Map<ItemVariant, Entry> advancedInputToEntry = new HashMap<ItemVariant, Entry>();
    @Nullable
    private BlockCrushingRecipe blockCrushingRecipe;
    @Nullable
    private AdvancedBlockCrushingRecipe advancedBlockCrushingRecipe;

    private BlockCrushingRegistry() {
    }

    public void read(class_1863 manager, class_2540 buf) {
        this.blockCrushingRecipe = BlockCrushingRecipe.get(manager);
        this.advancedBlockCrushingRecipe = AdvancedBlockCrushingRecipe.get(manager);
        PacketBufUtil.readMap(buf, this.basicInputToEntry::put, ItemVariant::fromPacket, Entry::read);
        PacketBufUtil.readMap(buf, this.advancedInputToEntry::put, ItemVariant::fromPacket, Entry::read);
    }

    private void write(class_2540 buf) {
        PacketBufUtil.writeMap(buf, this.basicInputToEntry, TransferVariant::toPacket, Entry::write);
        PacketBufUtil.writeMap(buf, this.advancedInputToEntry, TransferVariant::toPacket, Entry::write);
    }

    public static void init() {
        DataPackPostProcess.AFTER_DATA_PACK_LOAD.register(INSTANCE::reload);
        DataPackPostProcess.SYNC.register(BlockCrushingRegistry::sync);
    }

    private void reload(MinecraftServer server) {
        class_1863 recipeManager = server.method_3772();
        class_60 lootManager = server.method_3857();
        this.blockCrushingRecipe = BlockCrushingRecipe.get(recipeManager);
        this.advancedBlockCrushingRecipe = AdvancedBlockCrushingRecipe.get(recipeManager);
        this.searchForLootTables(lootManager);
    }

    private static void sync(MinecraftServer server, @NotNull Set<class_3222> players) {
        class_2540 buf = PacketByteBufs.create();
        INSTANCE.write(buf);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)CHANNEL_ID, (class_2540)buf);
        }
    }

    @Nullable
    public Entry getFromInputBasic(ItemVariant input) {
        return this.basicInputToEntry.get(input);
    }

    @Nullable
    public Entry getFromInputAdvanced(ItemVariant input) {
        return this.advancedInputToEntry.get(input);
    }

    private void searchForLootTables(class_60 lootManager) {
        NeepMeat.LOGGER.info("Searching for block crushing loot tables");
        class_6862<class_2248> inputs = NMTags.BLOCK_CRUSHING_INPUTS;
        class_2378.field_11142.method_10220().filter(i -> i instanceof class_1747).map(i -> (class_1747)i).filter(i -> i.method_7711().method_40142().method_40220(inputs)).forEach(i -> this.inspectLootTable(lootManager, (class_1747)i));
    }

    private void inspectLootTable(class_60 lootManager, class_1747 blockItem) {
        if (this.advancedBlockCrushingRecipe == null && this.blockCrushingRecipe == null) {
            return;
        }
        class_6862<class_1792> outputs = NMTags.BLOCK_CRUSHING_OUTPUTS;
        class_52 lootTable = lootManager.method_367(blockItem.method_7711().method_26162());
        for (class_55 pool : lootTable.field_943) {
            for (class_79 entry : pool.field_953) {
                if (!(entry instanceof class_65)) continue;
                class_65 alternativeEntry = (class_65)entry;
                for (class_79 child : ((CombinedEntryAccessor)alternativeEntry).getChildren()) {
                    class_117[] lootFunctions;
                    class_77 itemEntry;
                    class_1792 outputItem;
                    boolean isRawOre;
                    if (!(child instanceof class_77) || !(isRawOre = (outputItem = ((ItemEntryAccessor)(itemEntry = (class_77)child)).getItem()).method_40131().method_40220(outputs))) continue;
                    int min = 1;
                    int max = 1;
                    for (class_117 function : lootFunctions = ((LeafEntryAccessor)itemEntry).getFunctions()) {
                        class_44 constant;
                        class_141 setCount;
                        class_5658 number;
                        if (!(function instanceof class_141) || !((number = ((SetCountLootFunctionAccessor)(setCount = (class_141)function)).getCountRange()) instanceof class_5662)) continue;
                        class_5662 uniform = (class_5662)number;
                        class_5658 class_56582 = ((UniformLootNumberProviderAccessor)uniform).getMin();
                        if (class_56582 instanceof class_44) {
                            constant = (class_44)class_56582;
                            min = (int)((ConstantLootNumberProviderAccessor)constant).getValue();
                        }
                        if (!((class_56582 = ((UniformLootNumberProviderAccessor)uniform).getMax()) instanceof class_44)) continue;
                        constant = (class_44)class_56582;
                        max = (int)((ConstantLootNumberProviderAccessor)constant).getValue();
                    }
                    if (max < min) {
                        max = min;
                    }
                    this.register((class_1792)blockItem, outputItem, min, max);
                    return;
                }
            }
        }
    }

    private void register(class_1792 inputVariant, class_1792 outputItem, int min, int max) {
        if (this.blockCrushingRecipe != null) {
            this.basicInputToEntry.put(ItemVariant.of((class_1935)inputVariant), this.create(inputVariant, outputItem, this.blockCrushingRecipe, min, max));
        }
        if (this.advancedBlockCrushingRecipe != null) {
            this.advancedInputToEntry.put(ItemVariant.of((class_1935)inputVariant), this.create(inputVariant, outputItem, this.advancedBlockCrushingRecipe, min, max));
        }
    }

    private Entry create(class_1792 inputItem, class_1792 outputItem, BlockCrushingRecipe recipe, int min, int max) {
        min = (int)Math.max(recipe.getBaseAmount(), (long)min);
        max = (int)Math.max(recipe.getBaseAmount(), (long)max);
        int extraAmount = (int)recipe.getExtraAmount();
        RegistryRecipeInput<class_1792> input = RecipeInputs.of(inputItem, 1L);
        RecipeOutputImpl<class_1792> output = new RecipeOutputImpl<class_1792>(outputItem, min, max, 1.0f, Ingredients.ITEM);
        RecipeOutputImpl<class_1792> extra = new RecipeOutputImpl<class_1792>(outputItem, extraAmount, extraAmount, 0.5f, Ingredients.ITEM);
        return new Entry(input, output, extra);
    }

    public Collection<Entry> getBasicEntries() {
        return this.basicInputToEntry.values();
    }

    public Collection<Entry> getAdvancedEntries() {
        return this.advancedInputToEntry.values();
    }

    public record Entry(RegistryRecipeInput<class_1792> input, RecipeOutput<class_1792> output, RecipeOutput<class_1792> extra) {
        public static Entry read(class_2540 buf) {
            RegistryRecipeInput<class_1792> input = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_1792> output = RecipeOutputImpl.read(class_2378.field_11142, buf);
            RecipeOutputImpl<class_1792> extra = RecipeOutputImpl.read(class_2378.field_11142, buf);
            return new Entry(input, output, extra);
        }

        public void write(class_2540 buf) {
            this.input.write(buf);
            this.output.write(buf);
            this.extra.write(buf);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static void onPacket(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
            if (client.field_1687 != null) {
                INSTANCE.read(client.field_1687.method_8433(), buf);
            }
        }
    }
}

