/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.processing;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.neep.meatlib.api.event.DataPackPostProcess;
import com.neep.meatlib.mixin.RecipeManagerAccessor;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.processing.OreFatSyncS2CPacket;
import com.neep.neepmeat.fluid.ore_fat.OreFatFluidFactory;
import com.neep.neepmeat.init.NMFluids;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class OreFatRegistry
implements SimpleSynchronousResourceReloadListener {
    public static final class_2960 SYNC_ID = new class_2960("neepmeat", "ore_fat");
    public static final OreFatRegistry INSTANCE = new OreFatRegistry();
    private final Set<class_6862<class_1792>> generateForTags = Sets.newHashSet();
    private final Set<class_2960> generateForItems = Sets.newHashSet();
    private final Map<class_1792, Entry> outputToEntry = Maps.newHashMap();
    private final Map<class_1792, Entry> inputToEntry = Maps.newHashMap();
    private final Map<class_2487, Entry> nbtToEntry = Maps.newHashMap();
    private final Multimap<Entry, class_1792> collectedInputs = Multimaps.newSetMultimap(new HashMap(), HashSet::new);

    public static void init() {
        DataPackPostProcess.AFTER_DATA_PACK_LOAD.register(INSTANCE::generate);
        DataPackPostProcess.SYNC.register(INSTANCE::sync);
    }

    @Nullable
    public static Entry get(class_2487 nbt) {
        return OreFatRegistry.INSTANCE.nbtToEntry.get(nbt);
    }

    @Nullable
    public static Entry getFromInput(class_1792 item) {
        return OreFatRegistry.INSTANCE.inputToEntry.get(item);
    }

    @Nullable
    public static Entry getFromVariant(FluidVariant variant) {
        if (variant.getObject() instanceof OreFatFluidFactory.Main) {
            class_2487 nbt = variant.getNbt();
            return OreFatRegistry.INSTANCE.nbtToEntry.get(nbt);
        }
        return null;
    }

    private void addTag(class_2960 id) {
        this.generateForTags.add((class_6862<class_1792>)class_6862.method_40092((class_5321)class_2378.field_11142.method_30517(), (class_2960)id));
    }

    private void generate(MinecraftServer server) {
        RecipeManagerAccessor manager = (RecipeManagerAccessor)server.method_3772();
        Map smeltingRecipes = manager.callGetAllOfType(class_3956.field_17546);
        Map blastingRecipes = manager.callGetAllOfType(class_3956.field_17547);
        Streams.concat((Stream[])new Stream[]{smeltingRecipes.values().stream(), blastingRecipes.values().stream()}).forEach(recipe -> {
            class_2371 ingredients = recipe.method_8117();
            class_1799 output = recipe.method_8110();
            this.testIngredient((Collection<class_1856>)ingredients, output);
        });
        NeepMeat.LOGGER.info("Generated {} ore fat routes", (Object)this.inputToEntry.size());
    }

    private void sync(MinecraftServer server, Set<class_3222> players) {
        OreFatSyncS2CPacket packet = new OreFatSyncS2CPacket(this.nbtToEntry);
        class_2540 buf = PacketByteBufs.create();
        packet.write(buf);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SYNC_ID, (class_2540)buf);
        }
    }

    public void onPacket(OreFatSyncS2CPacket t) {
        this.nbtToEntry.clear();
        this.nbtToEntry.putAll(t.nbtToEntry());
    }

    private void testIngredient(Collection<class_1856> input, class_1799 output) {
        if (output.method_7960()) {
            return;
        }
        if (input.isEmpty()) {
            return;
        }
        for (class_1856 ingredient : input) {
            if (ingredient.method_8103()) continue;
            for (class_1799 stack : ingredient.method_8105()) {
                class_2960 itemId = stack.method_7909().method_40131().method_40237().method_29177();
                if (!stack.method_40133().anyMatch(this.generateForTags::contains) && !this.generateForItems.contains(itemId)) continue;
                this.registerDefaultEntry(stack.method_7909(), ItemVariant.of((class_1799)output));
            }
        }
    }

    private void registerDefaultEntry(class_1792 input, ItemVariant output) {
        class_2487 nbt = this.createNbt(output.getItem());
        Entry entry = this.outputToEntry.computeIfAbsent(output.getItem(), i -> new Entry(this.createName(output.getItem(), NMFluids.DIRTY_ORE_FAT), this.createName(output.getItem(), NMFluids.CLEAN_ORE_FAT), output, nbt, ((Float)NeepMeat.CONFIG.oreFat.defaultRenderingYield.getRealValue()).floatValue(), ((Float)NeepMeat.CONFIG.oreFat.defaultTrommelYield.getRealValue()).floatValue()));
        this.nbtToEntry.put(nbt, entry);
        this.addInput(entry, input);
    }

    private class_2487 createNbt(class_1792 outputItem) {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10582("item", class_2378.field_11142.method_10221((Object)outputItem).toString());
        return nbtCompound;
    }

    private class_2561 createName(class_1792 outputItem, class_2248 fluid) {
        return class_2561.method_43469((String)fluid.method_9539(), (Object[])new Object[]{outputItem.method_7848()});
    }

    public class_1792 getItem(FluidVariant variant) {
        class_2487 nbt = variant.getNbt();
        if (variant.getObject() instanceof OreFatFluidFactory.Main && nbt != null) {
            return (class_1792)class_2378.field_11142.method_10223(new class_2960(nbt.method_10558("item")));
        }
        return null;
    }

    public FluidVariant getDirty(class_1792 ore) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("item", class_2378.field_11142.method_10221((Object)ore).toString());
        return FluidVariant.of((class_3611)NMFluids.STILL_DIRTY_ORE_FAT, (class_2487)nbt);
    }

    public class_2960 getFabricId() {
        return new class_2960("neepmeat", "ore_fat");
    }

    public void method_14491(class_3300 manager) {
        this.inputToEntry.clear();
        this.nbtToEntry.clear();
        this.outputToEntry.clear();
        this.collectedInputs.clear();
        for (class_2960 id : manager.method_14488("ore_fat", path -> path.method_12832().endsWith("/fat.json")).keySet()) {
            if (!manager.method_14486(id).isPresent()) continue;
            try {
                InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                try {
                    InputStreamReader reader = new InputStreamReader(stream);
                    JsonElement rootElement = JsonParser.parseReader((Reader)reader);
                    JsonObject rootObject = (JsonObject)rootElement;
                    if (rootObject.has("replace") && class_3518.method_15270((JsonObject)rootObject, (String)"replace")) {
                        this.generateForTags.clear();
                        this.generateForItems.clear();
                    }
                    JsonArray generateForTags = class_3518.method_15261((JsonObject)rootObject, (String)"generate_for_tags");
                    generateForTags.forEach(e -> {
                        class_2960 tagId = class_2960.method_12829((String)e.getAsString());
                        this.addTag(tagId);
                    });
                    JsonArray generateForItems = class_3518.method_15261((JsonObject)rootObject, (String)"generate_for_items");
                    generateForItems.forEach(e -> {
                        class_2960 itemId = class_2960.method_12829((String)e.getAsString());
                        this.generateForItems.add(itemId);
                    });
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e2) {
                NeepMeat.LOGGER.error("Error while reading ore fat " + id.toString(), (Throwable)e2);
            }
        }
        this.readOverrides(manager);
    }

    private void readOverrides(class_3300 manager) {
        for (class_2960 id : manager.method_14488("ore_fat/overrides", path -> path.method_12832().endsWith(".json")).keySet()) {
            if (!manager.method_14486(id).isPresent()) continue;
            try {
                InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                try {
                    InputStreamReader reader = new InputStreamReader(stream);
                    JsonElement rootElement = JsonParser.parseReader((Reader)reader);
                    JsonObject rootObject = (JsonObject)rootElement;
                    String resourceName = class_3518.method_15265((JsonObject)rootObject, (String)"output");
                    class_1792 result = (class_1792)class_2378.field_11142.method_10223(class_2960.method_12829((String)resourceName));
                    class_2561 dirtyFatName = this.createName(result, NMFluids.DIRTY_ORE_FAT);
                    if (rootObject.has("dirty_fat_name")) {
                        dirtyFatName = class_2561.method_43471((String)class_3518.method_15265((JsonObject)rootObject, (String)"dirty_fat_name"));
                    }
                    class_2561 cleanFatName = this.createName(result, NMFluids.CLEAN_ORE_FAT);
                    if (rootObject.has("clean_fat_name")) {
                        cleanFatName = class_2561.method_43471((String)class_3518.method_15265((JsonObject)rootObject, (String)"clean_fat_name"));
                    }
                    float renderingYield = ((Float)NeepMeat.CONFIG.oreFat.defaultRenderingYield.getRealValue()).floatValue();
                    if (rootObject.has("rendering_yield")) {
                        renderingYield = class_3518.method_15259((JsonObject)rootObject, (String)"rendering_yield");
                    }
                    float trommelYield = ((Float)NeepMeat.CONFIG.oreFat.defaultTrommelYield.getRealValue()).floatValue();
                    if (rootObject.has("trommel_yield")) {
                        trommelYield = class_3518.method_15259((JsonObject)rootObject, (String)"trommel_yield");
                    }
                    Entry entry = new Entry(dirtyFatName, cleanFatName, ItemVariant.of((class_1935)result), this.createNbt(result), renderingYield, trommelYield);
                    this.outputToEntry.put(result, entry);
                    this.nbtToEntry.put(this.createNbt(result), entry);
                    if (!rootObject.has("inputs")) continue;
                    JsonArray inputs = class_3518.method_15261((JsonObject)rootObject, (String)"inputs");
                    for (JsonElement inputObject : inputs) {
                        String inputName = inputObject.getAsString();
                        class_1792 input = (class_1792)class_2378.field_11142.method_10223(class_2960.method_12829((String)inputName));
                        this.addInput(entry, input);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                NeepMeat.LOGGER.error("Error while reading ore fat override " + id.toString(), (Throwable)e);
            }
        }
    }

    private void addInput(Entry entry, class_1792 input) {
        this.collectedInputs.put((Object)entry, (Object)input);
        this.inputToEntry.put(input, entry);
    }

    public Multimap<Entry, class_1792> getCollectedInputs() {
        return this.collectedInputs;
    }

    public record Entry(class_2561 dirtyFatName, class_2561 cleanFatName, ItemVariant result, class_2487 nbt, float renderingYield, float trommelYield) {
        public static Entry read(class_2540 buf) {
            return new Entry((class_2561)class_2561.class_2562.method_10877((String)buf.method_19772()), (class_2561)class_2561.class_2562.method_10877((String)buf.method_19772()), ItemVariant.fromPacket((class_2540)buf), buf.method_10798(), buf.readFloat(), buf.readFloat());
        }

        public void write(class_2540 buf) {
            buf.method_10814(class_2561.class_2562.method_10867((class_2561)this.dirtyFatName));
            buf.method_10814(class_2561.class_2562.method_10867((class_2561)this.cleanFatName));
            this.result.toPacket(buf);
            buf.method_10794(this.nbt);
            buf.writeFloat(this.renderingYield);
            buf.writeFloat(this.trommelYield);
        }

        public FluidVariant getDirty() {
            return FluidVariant.of((class_3611)NMFluids.STILL_DIRTY_ORE_FAT, (class_2487)this.nbt);
        }

        public FluidVariant getClean() {
            return FluidVariant.of((class_3611)NMFluids.STILL_CLEAN_ORE_FAT, (class_2487)this.nbt);
        }
    }
}

