/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.storage;

import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2586;

public class TypedFluidBuffer
extends WritableSingleFluidStorage
implements Storage<FluidVariant> {
    protected Predicate<FluidVariant> validTypes;
    protected Mode mode;
    protected long capacity;
    protected class_2586 parent;

    public TypedFluidBuffer(long capacity, Predicate<FluidVariant> validTypes, Mode mode, Runnable finalCallback) {
        super(capacity, finalCallback);
        this.validTypes = validTypes;
        this.mode = mode;
        this.capacity = capacity;
    }

    protected boolean canInsert(FluidVariant variant) {
        return this.validTypes.test(variant);
    }

    protected boolean canExtract(FluidVariant variant) {
        return true;
    }

    @Override
    protected FluidVariant getBlankVariant() {
        return FluidVariant.blank();
    }

    @Override
    protected long getCapacity(FluidVariant variant) {
        return this.capacity;
    }

    @Override
    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.mode.canInsert()) {
            return 0L;
        }
        return this.insertDirect(resource, maxAmount, transaction);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.mode.canExtract()) {
            return 0L;
        }
        return this.extractDirect(resource, maxAmount, transaction);
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public long insertDirect(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.validTypes.test(resource)) {
            return 0L;
        }
        if (this.getResource() == null || ((FluidVariant)this.getResource()).isBlank() || this.getAmount() <= 0L) {
            this.amount = 0L;
            this.variant = resource;
        }
        long inserted = Math.min(maxAmount, this.getCapacity() - this.getAmount());
        if (((FluidVariant)this.getResource()).equals(resource) && inserted > 0L) {
            this.updateSnapshots(transaction);
            this.amount += inserted;
            return inserted;
        }
        return 0L;
    }

    public long extractDirect(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.getResource() == null || ((FluidVariant)this.getResource()).isBlank() || this.getAmount() <= 0L) {
            this.amount = 0L;
            return 0L;
        }
        long extracted = Math.min(maxAmount, this.getAmount());
        if (extracted > 0L && resource.equals(this.getResource())) {
            this.updateSnapshots(transaction);
            this.amount -= extracted;
            return extracted;
        }
        return 0L;
    }

    public void clear() {
        this.amount = 0L;
        this.variant = FluidVariant.blank();
    }

    public boolean supportsInsertion() {
        return this.mode.canInsert();
    }

    public boolean supportsExtraction() {
        return this.mode.canExtract();
    }

    public static enum Mode {
        INSERT_EXTRACT,
        INSERT_ONLY,
        EXTRACT_ONLY;


        boolean canInsert() {
            return this == INSERT_EXTRACT || this == INSERT_ONLY;
        }

        boolean canExtract() {
            return this == INSERT_EXTRACT || this == EXTRACT_ONLY;
        }
    }
}

