/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.hud;

import com.neep.neepmeat.api.big_block.BlockPlacementPreview;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.plc.PLCHudRenderer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class BigBlockPlacementHelper {
    @Nullable
    private static Result RESULT;

    public static void init() {
        WorldRenderEvents.BLOCK_OUTLINE.register(BigBlockPlacementHelper::onRender);
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null && client.field_1724 != null) {
                BigBlockPlacementHelper.tick(client);
            }
        });
    }

    private static void tick(class_310 client) {
        class_1747 blockItem;
        class_1799 mainStack = client.field_1724.method_6047();
        class_1792 class_17922 = mainStack.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof BlockPlacementPreview) {
            BlockPlacementPreview bigBlock = (BlockPlacementPreview)class_17922;
            class_17922 = client.field_1765;
            if (class_17922 instanceof class_3965) {
                class_3965 hitResult = (class_3965)class_17922;
                hitResult = bigBlock.modifyHitPos(hitResult);
                class_1750 itemPlacementContext = new class_1750((class_1657)client.field_1724, client.field_1724.field_6266, mainStack, hitResult);
                class_2338 pos = itemPlacementContext.method_8037();
                boolean place = itemPlacementContext.method_7716();
                class_2680 placementState = bigBlock.getPlacementStatePreview(itemPlacementContext);
                if (placementState != null) {
                    place = place && bigBlock.canPlaceAtPreview(placementState, client.field_1687, pos);
                    RESULT = new Result(bigBlock.getVolume(placementState).toVoxelShape(), pos, place ? PLCCols.BORDER.col : PLCCols.ERROR_LINE.col);
                }
                return;
            }
        }
        RESULT = null;
    }

    private static boolean onRender(WorldRenderContext wrctx, WorldRenderContext.BlockOutlineContext blockOutlineContext) {
        if (RESULT != null) {
            class_310 client = class_310.method_1551();
            class_2338 pos = RESULT.pos();
            class_243 camPos = client.field_1773.method_19418().method_19326();
            int col = RESULT.col();
            PLCHudRenderer.drawCuboidShapeOutline(wrctx.matrixStack(), wrctx.consumers().getBuffer(class_1921.method_23594()), RESULT.shape(), (double)pos.method_10263() - camPos.field_1352, (double)pos.method_10264() - camPos.field_1351, (double)pos.method_10260() - camPos.field_1350, (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col >> 0 & 0xFF) / 255.0f, 1.0f);
            return false;
        }
        return true;
    }

    private record Result(class_265 shape, class_2338 pos, int col) {
    }
}

