/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.instance;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.neep.meatlib.client.RotationAxis;
import com.neep.neepmeat.client.NMExtraModels;
import com.neep.neepmeat.machine.reactor.block.entity.DisruptorSegmentBlockEntity;
import com.neep.neepmeat.machine.reactor.disruptor.DisruptorSegmentBlock;
import net.minecraft.class_1158;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class DisruptorSegmentInstance
extends BlockEntityInstance<DisruptorSegmentBlockEntity>
implements DynamicInstance {
    private final ModelData centre;
    private final ModelData[] arms;
    private float rotSpeedRadians;
    private float rotation;
    private float lerpExtension = -1.0f;

    public DisruptorSegmentInstance(MaterialManager materialManager, DisruptorSegmentBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
        this.centre = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(NMExtraModels.DISRUPTOR_SEGMENT_CENTRE).createInstance();
        this.arms = new ModelData[4];
        for (int i = 0; i < 4; ++i) {
            this.arms[i] = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(NMExtraModels.DISRUPTOR_SEGMENT_ARM).createInstance();
        }
    }

    protected void remove() {
        this.centre.delete();
        for (ModelData arm : this.arms) {
            arm.delete();
        }
    }

    public void beginFrame() {
        if (!class_310.method_1551().method_1493()) {
            this.rotSpeedRadians = class_3532.method_16439((float)0.1f, (float)this.rotSpeedRadians, (float)(((DisruptorSegmentBlockEntity)this.blockEntity).progressIncrement() * 0.1f));
            this.rotation += this.rotSpeedRadians;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)((DisruptorSegmentBlockEntity)this.blockEntity).method_11010().method_11654(DisruptorSegmentBlock.AXIS);
        ((ModelData)((ModelData)((ModelData)this.centre.loadIdentity().translate((class_2382)this.getInstancePosition())).centre()).multiply(this.getRotation(axis)).rotate(class_2350.field_11036, this.rotation)).unCentre();
        float extension = -0.6875f * class_3532.method_15363((float)((float)((DisruptorSegmentBlockEntity)this.blockEntity).getDisruption() / 20.0f), (float)0.0f, (float)1.0f);
        this.lerpExtension = this.lerpExtension == -1.0f ? extension : class_3532.method_16439((float)0.1f, (float)this.lerpExtension, (float)extension);
        for (int i = 0; i < this.arms.length; ++i) {
            ((ModelData)((ModelData)((ModelData)((ModelData)this.arms[i].loadIdentity().translate((class_2382)this.getInstancePosition())).centre()).multiply(this.getRotation(axis)).rotate(class_2350.field_11036, (float)i / 4.0f * ((float)Math.PI * 2) + this.rotation)).unCentre()).translate(0.0, 0.0, (double)this.lerpExtension);
        }
    }

    private class_1158 getRotation(class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> RotationAxis.NEGATIVE_Z.rotationDegrees(90.0f);
            case class_2350.class_2351.field_11052 -> class_1158.field_21493;
            case class_2350.class_2351.field_11051 -> RotationAxis.NEGATIVE_X.rotationDegrees(90.0f);
        };
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.getWorldPosition(), (FlatLit[])this.arms);
        this.relight(this.getWorldPosition(), new FlatLit[]{this.centre});
    }
}

