/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.instance;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.neep.neepmeat.client.NMExtraModels;
import com.neep.neepmeat.entity.skyworm.SkywormEntity;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_3532;

public class SkywormInstance
extends EntityInstance<SkywormEntity>
implements DynamicInstance {
    private final List<ModelData> body;
    private final FloatList scales = new FloatArrayList();

    public SkywormInstance(MaterialManager materialManager, SkywormEntity entity) {
        super(materialManager, (class_1297)entity);
        this.body = new ObjectArrayList();
        for (int i = 0; i < entity.getLength(); ++i) {
            this.body.add((ModelData)materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(NMExtraModels.SKYWORM_SEGMENT).createInstance());
            this.scales.add(1.0f);
        }
    }

    public void beginFrame() {
        int segmentHeight = 5;
        float tickDelta = AnimationTickHolder.getPartialTicks();
        float twistOffset = 0.4f;
        float wobbleMagnitude = ((SkywormEntity)this.entity).allowWobble() ? 0.3f : 0.1f;
        float wobbleX = class_3532.method_15374((float)(((float)((SkywormEntity)this.entity).field_6012 + tickDelta) / 10.0f)) * wobbleMagnitude;
        float wobbleZ = class_3532.method_15362((float)(((float)((SkywormEntity)this.entity).field_6012 + tickDelta) / 15.0f)) * wobbleMagnitude;
        boolean below = ((SkywormEntity)this.entity).getFromBelow();
        int m = below ? -1 : 1;
        int bulgeIdx = ((SkywormEntity)this.entity).getBulge();
        for (int i = 0; i < this.body.size(); ++i) {
            float scale = this.scales.getFloat(i);
            if (i == bulgeIdx) {
                scale = 1.2f;
            }
            scale = class_3532.method_16439((float)0.1f, (float)scale, (float)1.0f);
            this.scales.set(i, scale);
            float angle = 0.0f;
            float twist = this.getInstancePosition(tickDelta).method_4945() / 10.0f + (float)i * (float)Math.PI / 5.0f;
            ((ModelData)((ModelData)((ModelData)this.body.get(i).loadIdentity().translate(this.getInstancePosition(tickDelta))).translate(0.0, (double)(m * i * segmentHeight - (below ? segmentHeight - 1 : 0)), 0.0).translate((double)wobbleX, 0.0, (double)wobbleZ).scale(scale, scale, scale).translate((double)twistOffset, 0.0, 0.0).rotate(class_2350.field_11036, twist)).translate((double)(-twistOffset), 0.0, 0.0).rotate(class_2350.field_11036, angle)).translate(-0.5, 0.0, -0.5);
        }
    }

    public boolean decreaseFramerateWithDistance() {
        return false;
    }

    public void updateLight() {
        this.relight(this.getWorldPosition(), this.body.stream());
    }

    protected void remove() {
        for (ModelData modelData : this.body) {
            modelData.delete();
        }
    }
}

