/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.plc;

import com.neep.meatlib.client.event.KeyboardEvents;
import com.neep.neepmeat.client.plc.PLCMotionController;
import com.neep.neepmeat.client.screen.plc.PLCProgramScreen;
import com.neep.neepmeat.machine.surgical_controller.SurgicalRobot;
import com.neep.neepmeat.mixin.client.CameraAccessor;
import com.neep.neepmeat.network.plc.PLCRobotEnterS2C;
import com.neep.neepmeat.plc.block.entity.PLCBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PLCHudRenderer {
    @Nullable
    public static class_3965 HIT_RESULT;
    public static class_1159 PROJECTION;
    public static class_1159 MODEL_VIEW;
    @Nullable
    private static PLCHudRenderer INSTANCE;
    private final PLCBlockEntity be;
    private final SurgicalRobot.Client robotClient;
    private final class_310 client = class_310.method_1551();
    private final PLCMotionController controller;
    private final class_4184 camera;

    private PLCHudRenderer(PLCBlockEntity be) {
        this.be = be;
        this.robotClient = new SurgicalRobot.Client(be.getSurgeryRobot(), be);
        this.be.getSurgeryRobot().setController((class_1657)this.client.field_1724);
        this.controller = new PLCMotionController(be.getSurgeryRobot());
        this.camera = this.client.field_1773.method_19418();
        this.robotClient.resetKeys();
    }

    @Nullable
    public static PLCHudRenderer getInstance() {
        return INSTANCE;
    }

    public static void enter(PLCBlockEntity be) {
        INSTANCE = new PLCHudRenderer(be);
    }

    public static boolean active() {
        return INSTANCE != null;
    }

    public static void leave() {
        if (INSTANCE != null) {
            INSTANCE.exit();
        }
        INSTANCE = null;
    }

    public static void drawCuboidShapeOutline(class_4587 matrices, class_4588 vertexConsumer, class_265 shape, double offsetX, double offsetY, double offsetZ, float r, float g, float b, float a) {
        class_4587.class_4665 entry = matrices.method_23760();
        shape.method_1104((minX, minY, minZ, maxX, maxY, maxZ) -> {
            float k = (float)(maxX - minX);
            float l = (float)(maxY - minY);
            float m = (float)(maxZ - minZ);
            float n = class_3532.method_15355((float)(k * k + l * l + m * m));
            vertexConsumer.method_22918(entry.method_23761(), (float)(minX + offsetX), (float)(minY + offsetY), (float)(minZ + offsetZ)).method_22915(r, g, b, a).method_23763(entry.method_23762(), k /= n, l /= n, m /= n).method_1344();
            vertexConsumer.method_22918(entry.method_23761(), (float)(maxX + offsetX), (float)(maxY + offsetY), (float)(maxZ + offsetZ)).method_22915(r, g, b, a).method_23763(entry.method_23762(), k, l, m).method_1344();
        });
    }

    public static void init() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            PROJECTION = context.projectionMatrix().method_22673();
            MODEL_VIEW = context.matrixStack().method_23760().method_23761().method_22673();
        });
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            PLCHudRenderer instance = PLCHudRenderer.getInstance();
            if (instance != null) {
                instance.clientTick();
            }
        });
        WorldRenderEvents.BLOCK_OUTLINE.register((worldRenderContext, blockOutlineContext) -> {
            PLCHudRenderer instance = PLCHudRenderer.getInstance();
            if (instance != null) {
                instance.onOutlineRender(worldRenderContext, blockOutlineContext);
                return false;
            }
            return true;
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client1) -> PLCHudRenderer.leave());
        KeyboardEvents.PRE_INPUT.register((window, key, scancode, action, modifiers) -> {
            PLCProgramScreen ps;
            class_437 patt5338$temp;
            class_310 client = class_310.method_1551();
            PLCHudRenderer instance = PLCHudRenderer.getInstance();
            if (instance != null && (patt5338$temp = client.field_1755) instanceof PLCProgramScreen && (ps = (PLCProgramScreen)patt5338$temp).passEvents()) {
                instance.handleMovementKey(client, key, action != 0);
            }
            return false;
        });
    }

    private void handleMovementKey(class_310 client, int key, boolean pressed) {
        class_3675.class_306 forward = KeyBindingHelper.getBoundKeyOf((class_304)client.field_1690.field_1894);
        class_3675.class_306 back = KeyBindingHelper.getBoundKeyOf((class_304)client.field_1690.field_1881);
        class_3675.class_306 left = KeyBindingHelper.getBoundKeyOf((class_304)client.field_1690.field_1913);
        class_3675.class_306 right = KeyBindingHelper.getBoundKeyOf((class_304)client.field_1690.field_1849);
        class_3675.class_306 up = KeyBindingHelper.getBoundKeyOf((class_304)client.field_1690.field_1903);
        class_3675.class_306 down = KeyBindingHelper.getBoundKeyOf((class_304)client.field_1690.field_1832);
        if (key == forward.method_1444()) {
            this.robotClient.forwardKey = pressed;
        } else if (key == back.method_1444()) {
            this.robotClient.backKey = pressed;
        } else if (key == left.method_1444()) {
            this.robotClient.leftKey = pressed;
        } else if (key == right.method_1444()) {
            this.robotClient.rightKey = pressed;
        } else if (key == up.method_1444()) {
            this.robotClient.upKey = pressed;
        } else if (key == down.method_1444()) {
            this.robotClient.downKey = pressed;
        }
    }

    public void exit() {
        PLCRobotEnterS2C.Client.send(this.be);
        this.be.exit();
    }

    public boolean onRender() {
        return true;
    }

    public void onCameraUpdate(float tickDelta) {
        this.controller.update();
        SurgicalRobot robot = this.be.getSurgeryRobot();
        this.be.getSurgeryRobot().cameraX = class_3532.method_16436((double)0.1, (double)this.be.getSurgeryRobot().cameraX, (double)this.be.getSurgeryRobot().getX());
        this.be.getSurgeryRobot().cameraY = class_3532.method_16436((double)0.1, (double)this.be.getSurgeryRobot().cameraY, (double)this.be.getSurgeryRobot().getY());
        this.be.getSurgeryRobot().cameraZ = class_3532.method_16436((double)0.1, (double)this.be.getSurgeryRobot().cameraZ, (double)this.be.getSurgeryRobot().getZ());
        ((CameraAccessor)this.camera).callSetPos(robot.cameraX, robot.cameraY, robot.cameraZ);
        ((CameraAccessor)this.camera).callSetRotation(this.controller.lerpYaw, this.controller.lerpPitch);
        ((CameraAccessor)this.camera).setThirdPerson(true);
    }

    private void onOutlineRender(WorldRenderContext wrctx, WorldRenderContext.BlockOutlineContext boctx) {
        if (HIT_RESULT == null) {
            return;
        }
        wrctx.matrixStack().method_22903();
        class_2338 pos = HIT_RESULT.method_17777();
        class_243 camPos = this.camera.method_19326();
        class_2680 targetState = this.client.field_1687.method_8320(pos);
        class_265 shape = targetState.method_26172((class_1922)this.client.field_1687, pos, class_3726.method_16195((class_1297)this.client.field_1724));
        class_243 realPos = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        wrctx.matrixStack().method_22904(realPos.field_1352, realPos.field_1351, realPos.field_1350);
        PLCHudRenderer.drawCuboidShapeOutline(wrctx.matrixStack(), wrctx.consumers().getBuffer(class_1921.method_23594()), shape, -camPos.field_1352, -camPos.field_1351, -camPos.field_1350, 1.0f, 0.36f, 0.13f, 0.8f);
        wrctx.matrixStack().method_22909();
    }

    private void clientTick() {
        if (!this.client.method_1493()) {
            this.robotClient.tick();
        }
    }

    public PLCBlockEntity getBlockEntity() {
        return this.be;
    }

    public PLCMotionController getController() {
        return this.controller;
    }
}

