/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.renderer;

import com.neep.neepmeat.api.DataResource;
import com.neep.neepmeat.client.NMExtraModels;
import com.neep.neepmeat.client.renderer.BERenderUtils;
import com.neep.neepmeat.client.renderer.IntegratorEggModel;
import com.neep.neepmeat.machine.integrator.IntegratorBlockEntity;
import com.neep.neepmeat.util.NMMaths;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoBlockRenderer;

@Environment(value=EnvType.CLIENT)
public class IntegratorEggRenderer
extends GeoBlockRenderer<IntegratorBlockEntity> {
    private static final class_2960 LAYER = new class_2960("neepmeat", "textures/entity/integrator_basic_overlay.png");
    private final class_5819 random = class_5819.method_43047();

    public IntegratorEggRenderer(class_5614.class_5615 context) {
        super(new IntegratorEggModel());
    }

    public static void renderEgg(class_4587 matrices, IntegratorBlockEntity blockEntity, class_4597 vertexConsumers, float tickDelta) {
        matrices.method_22903();
        matrices.method_22903();
        if (blockEntity.canGrow()) {
            float eggScale = 1.0f + NMMaths.sin(blockEntity.method_10997().method_8510(), tickDelta, 0.02f) / 16.0f;
            matrices.method_22904(0.5, 0.0, 0.5);
            matrices.method_22905(eggScale, eggScale, eggScale);
            matrices.method_22904(-0.5, 0.0, -0.5);
        }
        class_776 manager = class_310.method_1551().method_1541();
        int overlay = 0;
        manager.method_3350().method_3374((class_1920)blockEntity.method_10997(), manager.method_3349(blockEntity.method_11010()), blockEntity.method_11010(), blockEntity.method_11016(), matrices, vertexConsumers.getBuffer(class_1921.method_23581()), true, class_5819.method_43047(), 0L, overlay);
        matrices.method_22909();
        matrices.method_22904(-1.0, 0.0, -1.0);
        matrices.method_22905(3.0f, 2.0f, 3.0f);
        matrices.method_22909();
    }

    public void render(IntegratorBlockEntity be, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int packedLightIn) {
        if (!be.isMature) {
            IntegratorEggRenderer.renderEgg(matrices, be, vertexConsumers, tickDelta);
        } else {
            class_241 vec = NMMaths.flattenY(be.getLookTarget().method_1020(class_243.method_24953((class_2382)be.method_11016())));
            be.targetFacing = NMMaths.getAngle(vec);
            be.facing = NMMaths.angleLerp(0.03f, be.facing, be.targetFacing);
            this.renderBase(matrices, be, vertexConsumers);
            matrices.method_22903();
            matrices.method_22904(0.5, 0.0, 0.5);
            matrices.method_22907(class_1160.field_20705.method_23626(be.facing));
            matrices.method_22904(-0.5, 0.0, -0.5);
            float s = NMMaths.sin(be.animationOffset + be.method_10997().method_8510(), tickDelta, 0.05f);
            matrices.method_22904(0.0, 1.8 + (double)(s / 15.0f), 0.0);
            AnimatedGeoModel modelProvider = this.getGeoModelProvider();
            GeoModel model = modelProvider.getModel(modelProvider.getModelResource((Object)be));
            modelProvider.setCustomAnimations((Object)be, this.getInstanceId(be));
            matrices.method_22903();
            matrices.method_22904(0.0, (double)0.01f, 0.0);
            matrices.method_22904(0.5, 0.0, 0.5);
            class_310.method_1551().method_1531().method_22813(this.getTextureLocation(be));
            Color renderColor = this.getRenderColor(be, tickDelta, matrices, vertexConsumers, null, packedLightIn);
            class_1921 renderType = this.getRenderType(be, tickDelta, matrices, vertexConsumers, null, packedLightIn, this.getTextureLocation(be));
            this.render(model, be, tickDelta, renderType, matrices, vertexConsumers, null, packedLightIn, class_4608.field_21444, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
            float dataPropt = (float)be.getData(DataResource.NORMAL) / 8192.0f;
            class_1921 cameo = class_1921.method_23580((class_2960)LAYER);
            this.render(model, be, tickDelta, cameo, matrices, vertexConsumers, vertexConsumers.getBuffer(cameo), packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, dataPropt);
            matrices.method_22909();
            matrices.method_22909();
        }
    }

    public void renderBase(class_4587 matrices, IntegratorBlockEntity be, class_4597 vertexConsumers) {
        BERenderUtils.renderModelSmooth(NMExtraModels.INTEGRATOR_BASE, matrices, be.method_10997(), be.method_11016(), vertexConsumers);
    }
}

