/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.neep.meatlib.client.screen.widget.AbstractClickableWidget;
import com.neep.neepmeat.api.plc.PLCCols;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1144;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTextField
extends AbstractClickableWidget {
    protected final class_327 textRenderer;
    protected boolean drawFancyBackground = true;
    private String text;
    private int maxLength;
    private boolean focusUnlocked;
    private boolean editable;
    private boolean selecting;
    protected int firstCharacterIndex;
    protected int selectionStart;
    protected int selectionEnd;
    protected int focusedTicks;
    protected int editableColor;
    protected int uneditableColor;
    @Nullable
    private Consumer<String> changedListener;
    private Predicate<String> textPredicate = Objects::nonNull;

    public AbstractTextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 text) {
        super(x, y, width, height, text);
        this.textRenderer = textRenderer;
        this.text = "";
        this.maxLength = 32;
        this.focusUnlocked = true;
        this.editable = true;
        this.editableColor = PLCCols.TEXT.col;
        this.uneditableColor = PLCCols.INVALID.col;
    }

    public boolean visible() {
        return this.visible;
    }

    public void setChangedListener(@Nullable Consumer<String> changedListener) {
        this.changedListener = changedListener;
    }

    public void tick() {
        ++this.focusedTicks;
    }

    protected class_5250 getNarrationMessage() {
        class_2561 text = this.getMessage();
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{text, this.text});
    }

    public String text() {
        return this.text;
    }

    public void setText(String text) {
        if (this.textPredicate.test(text)) {
            this.text = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.setCursorToEnd();
            this.setSelectionEnd(this.selectionStart);
            this.onChanged(text);
        }
    }

    public String getSelectedText() {
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void setTextPredicate(Predicate<String> textPredicate) {
        this.textPredicate = textPredicate;
    }

    public void write(String text) {
        String string2;
        String string;
        int l;
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        int k = this.maxLength - this.text.length() - (i - j);
        if (k < (l = (string = class_155.method_644((String)text)).length())) {
            string = string.substring(0, k);
            l = k;
        }
        if (this.textPredicate.test(string2 = new StringBuilder(this.text).replace(i, j, string).toString())) {
            this.text = string2;
            this.setSelectionStart(i + l);
            this.setSelectionEnd(this.selectionStart);
            this.onChanged(this.text);
        }
    }

    private void onChanged(String newText) {
        if (this.changedListener != null) {
            this.changedListener.accept(newText);
        }
    }

    private void erase(int offset) {
        if (class_437.method_25441()) {
            this.eraseWords(offset);
        } else {
            this.eraseCharacters(offset);
        }
    }

    public void eraseWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                this.eraseCharacters(this.getWordSkipPosition(wordOffset) - this.selectionStart);
            }
        }
    }

    public void eraseCharacters(int characterOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                String string;
                int k;
                int i = this.getCursorPosWithOffset(characterOffset);
                int j = Math.min(i, this.selectionStart);
                if (j != (k = Math.max(i, this.selectionStart)) && this.textPredicate.test(string = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = string;
                    this.setCursor(j);
                }
            }
        }
    }

    public int getWordSkipPosition(int wordOffset) {
        return this.getWordSkipPosition(wordOffset, this.getCursor());
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition) {
        return this.getWordSkipPosition(wordOffset, cursorPosition, true);
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition, boolean skipOverSpaces) {
        int i = cursorPosition;
        boolean bl = wordOffset < 0;
        int j = Math.abs(wordOffset);
        for (int k = 0; k < j; ++k) {
            if (!bl) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipOverSpaces && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipOverSpaces && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int offset) {
        this.setCursor(this.getCursorPosWithOffset(offset));
    }

    private int getCursorPosWithOffset(int offset) {
        return class_156.method_27761((String)this.text, (int)this.selectionStart, (int)offset);
    }

    public void setSelectionStart(int cursor) {
        this.selectionStart = class_3532.method_15340((int)cursor, (int)0, (int)this.text.length());
    }

    public void setCursorToStart() {
        this.setCursor(0);
    }

    public void setCursorToEnd() {
        this.setCursor(this.text.length());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.isActive()) {
            return false;
        }
        this.selecting = class_437.method_25442();
        if (class_437.method_25439((int)keyCode)) {
            this.setCursorToEnd();
            this.setSelectionEnd(0);
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            if (this.editable) {
                this.write(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            if (this.editable) {
                this.write("");
            }
            return true;
        }
        return switch (keyCode) {
            case 259 -> {
                if (this.editable) {
                    this.selecting = false;
                    this.erase(-1);
                    this.selecting = class_437.method_25442();
                }
                yield true;
            }
            default -> false;
            case 261 -> {
                if (this.editable) {
                    this.selecting = false;
                    this.erase(1);
                    this.selecting = class_437.method_25442();
                }
                yield true;
            }
            case 262 -> {
                if (class_437.method_25441()) {
                    this.setCursor(this.getWordSkipPosition(1));
                } else {
                    this.moveCursor(1);
                }
                yield true;
            }
            case 263 -> {
                if (class_437.method_25441()) {
                    this.setCursor(this.getWordSkipPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                yield true;
            }
            case 268 -> {
                this.setCursorToStart();
                yield true;
            }
            case 269 -> {
                this.setCursorToEnd();
                yield true;
            }
        };
    }

    public boolean isActive() {
        return this.visible() && this.isFocused() && this.isEditable();
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.isActive()) {
            return false;
        }
        if (class_155.method_643((char)chr)) {
            if (this.editable) {
                this.write(Character.toString(chr));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        int i = class_3532.method_15357((double)mouseX) - this.x();
        if (this.drawFancyBackground) {
            i -= 4;
        }
        String string = this.textRenderer.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
        this.setCursor(this.textRenderer.method_27523(string, i).length() + this.firstCharacterIndex);
    }

    @Override
    public void playDownSound(class_1144 soundManager) {
    }

    protected void drawSelectionHighlight(class_4587 context, int x1, int y1, int x2, int y2) {
        int i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        if (x2 > this.x() + this.width) {
            x2 = this.x() + this.width;
        }
        if (x1 > this.x() + this.width) {
            x1 = this.x() + this.width;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22912((double)x1, (double)y2, 0.0).method_1344();
        bufferBuilder.method_22912((double)x2, (double)y2, 0.0).method_1344();
        bufferBuilder.method_22912((double)x2, (double)y1, 0.0).method_1344();
        bufferBuilder.method_22912((double)x1, (double)y1, 0.0).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.text.length() > maxLength) {
            this.text = this.text.substring(0, maxLength);
            this.onChanged(this.text);
        }
    }

    public int getCursor() {
        return this.selectionStart;
    }

    public void setCursor(int cursor) {
        this.setSelectionStart(cursor);
        if (!this.selecting) {
            this.setSelectionEnd(this.selectionStart);
        }
        this.onChanged(this.text);
    }

    public int getCharacterX(int index) {
        return index > this.text.length() ? this.x() : this.x() + this.textRenderer.method_1727(this.text.substring(0, index));
    }

    public void setFocusUnlocked(boolean focusUnlocked) {
        this.focusUnlocked = focusUnlocked;
    }

    public void setDrawsBackground(boolean drawsBackground) {
        this.drawFancyBackground = drawsBackground;
    }

    public void setEditableColor(int editableColor) {
        this.editableColor = editableColor;
    }

    public void setUneditableColor(int uneditableColor) {
        this.uneditableColor = uneditableColor;
    }

    @Override
    public void setFocused(boolean focused) {
        if (this.focusUnlocked || focused) {
            super.setFocused(focused);
            if (focused) {
                this.focusedTicks = 0;
            }
        }
    }

    protected boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getInnerWidth() {
        return this.drawFancyBackground ? this.width - 8 : this.width;
    }

    public void setSelectionEnd(int index) {
        int i = this.text.length();
        this.selectionEnd = class_3532.method_15340((int)index, (int)0, (int)i);
        if (this.textRenderer != null) {
            if (this.firstCharacterIndex > i) {
                this.firstCharacterIndex = i;
            }
            int j = this.getInnerWidth();
            String string = this.textRenderer.method_27523(this.text.substring(this.firstCharacterIndex), j);
            int k = string.length() + this.firstCharacterIndex;
            if (this.selectionEnd == this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.textRenderer.method_27524(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.firstCharacterIndex += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.firstCharacterIndex - this.selectionEnd;
            }
            this.firstCharacterIndex = class_3532.method_15340((int)this.firstCharacterIndex, (int)0, (int)i);
        }
    }
}

