/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.screen.AbstractTextField;
import com.neep.neepmeat.client.screen.button.NMButtonWidget;
import java.util.function.BiFunction;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class NMTextField
extends AbstractTextField
implements Rectangle.Mutable {
    protected static final class_124[] CLEAN = new class_124[0];
    private final BiFunction<String, Integer, class_5481> renderTextProvider = (string, firstCharacterIndex) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360);

    public NMTextField(class_327 textRenderer, int x, int y, int width, int height, @Nullable NMTextField copyFrom, class_2561 text) {
        super(textRenderer, x, y, width, height, text);
        if (copyFrom != null) {
            this.setText(copyFrom.text());
        }
    }

    public NMTextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 text) {
        this(textRenderer, x, y, width, height, null, text);
        this.setDrawsBackground(false);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void appendClickableNarrations(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)this.getNarrationMessage());
    }

    public NMTextField drawFancyBackground(boolean draw) {
        this.drawFancyBackground = draw;
        return this;
    }

    protected void renderBackground(class_4587 context, int mouseX, int mouseY, float delta) {
        if (this.drawFancyBackground) {
            GUIUtil.drawNineSlicedTexture(context, NMButtonWidget.NM_WIDGETS_TEXTURE, this.x(), this.y(), this.w(), this.h(), 4, 200, 20, 0, 90);
        }
    }

    protected int getTextY() {
        return this.y() + (this.height - 8) / 2;
    }

    @Override
    public void renderButton(class_4587 context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        int col = this.isEditable() ? this.editableColor : this.uneditableColor;
        int j = this.selectionStart - this.firstCharacterIndex;
        int k = this.selectionEnd - this.firstCharacterIndex;
        String string = this.textRenderer.method_27523(this.text().substring(this.firstCharacterIndex), this.getInnerWidth());
        boolean selectionWithin = j >= 0 && j <= string.length();
        boolean drawCursor = this.isFocused() && this.focusedTicks / 6 % 2 == 0 && selectionWithin;
        String prefix = this.getPrefix();
        int prefixStart = this.x() + (this.drawFancyBackground ? 4 : 2);
        int textStart = prefixStart + Math.max(this.textRenderer.method_1727(prefix), this.getTextStart());
        int m = this.getTextY();
        int n = textStart;
        if (k > string.length()) {
            k = string.length();
        }
        if (!prefix.isEmpty()) {
            GUIUtil.drawText(context, this.textRenderer, (class_2561)class_2561.method_30163((String)prefix).method_27661().method_27695(this.getPrefixStyle()), (float)prefixStart, (float)m, this.prefixCol(), false);
        }
        if (!string.isEmpty()) {
            n = this.renderUnselectedText(context, string, selectionWithin, textStart, m, col, j);
        }
        boolean cursorNotAtEnd = this.selectionStart < this.text().length() || this.text().length() >= this.getMaxLength();
        int o = n;
        if (!selectionWithin) {
            o = j > 0 ? textStart + this.width : textStart;
        } else if (cursorNotAtEnd) {
            o = n - 1;
            --n;
        }
        if (!string.isEmpty() && selectionWithin && j < string.length()) {
            GUIUtil.drawText(context, this.textRenderer, this.renderTextProvider.apply(string.substring(j), this.selectionStart), (float)n, (float)m, col, true);
        }
        if (drawCursor) {
            if (cursorNotAtEnd) {
                class_332.method_25294((class_4587)context, (int)o, (int)(m - 1), (int)(o + 1), (int)(m + 1 + 9), (int)-3092272);
            } else {
                GUIUtil.drawText(context, this.textRenderer, "_", (float)o, (float)m, col, true);
            }
        }
        if (k != j) {
            int p = textStart + this.textRenderer.method_1727(string.substring(0, k));
            this.drawSelectionHighlight(context, o, m - 1, p - 1, m + 1 + 9);
        }
    }

    protected class_124[] getPrefixStyle() {
        return CLEAN;
    }

    protected int renderUnselectedText(class_4587 context, String string, boolean selectionWithin, int textStart, int m, int col, int j) {
        String string2 = selectionWithin ? string.substring(0, j) : string;
        return GUIUtil.drawText(context, this.textRenderer, this.renderTextProvider.apply(string2, this.firstCharacterIndex), (float)textStart, (float)m, col, true);
    }

    protected String getPrefix() {
        return "";
    }

    protected int getTextStart() {
        return 0;
    }

    protected int prefixCol() {
        return PLCCols.INVALID.col;
    }

    @Override
    public void setDims(int x, int y, int w, int h) {
        this.setPos(x, y);
        this.width = w;
        this.height = h;
    }
}

