/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.button;

import com.neep.meatlib.client.screen.AbstractSlotBlockWidget;
import com.neep.meatlib.client.screen.BetterHandledScreen;
import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.auto.VStackPanel;
import com.neep.meatlib.client.screen.slot.MobileSlot;
import com.neep.meatlib.client.screen.slot.OutlineInventoryWidget;
import com.neep.meatlib.client.screen.widget.ClickableWidget;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.plc.PLCHudRenderer;
import com.neep.neepmeat.client.screen.button.NMButtonWidget;
import com.neep.neepmeat.client.screen.plc.PLCProgramScreen;
import com.neep.neepmeat.client.screen.util.Focusable;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.plc.block.entity.ImplanterBlockEntity;
import com.neep.neepmeat.plc.instruction.ImplantInstruction;
import com.neep.neepmeat.screen_handler.BasicScreenHandler;
import com.neep.neepmeat.screen_handler.ImplanterScreenHandler;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_1058;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1159;
import net.minecraft.class_1161;
import net.minecraft.class_1162;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class ImplanterScreen
extends BetterHandledScreen<ImplanterScreenHandler> {
    @Nullable
    public class_1297 targetEntity;
    private float targetError;
    private final ImplantSlotWidget implantSlot;

    public ImplanterScreen(ImplanterScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.implantSlot = new ImplantSlotWidget(handler.field_7761.subList(36, 37), this);
    }

    @Override
    protected void method_25426() {
        this.field_2792 = this.field_22787.method_22683().method_4486();
        this.field_2779 = this.field_22787.method_22683().method_4502();
        super.method_25426();
        OutlineInventoryWidget playerInv = this.addSlotBlock(new OutlineInventoryWidget(((ImplanterScreenHandler)this.field_2797).field_7761.subList(0, 36), this, true));
        this.addSlotBlock(this.implantSlot);
        VStackPanel main = (VStackPanel)this.method_37063(new VStackPanel(0, 1, false, true).addChild(playerInv).addChild(new ApplyButton(1, 18, class_2561.method_30163((String)"APPLY"), button -> ((ImplanterScreenHandler)this.field_2797).applyC2S.emitter().apply()).showBackground(false)));
        this.method_37063(this.implantSlot);
        main.setPos(this.field_2792 - playerInv.w(), 0);
        this.implantSlot.setPos(this.field_2776 + (this.field_22789 - this.implantSlot.w()) / 2, this.field_2800 + (this.field_22790 - this.implantSlot.h()) / 2);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_2680 wallState = PLCProgramScreen.getWallState((class_1937)this.field_22787.field_1687, this.field_22787.field_1773.method_19418());
        if (wallState != null) {
            class_1058 sprite = this.field_22787.method_1541().method_3351().method_3339(wallState);
            PLCProgramScreen.renderInWallOverlay(sprite, matrices, this.field_22789, this.field_22790);
        } else {
            PLCProgramScreen.drawScreenTexture(matrices, PLCProgramScreen.VIGNETTE, 0.0f, 0.0f, 1.0f, 1.0f, 0.9f, this.field_22789, this.field_22790);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.method_2380(matrices, mouseX, mouseY);
        this.renderTargetCrosshairs(matrices);
    }

    private void renderTargetCrosshairs(class_4587 matrices) {
        if (this.targetEntity != null) {
            class_1041 window = this.field_22787.method_22683();
            class_4184 camera = this.field_22787.field_1773.method_19418();
            class_243 camPos = camera.method_19326();
            class_243 targetPos = this.targetPos(this.targetEntity).method_1020(camPos);
            class_1161 worldPos = new class_1161(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);
            class_1159 m = new class_1159(PLCHudRenderer.PROJECTION);
            m.method_22672(PLCHudRenderer.MODEL_VIEW);
            class_1162 pos = new class_1162((float)worldPos.field_5661, (float)worldPos.field_5660, (float)worldPos.field_5659, 1.0f);
            pos.method_22674(m);
            int x = (int)(((double)pos.method_4953() + 0.5) * (double)window.method_4486());
            int y = (int)((1.0 - ((double)pos.method_4956() + 0.5)) * (double)window.method_4502());
            int l = 10;
            GUIUtil.drawHorizontalLine1(matrices, x - l / 2, x + l / 2, y, PLCCols.BORDER.col);
            GUIUtil.drawVerticalLine1(matrices, x, y - l / 2 - 1, y + l / 2 + 1, PLCCols.BORDER.col);
        }
    }

    protected void method_37432() {
        super.method_37432();
        ImplanterBlockEntity be = ((ImplanterScreenHandler)this.field_2797).getImplanter();
        this.targetEntity = be.raycast();
        if (this.targetEntity != null) {
            class_243 origin = ((ImplanterScreenHandler)this.field_2797).getImplanter().endOrigin();
            class_243 centre = this.targetPos(this.targetEntity);
            class_243 toCentre = centre.method_1020(origin);
            class_243 direction = be.direction();
            this.targetError = (float)(57.2957763671875 * Math.acos(toCentre.method_1026(direction) / (toCentre.method_1033() * direction.method_1033())));
        }
    }

    private class_243 targetPos(class_1297 entity) {
        return new class_243(entity.method_23317(), ImplantInstruction.getTargetY(entity), entity.method_23321());
    }

    protected boolean canApply() {
        if (this.implantSlot.getSlot().method_7677().method_7960()) {
            return false;
        }
        float margin = 0.3f;
        float f = class_3532.method_15363((float)(this.targetError / 40.0f), (float)0.0f, (float)1.0f);
        return this.targetEntity != null && f < margin;
    }

    public void method_25420(class_4587 context) {
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 1 || button == 2) {
            // empty if block
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private class ImplantSlotWidget
    extends AbstractSlotBlockWidget
    implements ClickableWidget,
    class_6379,
    Focusable {
        public ImplantSlotWidget(List<class_1735> slots, BetterHandledScreen<?> handler) {
            super(0, 0, slots, handler);
        }

        public class_1735 getSlot() {
            return ((MobileSlot)this.slots.get(0)).slot();
        }

        @Override
        public void method_25394(class_4587 context, int mouseX, int mouseY, float delta) {
            MobileSlot slot = (MobileSlot)this.slots.get(0);
            int slotW = slot.w();
            ImplantSlotWidget.setSlotPositions(this.x + (this.w() - slotW) / 2, this.y + (this.h() - slotW) / 2, this.slots, 1, 1);
            class_5250 text = class_2561.method_43471((String)"block.neepmeat.implanter.no_implant");
            if (!slot.slot().method_7677().method_7960()) {
                text = class_2561.method_43471((String)"block.neepmeat.implanter.no_target");
                if (ImplanterScreen.this.targetEntity != null) {
                    float f = class_3532.method_15363((float)(ImplanterScreen.this.targetError / 40.0f), (float)0.0f, (float)1.0f);
                    int col = PLCCols.BORDER.col;
                    int d = Math.round(20.0f * f);
                    text = class_2561.method_43471((String)"block.neepmeat.implanter.off_target");
                    if (ImplanterScreen.this.canApply()) {
                        col = -65536;
                        text = class_2561.method_43471((String)"block.neepmeat.implanter.implant_ready");
                    }
                    GUIUtil.renderBorderInner(context, this.x + Math.round((float)(this.w() - 20) / 2.0f), this.y + Math.round((float)(this.h() - 20) / 2.0f), 20, 20, col, d);
                }
            }
            GUIUtil.renderBorderInner(context, this.x + Math.round((float)(this.w() - 20) / 2.0f), this.y + Math.round((float)(this.h() - 20) / 2.0f), 20, 20, PLCCols.TRANSPARENT.col, 0);
            GUIUtil.drawCenteredText(context, ImplanterScreen.this.field_22793, (class_2561)text, (float)this.x + (float)this.w() / 2.0f, (float)this.y + (float)this.w() / 2.0f + 20.0f, PLCCols.TEXT.col, true);
            super.method_25394(context, mouseX, mouseY, delta);
        }

        @Override
        public int w() {
            return BasicScreenHandler.playerSlotsW();
        }

        @Override
        public int h() {
            return BasicScreenHandler.playerInvH();
        }

        @Override
        public void setFocused(boolean focused) {
        }

        @Override
        public boolean isFocused() {
            return false;
        }

        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33784;
        }

        public void method_37020(class_6382 builder) {
        }
    }

    private class ApplyButton
    extends NMButtonWidget {
        public ApplyButton(int width, int height, class_2561 message, class_4185.class_4241 onPress) {
            super(0, 0, width, height, message, onPress);
        }

        public void method_25306() {
            if (ImplanterScreen.this.canApply()) {
                super.method_25306();
            }
        }

        public void method_25354(class_1144 soundManager) {
            if (ImplanterScreen.this.canApply() && !((ImplanterScreenHandler)ImplanterScreen.this.field_2797).method_7611(0).method_7677().method_7960()) {
                soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)NMSounds.UI_BEEP, (float)1.0f));
            } else {
                soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)NMSounds.ERROR, (float)1.0f));
            }
        }

        @Override
        protected int borderCol() {
            return !ImplanterScreen.this.canApply() ? PLCCols.INVALID.col : super.borderCol();
        }

        @Override
        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (ImplanterScreen.this.canApply()) {
                GUIUtil.fill(matrices, this.x(), this.y(), this.x() + this.w(), this.y() + this.h(), -4521984);
            } else {
                GUIUtil.fill(matrices, this.x(), this.y(), this.x() + this.w(), this.y() + this.h(), -1879048192);
            }
            super.method_25359(matrices, mouseX, mouseY, delta);
        }
    }
}

