/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.living_machine;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.StructurePropertyFormatter;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.client.screen.living_machine.LivingMachineScreen;
import com.neep.neepmeat.client.screen.plc.PLCScreenButton;
import com.neep.neepmeat.screen_handler.LivingMachineScreenHandler;
import it.unimi.dsi.fastutil.Pair;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public class MetricsPane
extends LivingMachineScreen.PaneWidget {
    private final class_327 textRenderer;
    private final LivingMachineScreenHandler handler;
    private final LivingMachineScreen parent;
    private final List<Pair<class_2561, Supplier<String>>> entries;
    private final DecimalFormat floatFormat;
    private final DecimalFormat smallFloatFormat;
    private final DecimalFormat intFormat;

    public MetricsPane(LivingMachineScreenHandler handler, LivingMachineScreen parent) {
        this.textRenderer = class_310.method_1551().field_1772;
        this.entries = new ArrayList<Pair<class_2561, Supplier<String>>>();
        this.floatFormat = new DecimalFormat("####.#");
        this.smallFloatFormat = new DecimalFormat("####.####");
        this.intFormat = new DecimalFormat("####");
        this.handler = handler;
        this.parent = parent;
        this.entries.add((Pair<class_2561, Supplier<String>>)Pair.of((Object)NeepMeat.translationKey("screen", "living_machine.rated_power"), () -> PowerUtils.perUnitToText(handler.getBlockEntity().getRatedPower()).getString()));
        this.entries.add((Pair<class_2561, Supplier<String>>)Pair.of((Object)NeepMeat.translationKey("screen", "living_machine.power"), () -> PowerUtils.perUnitToText(handler.getBlockEntity().getPower()).getString()));
        this.entries.add((Pair<class_2561, Supplier<String>>)Pair.of((Object)NeepMeat.translationKey("screen", "living_machine.efficiency"), () -> this.intFormat.format(100.0f * handler.getBlockEntity().getEfficiency()) + "%"));
        this.entries.add((Pair<class_2561, Supplier<String>>)Pair.of((Object)NeepMeat.translationKey("screen", "living_machine.degradation_rate"), () -> this.formatRepair(handler.getBlockEntity().getCurrentDegradationRate())));
        this.entries.add((Pair<class_2561, Supplier<String>>)Pair.of((Object)NeepMeat.translationKey("screen", "living_machine.self_repair"), () -> this.formatRepair(handler.getBlockEntity().getSelfRepair())));
        this.entries.add((Pair<class_2561, Supplier<String>>)Pair.of((Object)NeepMeat.translationKey("screen", "living_machine.rul"), () -> MetricsPane.formatRUL(handler.getBlockEntity().getRulSecs())));
        this.entries.add((Pair<class_2561, Supplier<String>>)Pair.of((Object)class_2561.method_43473(), () -> ""));
        this.entries.add((Pair<class_2561, Supplier<String>>)Pair.of((Object)NeepMeat.translationKey("screen", "living_machine.size"), () -> this.intFormat.format(handler.getBlockEntity().getNumStructures())));
        this.entries.add((Pair<class_2561, Supplier<String>>)Pair.of((Object)NeepMeat.translationKey("screen", "living_machine.components"), () -> this.intFormat.format(handler.getBlockEntity().getNumComponents())));
        this.entries.add((Pair<class_2561, Supplier<String>>)Pair.of((Object)NeepMeat.translationKey("screen", "living_machine.process"), () -> ""));
        this.entries.add((Pair<class_2561, Supplier<String>>)Pair.of((Object)class_2561.method_43473(), () -> handler.getBlockEntity().getProcess().getString()));
    }

    @Override
    protected void init() {
        this.addDrawableChild(new ThingyButton(this.bounds.x() + 2, this.bounds.y() + this.bounds.h() - 16 - 2, 112, this.parent::switchMode));
    }

    @Override
    public void method_25394(class_4587 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        Objects.requireNonNull(this.textRenderer);
        int yStride = 9 + 2;
        int padding = 3;
        int yOffset = this.bounds.y() + padding;
        int xOffset = this.bounds.x() + padding;
        int xRight = this.bounds.x() + this.bounds.w() - padding;
        int textCol = PLCCols.TEXT.col;
        int numberCol = PLCCols.SELECTED.col;
        for (Pair<class_2561, Supplier<String>> entry : this.entries) {
            GUIUtil.drawText(context, this.textRenderer, (class_2561)entry.first(), (float)xOffset, (float)yOffset, textCol, false);
            String number = (String)((Supplier)entry.second()).get();
            int numberWidth = this.textRenderer.method_1727(number);
            GUIUtil.drawText(context, this.textRenderer, number, (float)(xRight - numberWidth), (float)yOffset, numberCol, false);
            yOffset += yStride;
        }
    }

    private static String formatRUL(long secs) {
        if (secs == -1L) {
            return "infinite";
        }
        Duration duration = Duration.ofSeconds(secs);
        if (duration.toHoursPart() > 0) {
            return duration.toHoursPart() + "hr " + duration.toMinutesPart() + "m";
        }
        if (duration.toMinutesPart() > 0) {
            return duration.toMinutesPart() + "m " + duration.toSecondsPart() + "s";
        }
        return duration.toSecondsPart() + "s";
    }

    private String formatRepair(float repair) {
        return StructurePropertyFormatter.formatRepair(repair);
    }

    public static class ThingyButton
    extends PLCScreenButton {
        private final int u;
        private final Runnable onClick;

        public ThingyButton(int x, int y, int u, Runnable onClick) {
            super(x, y, (class_2561)class_2561.method_43473());
            this.u = u;
            this.onClick = onClick;
        }

        @Override
        protected int getU() {
            return this.u;
        }

        @Override
        public void method_25352(class_4587 matrices, int mouseX, int mouseY) {
        }

        public void method_25348(double mouseX, double mouseY) {
            this.onClick.run();
        }
    }
}

