/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.living_machine;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.TooltipHelper;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.screen.living_machine.LivingMachineScreen;
import com.neep.neepmeat.client.screen.living_machine.MetricsPane;
import com.neep.neepmeat.machine.live_machine.Processes;
import com.neep.neepmeat.screen_handler.LivingMachineScreenHandler;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class ProcessesPane
extends LivingMachineScreen.PaneWidget {
    private final LivingMachineScreen parent;
    private final TooltipHelper tooltipHelper;
    private final List<EntryWidget> entries;

    public ProcessesPane(LivingMachineScreen parent) {
        this.tooltipHelper = new TooltipHelper(false, PLCCols.TEXT.col, false);
        this.entries = new ArrayList<EntryWidget>();
        this.parent = parent;
    }

    @Override
    protected void init() {
        this.addDrawableChild(new MetricsPane.ThingyButton(this.bounds.x() + 2, this.bounds.y() + this.bounds.h() - 16 - 2, 112, this.parent::switchMode));
        this.entries.clear();
        for (Pair<BitSet, Process> pair : Processes.getInstance().getEntries()) {
            int n = this.bounds.w();
            Objects.requireNonNull(this.textRenderer);
            this.entries.add(new EntryWidget(pair, n, 9 + 3));
        }
    }

    @Override
    public void method_25394(class_4587 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int n = this.bounds.y();
        Objects.requireNonNull(this.textRenderer);
        int yOffset = n + 9 + 4;
        for (EntryWidget entry : this.entries) {
            yOffset = (int)((float)yOffset + (entry.render(context, this.bounds.x() + 2, yOffset, mouseX, mouseY, delta) + 1.0f));
        }
        GUIUtil.drawCenteredText(context, this.textRenderer, class_2561.method_30163((String)"Processes and Requirements"), (float)this.bounds.x() + (float)this.bounds.w() / 2.0f, this.bounds.y() + 3, PLCCols.TEXT.col, false);
    }

    private class EntryWidget {
        private final int w;
        private final Process process;
        private final int h;
        private int prevX;
        private int prevY;

        public EntryWidget(Pair<BitSet, Process> pair, int w, int h) {
            this.w = w;
            this.process = (Process)pair.value();
            this.h = h;
        }

        private boolean isMouseOver(double mouseX, double mouseY) {
            return (double)this.prevX <= mouseX && (double)this.prevY <= mouseY && (double)(this.prevX + this.w) >= mouseX && (double)(this.prevY + this.h) >= mouseY;
        }

        public float render(class_4587 context, int x, int y, int mouseX, int mouseY, float delta) {
            this.prevX = x;
            this.prevY = y;
            GUIUtil.drawHorizontalLine1(context, x + 1, x + this.w - 6, y, PLCCols.TRANSPARENT.col);
            GUIUtil.drawText(context, ProcessesPane.this.textRenderer, this.process.getName(), (float)(x + 1), (float)(y + 3), PLCCols.TEXT.col, false);
            if (this.isMouseOver(mouseX, mouseY)) {
                int width = 180;
                ArrayList<class_5481> texts = new ArrayList<class_5481>();
                class_5250 head = NeepMeat.translationKey("screen", "living_machine.requirements");
                texts.add(head.method_30937());
                List<ComponentType<?>> requiredTypes = this.process.getRequired();
                for (ComponentType<?> type : requiredTypes) {
                    class_2960 id = ComponentType.REGISTRY.method_10221(type);
                    if (id == null) continue;
                    class_124 formatting = ((LivingMachineScreenHandler)ProcessesPane.this.parent.method_17577()).getBlockEntity().getDisplayComponents().contains(id) ? class_124.field_1065 : class_124.field_1080;
                    texts.addAll(ProcessesPane.this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)id.method_42093("component")).method_27692(formatting)), width));
                }
                ProcessesPane.this.tooltipHelper.drawOrdered(context, x + this.w - 3, y, texts, width);
            }
            return this.h;
        }
    }
}

