/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.plc;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5225;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class MonoTextRenderer {
    private static final class_2960 TEXTURE = new class_2960("neepmeat", "textures/font/ascii-mono.png");
    private final class_5225 handler = new class_5225((codePoint, style) -> this.charStride());

    public void drawTexture(class_1159 matrix, float x, float y, float u, float v, float width, float height) {
        MonoTextRenderer.drawTexture(matrix, x, y, 0.0f, u, v, width, height, 128.0f, 128.0f);
    }

    public static void drawTexture(class_1159 matrix, float x, float y, float z, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        MonoTextRenderer.drawTexture(matrix, x, x + width, y, y + height, z, width, height, u, v, textureWidth, textureHeight);
    }

    private static void drawTexture(class_1159 matrix, float x0, float x1, float y0, float y1, float z, float regionWidth, float regionHeight, float u, float v, float textureWidth, float textureHeight) {
        MonoTextRenderer.drawTexturedQuad(matrix, x0, x1, y0, y1, z, (u + 0.0f) / textureWidth, (u + regionWidth) / textureWidth, (v + 0.0f) / textureHeight, (v + regionHeight) / textureHeight);
    }

    private static void drawTexturedQuad(class_1159 matrix, float x0, float x1, float y0, float y1, float z, float u0, float u1, float v0, float v1) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, x0, y1, z).method_22913(u0, v1).method_1344();
        bufferBuilder.method_22918(matrix, x1, y1, z).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(matrix, x1, y0, z).method_22913(u1, v0).method_1344();
        bufferBuilder.method_22918(matrix, x0, y0, z).method_22913(u0, v0).method_1344();
    }

    public int fontHeight() {
        return 9;
    }

    public float draw(class_4587 matrices, @Nullable String text, float x, float y, int color) {
        if (text == null || text.isEmpty()) {
            return 0.0f;
        }
        return this.drawLayer(text, x, y, color, matrices.method_23760().method_23761());
    }

    public float draw(class_4587 matrices, class_5481 text, float x, float y, int color) {
        return this.drawLayer(text, x, y, color, matrices.method_23760().method_23761());
    }

    private void setTexture() {
        RenderSystem.enableTexture();
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
    }

    private float drawLayer(String text, float x, float y, int color, class_1159 matrix) {
        this.setTexture();
        Drawer drawer = new Drawer(x, y, color, matrix);
        class_5223.method_27479((String)text, (class_2583)class_2583.field_24360, (class_5224)drawer);
        return drawer.draw();
    }

    private float drawLayer(class_5481 text, float x, float y, int color, class_1159 matrix) {
        this.setTexture();
        Drawer drawer = new Drawer(x, y, color, matrix);
        text.accept((class_5224)drawer);
        return drawer.draw();
    }

    private int getU(int codePoint) {
        int rows = 16;
        int dx = 8;
        return codePoint % rows * dx;
    }

    private int getV(int codePoint) {
        int cols = 16;
        int dy = 8;
        return codePoint / cols * dy;
    }

    public float drawWithShadow(class_4587 matrices, String text, float x, float y, int color) {
        return this.draw(matrices, text, x, y, color);
    }

    public List<class_5481> wrapLines(class_5348 text, int width) {
        return class_2477.method_10517().method_30933(this.handler.method_27495(text, width, class_2583.field_24360));
    }

    public void drawGlyph(int codePoint, float x, float y, class_1159 matrix, class_287 builder, boolean italic, float red, float green, float blue, float alpha, int light) {
        float x0 = x + 0.0f;
        float x1 = x0 + (float)this.charWidth();
        float y0 = y - 0.0f;
        float y1 = y0 + (float)this.charHeight();
        float h = -3.0f;
        float j = (float)this.charHeight() - 3.0f;
        float u1 = (float)this.getU(codePoint) / 128.0f;
        float v1 = (float)this.getV(codePoint) / 128.0f;
        float u2 = (float)(this.getU(codePoint) + this.charWidth()) / 128.0f;
        float v2 = (float)(this.getV(codePoint) + this.charHeight()) / 128.0f;
        float m = italic ? 1.0f - 0.25f * h : 0.0f;
        float n = italic ? 1.0f - 0.25f * j : 0.0f;
        builder.method_22918(matrix, x0, y1, 0.0f).method_22915(red, green, blue, alpha).method_22913(u1, v2).method_1344();
        builder.method_22918(matrix, x1, y1, 0.0f).method_22915(red, green, blue, alpha).method_22913(u2, v2).method_1344();
        builder.method_22918(matrix, x1, y0, 0.0f).method_22915(red, green, blue, alpha).method_22913(u2, v1).method_1344();
        builder.method_22918(matrix, x0, y0, 0.0f).method_22915(red, green, blue, alpha).method_22913(u1, v1).method_1344();
    }

    public int getWidth(String text) {
        return text.length() * this.charStride();
    }

    public int charWidth() {
        return 5;
    }

    public int charStride() {
        return this.charWidth() + 1;
    }

    public int charHeight() {
        return 8;
    }

    public class_5225 getTextHandler() {
        return this.handler;
    }

    public String trimToWidth(String text, int width) {
        return this.handler.method_27494(text, width, class_2583.field_24360);
    }

    private class Drawer
    implements class_5224 {
        private final class_1159 matrix;
        private final float r;
        private final float g;
        private final float b;
        private final float a;
        private final class_287 bufferBuilder = class_289.method_1348().method_1349();
        private float x;
        private float y;

        public Drawer(float x, float y, int col, class_1159 matrix) {
            this.bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
            this.x = x;
            this.y = y;
            this.matrix = matrix;
            this.r = (float)(col >> 16 & 0xFF) / 255.0f;
            this.g = (float)(col >> 8 & 0xFF) / 255.0f;
            this.b = (float)(col & 0xFF) / 255.0f;
            this.a = (float)(col >> 24 & 0xFF) / 255.0f;
        }

        public boolean accept(int index, class_2583 style, int codePoint) {
            int width = MonoTextRenderer.this.charStride();
            MonoTextRenderer.this.drawGlyph(codePoint, this.x, this.y, this.matrix, this.bufferBuilder, false, this.r, this.g, this.b, this.a, 0xF000F0);
            this.x += (float)width;
            return true;
        }

        public float draw() {
            class_286.method_43433((class_287.class_7433)this.bufferBuilder.method_1326());
            return this.x + 1.0f;
        }
    }
}

