/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.plc;

import com.mojang.blaze3d.systems.RenderSystem;
import com.neep.meatlib.client.screen.TooltipHelper;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.api.plc.instruction.SimpleInstructionProvider;
import com.neep.neepmeat.client.screen.ScreenSubElement;
import com.neep.neepmeat.client.screen.plc.CurrentArgumentWidget;
import com.neep.neepmeat.client.screen.plc.PLCProgramScreen;
import com.neep.neepmeat.client.screen.plc.PLCScreenState;
import com.neep.neepmeat.client.screen.plc.edit.InstructionBrowserWidget;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class PLCScreenShellState
extends ScreenSubElement
implements class_4068,
class_364,
class_6379,
PLCScreenState {
    private final PLCProgramScreen parent;
    private final InstructionBrowserWidget browser;
    private InstructionProvider selectedProvider;
    @Nullable
    private class_2561 error;

    public PLCScreenShellState(PLCProgramScreen parent) {
        this.parent = parent;
        this.browser = new InstructionBrowserWidget(() -> this.selectedProvider, this::validProvider, this::selectProvider);
    }

    private boolean validProvider(InstructionProvider provider) {
        return provider instanceof SimpleInstructionProvider;
    }

    @Override
    protected void init() {
        this.browser.init(this.screenWidth, this.screenHeight);
        this.addDrawable(new HelpWidget(1, 1));
        int n = this.browser.getX();
        int n2 = this.browser.getY();
        Objects.requireNonNull(this.textRenderer);
        this.addDrawable(new CurrentArgumentWidget(n, n2 - 9 - 2, this.parent.getScreenHandler()));
        this.addDrawableChild(this.browser);
    }

    private void selectProvider(InstructionProvider provider) {
        this.setError(null);
        this.parent.getScreenHandler().changeOperation.emitter().apply(provider.getParseName());
        this.selectedProvider = provider;
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.error != null) {
            int ex = 2;
            Objects.requireNonNull(this.textRenderer);
            int ey = this.screenHeight - 9 - 2;
            this.textRenderer.method_30881(matrices, this.error, (float)ex, (float)ey, PLCCols.SELECTED.col);
        }
    }

    @Override
    public void tick() {
        super.tick();
    }

    public void method_37020(class_6382 builder) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33786;
    }

    @Override
    public void argument(Argument argument) {
        this.setError(null);
        this.parent.getScreenHandler().applyArgument.emitter().apply(argument);
    }

    @Override
    public void onKeyPressed(int keyCode, int scanCode, int modifiers) {
        this.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    public void setError(@Nullable class_2561 text) {
        this.error = text;
    }

    public class HelpWidget
    implements class_4068 {
        private final int x;
        private final int y;
        private final int width = 16;
        private final int height = 16;
        private final class_2561 text;

        public HelpWidget(int x, int y) {
            this.x = x;
            this.y = y;
            this.text = class_2561.method_43471((String)"text.neepmeat.plc.interactive_help");
        }

        private boolean isMouseOver(double mx, double my) {
            return mx > (double)this.x && mx < (double)(this.x + 16) && my > (double)this.y && my < (double)(this.y + 16);
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)PLCProgramScreen.WIDGETS);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int u = 112;
            int v = this.isMouseOver(mouseX, mouseY) ? 32 : 16;
            class_332.method_25291((class_4587)matrices, (int)this.x, (int)this.y, (int)0, (float)u, (float)v, (int)16, (int)16, (int)256, (int)256);
            int maxWidth = 150;
            List lines = PLCScreenShellState.this.textRenderer.method_1728((class_5348)this.text, maxWidth);
            if (this.isMouseOver(mouseX, mouseY)) {
                TooltipHelper.get().drawOrdered(matrices, mouseX, mouseY, lines, maxWidth);
            }
        }
    }
}

