/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.plc;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.TooltipHelper;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.plc.block.entity.PLCBlockEntity;
import com.neep.neepmeat.plc.memory.MemoryEntry;
import com.neep.neepmeat.plc.processor.VariableStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class PLCStackViewer
implements class_4068,
Rectangle {
    private int x;
    private int y;
    private int width;
    private int height;
    private final PLCBlockEntity plc;
    private final class_310 client = class_310.method_1551();
    private final class_327 textRenderer;
    private final TooltipHelper tooltipRenderer;
    private int adjustedX;

    public PLCStackViewer(PLCBlockEntity plc) {
        this.textRenderer = this.client.field_1772;
        this.plc = plc;
        this.tooltipRenderer = new TooltipHelper(false, PLCCols.TEXT.col, true);
        this.adjustedX = this.x();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        Objects.requireNonNull(this.textRenderer);
        int stride = 9 + 1;
        VariableStack stack = this.plc.getVariableStack();
        class_332.method_44379((int)this.adjustedX, (int)this.y, (int)this.x2(), (int)this.y2());
        int maxWidth = 70;
        try {
            int lastHeight = (stack.size() + 2) * stride + 2;
            class_5250 name = class_2561.method_43470((String)"Stack");
            int nameWidth = this.textRenderer.method_27525((class_5348)name);
            int adjustedWidth = nameWidth + 2;
            for (int i = 0; i < stack.size(); ++i) {
                adjustedWidth = class_3532.method_15340((int)adjustedWidth, (int)(2 + this.textRenderer.method_1727(this.entryText(this.plc, stack.peek(i)))), (int)maxWidth);
            }
            this.adjustedX = this.x - adjustedWidth + this.width;
            class_332.method_25294((class_4587)matrices, (int)this.adjustedX, (int)(this.y + this.height - lastHeight), (int)(this.x + this.width), (int)(this.y + this.height), (int)-1879048192);
            GUIUtil.renderBorder(matrices, this.adjustedX, this.y + this.height - lastHeight, adjustedWidth, lastHeight - 1, PLCCols.BORDER.col, 0);
            Objects.requireNonNull(this.textRenderer);
            int textY = this.y + this.height - 1 - 9;
            this.textRenderer.method_1729(matrices, "Stack", (float)(this.adjustedX + 1) + (float)(adjustedWidth - nameWidth) / 2.0f, (float)textY, PLCCols.TEXT.col);
            textY -= stride;
            for (int i = stack.size() - 1; i >= 0; --i) {
                DataStack.Entry entry = stack.peek(i);
                GUIUtil.drawText(matrices, this.textRenderer, this.entryText(this.plc, entry), (float)(this.adjustedX + 2), (float)textY, PLCCols.TEXT.col, true);
                textY -= stride;
            }
        }
        catch (NeepASM.RuntimeException lastHeight) {
            // empty catch block
        }
        class_332.method_44380();
        try {
            int hovered;
            if (mouseX > this.adjustedX && mouseX <= this.x2() && mouseY > this.y() && mouseY <= this.y2() && (hovered = (this.h() - 2 - (mouseY - this.y())) / stride - 1) >= 0 && hovered < stack.size()) {
                DataStack.Entry entry = stack.peek(stack.size() - 1 - hovered);
                this.tooltipRenderer.draw(matrices, this.adjustedX, -((hovered + 2) * stride - this.h()) + this.y() - 2, this.detailedEntryText(this.plc, entry));
            }
        }
        catch (NeepASM.RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private List<class_2561> detailedEntryText(PLC plc, DataStack.Entry entry) {
        ObjectArrayList result = new ObjectArrayList();
        if (entry.pointer()) {
            String memoryType;
            Object string;
            if (entry.value() == 0) {
                string = "NULL";
                memoryType = "???";
            } else {
                MemoryEntry memoryEntry = plc.getMemory().fetch(entry.value());
                if (memoryEntry == null) {
                    string = Integer.toString(entry.value(), 10) + "*";
                    memoryType = "???";
                } else {
                    string = memoryEntry.toString();
                    memoryType = memoryEntry.type().name();
                }
            }
            result.add(class_2561.method_30163((String)string));
            result.add(class_2561.method_30163((String)"Type: POINTER"));
            result.add(class_2561.method_30163((String)("Addr: " + entry.value())));
            result.add(class_2561.method_30163((String)("Type: " + memoryType)));
        } else {
            String string = Integer.toString(entry.value(), 10);
            result.add(class_2561.method_30163((String)string));
            result.add(class_2561.method_30163((String)"Type: INT"));
        }
        return result;
    }

    private String entryText(PLC plc, DataStack.Entry entry) {
        MemoryEntry memoryEntry;
        Object string = entry.pointer() ? (entry.value() == 0 ? "NULL" : ((memoryEntry = plc.getMemory().fetch(entry.value())) == null ? Integer.toString(entry.value(), 10) + "*" : memoryEntry.toString())) : Integer.toString(entry.value(), 10);
        return string;
    }

    public void init(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int w() {
        return this.width;
    }

    @Override
    public int h() {
        return this.height;
    }
}

