/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.tablet;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.neepmeat.client.screen.tablet.GuideSearchWidget;
import com.neep.neepmeat.client.screen.util.Focusable;
import com.neep.neepmeat.guide.article.Article;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Objects;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class ArticleTextWidget
implements class_364,
class_4068,
class_6379,
Focusable {
    private double scrollAmount;
    private double scrollLag;
    private int highlightedY;
    private int x;
    private int y;
    private int width;
    private int height;
    private final class_327 textRenderer;
    private final Article article;
    private float articleLength = 0.0f;
    private boolean searchMode = false;
    private final GuideSearchWidget searchString;
    private IntList searchResult = new IntArrayList();

    public ArticleTextWidget(class_327 textRenderer, Article article) {
        this.textRenderer = textRenderer;
        this.article = article != null ? article : Article.EMPTY;
        this.searchString = new GuideSearchWidget("?", () -> this.searchMode, this.textRenderer);
    }

    public void setDimensions(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public class_327 getTextRenderer() {
        return this.textRenderer;
    }

    public int getTop(int margin) {
        return (int)((double)this.y + this.scrollAmount) - margin;
    }

    public int getBottom(int margin) {
        return (int)((double)(this.y + this.height) + this.scrollAmount) + margin;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.scrollAmount = class_3532.method_16436((double)0.4, (double)this.scrollAmount, (double)this.scrollLag);
        int head = 0;
        Objects.requireNonNull(this.textRenderer);
        Objects.requireNonNull(this.textRenderer);
        this.searchString.setDims(this.x, this.y + this.height - 9, this.width, 9);
        class_332.method_44379((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height));
        if (this.highlightedY >= 0 && !this.searchResult.isEmpty()) {
            int highlightOffset = (int)((double)(this.y + this.highlightedY) - this.scrollAmount) + 1;
            Objects.requireNonNull(this.textRenderer);
            GUIUtil.fill(matrices, this.x, highlightOffset, this.x + this.width, highlightOffset + 9 + 1, 0x4400FF00);
        }
        for (Article.Content content : this.article.contents()) {
            head += content.render(matrices, this.x + 2, this.y + 2 + head, this.width, this.scrollAmount, this);
        }
        class_332.method_44380();
        this.searchString.method_25394(matrices, mouseX, mouseY, delta);
        this.articleLength = head;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchMode) {
            if (keyCode == 256) {
                this.clearSearch();
                this.searchMode = false;
                return true;
            }
            if (keyCode == 259) {
                this.searchString.erase(-1);
            }
        }
        if (keyCode == 257) {
            this.searchMode = false;
            this.updateSearch();
            this.scrollToNextResult();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.searchMode && chr == '?') {
            this.searchMode = true;
        } else {
            if (this.searchMode) {
                this.searchString.write(chr, modifiers);
                return true;
            }
            if (chr == 'n') {
                this.scrollToNextResult();
                return true;
            }
        }
        return super.method_25400(chr, modifiers);
    }

    private void scrollToNextResult() {
        if (this.searchResult.isEmpty()) {
            return;
        }
        for (Integer entry : this.searchResult) {
            if (entry <= this.highlightedY) continue;
            this.highlightedY = entry;
            if ((double)this.highlightedY < this.scrollLag) {
                this.setScroll(entry.intValue());
            } else if ((double)this.highlightedY > this.scrollLag + (double)this.contentHeight()) {
                this.setScroll((double)this.highlightedY - 0.75 * (double)this.contentHeight());
            }
            return;
        }
        this.highlightedY = this.searchResult.getInt(0);
        this.setScroll(this.highlightedY);
    }

    private int contentHeight() {
        return this.height - this.searchString.h();
    }

    private void clearSearch() {
        this.searchString.clear();
        this.searchResult.clear();
    }

    private void updateSearch() {
        this.searchResult = this.article.search(this.searchString.toString().toLowerCase(), this.width, this);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return true;
    }

    public void scroll(int amount) {
        this.setScroll(this.scrollLag - (double)(7 * amount));
    }

    public void setScroll(double scroll) {
        this.scrollLag = class_3532.method_15350((double)scroll, (double)0.0, (double)Math.max(this.articleLength - (float)this.contentHeight() + 1.0f, 0.0f));
    }

    @Override
    public void setFocused(boolean focused) {
    }

    @Override
    public boolean isFocused() {
        return false;
    }
}

