/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.tablet;

import com.mojang.blaze3d.systems.RenderSystem;
import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.neepmeat.client.screen.tablet.ContentPane;
import com.neep.neepmeat.client.screen.tablet.GuideArticlePane;
import com.neep.neepmeat.client.screen.tablet.GuideListPane;
import com.neep.neepmeat.client.screen.tablet.GuideScreen;
import com.neep.neepmeat.guide.GuideNode;
import com.neep.neepmeat.guide.GuideReloadListener;
import com.neep.neepmeat.guide.article.Article;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GuideMainScreen
extends class_437
implements GuideScreen {
    public static final class_2960 LOGO_TEXTURE = new class_2960("neepmeat", "textures/gui/tablet/neep.png");
    private int x;
    private int y;
    protected int contentWidth = 340;
    protected int contentHeight = 280;
    protected int animationTicks;
    protected boolean start = true;
    protected final ContentPane leftPane = new GuideListPane(this);
    protected ContentPane rightPane = new GuideArticlePane(this, Article.EMPTY);
    protected final Deque<GuideNode> path;

    public GuideMainScreen() {
        super((class_2561)class_2561.method_43473());
        GuideReloadListener reloadListener = GuideReloadListener.getInstance();
        @Nullable GuideNode root = reloadListener.getRootNode();
        if (root != null) {
            this.path = reloadListener.getPersistentPath();
            if (this.path.isEmpty()) {
                this.push(root);
            }
        } else {
            this.path = new LinkedList<GuideNode>();
        }
    }

    @Override
    public void setRightPane(ContentPane element) {
        this.method_37066(this.rightPane);
        this.rightPane = element;
        this.method_25426();
    }

    @Override
    public void push(GuideNode node) {
        this.path.push(node);
        this.leftPane.method_25426();
    }

    @Override
    public GuideNode pop() {
        GuideNode ret = null;
        if (this.path.size() > 1) {
            ret = this.path.pop();
        }
        this.leftPane.method_25426();
        return ret;
    }

    @Override
    public Deque<GuideNode> getPath() {
        return this.path;
    }

    @Override
    public int getAnimationTicks() {
        return this.animationTicks;
    }

    @Override
    public void openArticle(Article article) {
        this.setRightPane(new GuideArticlePane(this, article));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        matrices.method_22903();
        float scale = class_3532.method_37166((float)0.01f, (float)1.0f, (float)(((float)this.animationTicks + delta) / 10.0f));
        matrices.method_22904(0.0, (double)((float)this.field_22790 / 2.0f * (1.0f - scale)), 0.0);
        matrices.method_22905(1.0f, scale, 1.0f);
        if (this.animationTicks > 10) {
            super.method_25394(matrices, mouseX, mouseY, delta);
            this.drawLogo(matrices, delta);
        }
        int borderCol = -16742400;
        int offset = 3;
        if (this.animationTicks != 0 && this.animationTicks != 2) {
            GUIUtil.renderBorder(matrices, this.x, this.y, this.contentWidth, this.contentHeight, borderCol, offset);
        }
        matrices.method_22909();
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return this.method_19355(mouseX, mouseY).filter(element -> element.method_25401(mouseX, mouseY, amount)).isPresent();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.leftPane.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.rightPane.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256 && this.method_25422()) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.leftPane.method_25400(chr, modifiers)) {
            return true;
        }
        return this.rightPane.method_25400(chr, modifiers);
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063(this.leftPane);
        this.method_37063(this.rightPane);
        float windowWidth = this.field_22787.method_22683().method_4486();
        float windowHeight = this.field_22787.method_22683().method_4502();
        float aspectRatio = windowWidth / windowHeight;
        this.contentHeight = (int)(windowHeight - 40.0f);
        this.contentWidth = (int)((float)this.contentHeight * aspectRatio);
        this.x = (this.field_22789 - this.contentWidth) / 2;
        this.y = (this.field_22790 - this.contentHeight) / 2;
        float ratio = 0.4f;
        int leftWidth = (int)(ratio * (float)this.contentWidth);
        int rightWidth = (int)((1.0f - ratio) * (float)this.contentWidth);
        int rightStart = this.x + leftWidth;
        if (this.leftPane != null) {
            this.leftPane.setDimensions(this.x, this.y, leftWidth, this.contentHeight - 26);
            this.leftPane.init(this.field_22787);
        }
        if (this.rightPane != null) {
            this.rightPane.setDimensions(rightStart, this.y, rightWidth, this.contentHeight);
            this.rightPane.init(this.field_22787);
        }
    }

    protected void drawLogo(class_4587 matrices, float delta) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)LOGO_TEXTURE);
        int logoHeight = 24;
        int logoWidth = 60;
        GuideMainScreen.method_25290((class_4587)matrices, (int)this.x, (int)(this.y + this.contentHeight - logoHeight + 1), (float)0.0f, (float)0.0f, (int)logoWidth, (int)logoHeight, (int)logoWidth, (int)26);
    }

    protected void method_25409(class_4587 matrices, class_1799 stack, int x, int y) {
        this.method_32634(matrices, this.method_25408(stack), stack.method_32347(), x, y);
    }

    public void method_32634(class_4587 matrices, List<class_2561> lines, Optional<class_5632> data2, int x, int y) {
        List<class_5684> list = lines.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList());
        data2.ifPresent(data -> list.add(1, class_5684.method_32663((class_5632)data)));
        this.renderTooltipFromComponents(matrices, list, x, y);
    }

    public void method_25393() {
        ++this.animationTicks;
        this.leftPane.method_25393();
        this.rightPane.method_25393();
    }

    private void renderTooltipFromComponents(class_4587 matrices, List<class_5684> components, int x, int y) {
        class_5684 tooltipComponent2;
        int s;
        int k;
        if (components.isEmpty()) {
            return;
        }
        int i = 0;
        int j = components.size() == 1 ? -2 : 0;
        for (class_5684 tooltipComponent : components) {
            k = tooltipComponent.method_32664(this.field_22793);
            if (k > i) {
                i = k;
            }
            j += tooltipComponent.method_32661();
        }
        int l = x + 12;
        int startY = y - 12;
        k = i;
        int m = j;
        if (l + i > this.field_22789) {
            l -= 28 + i;
        }
        if (startY + m + 6 > this.field_22790) {
            startY = this.field_22790 - m - 6;
        }
        matrices.method_22903();
        int n = -267386864;
        int o = 0x505000FF;
        int p = 1344798847;
        int q = 400;
        float f = this.field_22788.field_4730;
        this.field_22788.field_4730 = 400.0f;
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        class_1159 matrix4f = matrices.method_23760().method_23761();
        int borderCol = -1358909695;
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(l - 3), (int)(startY - 3), (int)(l + k + 3), (int)(startY + m + 3), (int)400, (int)-267486464, (int)-267386864);
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(l - 3), (int)(startY - 3 + 1), (int)(l - 3 + 1), (int)(startY + m + 3 - 1), (int)400, (int)borderCol, (int)borderCol);
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(l + k + 2), (int)(startY - 3 + 1), (int)(l + k + 3), (int)(startY + m + 3 - 1), (int)400, (int)borderCol, (int)borderCol);
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(l - 3), (int)(startY - 3), (int)(l + k + 3), (int)(startY - 3 + 1), (int)400, (int)borderCol, (int)borderCol);
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(l - 3), (int)(startY + m + 2), (int)(l + k + 3), (int)(startY + m + 3), (int)400, (int)borderCol, (int)borderCol);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        matrices.method_22904(0.0, 0.0, 400.0);
        int r = startY;
        for (s = 0; s < components.size(); ++s) {
            tooltipComponent2 = components.get(s);
            tooltipComponent2.method_32665(this.field_22793, l, r, matrix4f, immediate);
            r += tooltipComponent2.method_32661() + (s == 0 ? 2 : 0);
        }
        immediate.method_22993();
        matrices.method_22909();
        r = startY;
        for (s = 0; s < components.size(); ++s) {
            tooltipComponent2 = components.get(s);
            tooltipComponent2.method_32666(this.field_22793, l, r, matrices, this.field_22788, 400);
            r += tooltipComponent2.method_32661() + (s == 0 ? 2 : 0);
        }
        this.field_22788.field_4730 = f;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25432() {
    }

    public void method_25419() {
        super.method_25419();
    }
}

