/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.widget;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.TooltipHelper;
import com.neep.meatlib.client.screen.auto.BlackBackgroundPanel;
import com.neep.meatlib.client.screen.auto.Panel;
import com.neep.meatlib.client.screen.auto.SimplePanel;
import com.neep.meatlib.client.screen.auto.SplitPanel;
import com.neep.meatlib.client.screen.widget.CheckboxWidget;
import com.neep.meatlib.client.screen.widget.ClickableWidget;
import com.neep.meatlib.client.screen.widget.IntNumberTextField;
import com.neep.meatlib.client.screen.widget.config.ConfigPanel;
import com.neep.meatlib.screen.ConfigWidgetHandler;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.screen_handler.widget.VascularCondenserWidgetHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;

public class VascularCondenserPanel
extends SimplePanel {
    private final class_327 textRenderer;
    private final VascularCondenserWidgetHandler handler;
    private final PowerDisplayPanel displayPanel;
    private boolean destroy;

    public VascularCondenserPanel(VascularCondenserWidgetHandler handler) {
        this.textRenderer = class_310.method_1551().field_1772;
        this.handler = handler;
        this.displayPanel = new PowerDisplayPanel();
        handler.amountS2C.receiver(this::update);
        this.element = new SplitPanel(SplitPanel.Split.HORIZONTAL, 0).setLeft(new BlackBackgroundPanel(new ConfigPanel1(handler), 3)).setRight(new BlackBackgroundPanel(this.displayPanel, 3).solidW()).setFit(SplitPanel.Fit.SECOND);
    }

    private void update(long amount, long capacity, long networkInternal) {
        this.displayPanel.update(amount, capacity, networkInternal);
    }

    @Override
    protected ClickableWidget initMainElement() {
        this.setDims();
        return this.element;
    }

    public static class PowerDisplayPanel
    extends Panel {
        private long amount;
        private long capacity;
        private long networkInternal;

        public PowerDisplayPanel() {
            this.w = 14;
        }

        @Override
        public void init() {
        }

        @Override
        public void method_25394(class_4587 context, int mouseX, int mouseY, float delta) {
            GUIUtil.renderBorderInner(context, this.x, this.y, this.w, this.h, PLCCols.BORDER.col, 0);
            double f = this.capacity != 0L ? (double)this.amount / (double)this.capacity : 0.0;
            int bh = (int)(f * (double)this.h);
            for (int i = 0; i < bh; ++i) {
                if ((i + 1) % 2 != 0) continue;
                GUIUtil.drawHorizontalLine1(context, this.x + 2, this.x + this.w - 3, this.y + this.h - i, PLCCols.BORDER.col);
            }
            if (this.isWithin(mouseX, mouseY)) {
                ObjectArrayList texts = new ObjectArrayList();
                texts.add(class_2561.method_30163((String)(PowerUtils.formatEnergy(this.amount, 2) + " / " + PowerUtils.formatEnergy(this.capacity, 2))));
                texts.add(class_2561.method_30163((String)("Network capacity: " + PowerUtils.formatEnergy(this.networkInternal, 2))));
                TooltipHelper.get().draw(context, mouseX, mouseY, (List<class_2561>)texts);
            }
        }

        @Override
        protected List<class_4068> drawables() {
            return List.of();
        }

        @Override
        public List<class_364> method_25396() {
            return List.of();
        }

        public void update(long amount, long capacity, long networkInternal) {
            this.amount = amount;
            this.capacity = capacity;
            this.networkInternal = networkInternal;
        }
    }

    private static class ConfigPanel1
    extends ConfigPanel<VascularCondenserWidgetHandler.Values> {
        private final IntNumberTextField targetField;
        boolean destroy;

        public ConfigPanel1(ConfigWidgetHandler<VascularCondenserWidgetHandler.Values> handler) {
            super(handler);
            this.targetField = this.addTrackedField(new IntNumberTextField(this.textRenderer, 0, 0, 100, 18, class_2561.method_30163((String)"Target:"), c -> this.update(), 0, Integer.MAX_VALUE, 10, 100));
            CheckboxWidget destroyExcess = new CheckboxWidget(0, 0, 100, 18, () -> this.destroy, class_2561.method_30163((String)"Destroy excess power"), (button, toggled) -> {
                this.destroy = toggled;
            });
            this.addTrackedField(destroyExcess);
        }

        @Override
        protected VascularCondenserWidgetHandler.Values createValues() {
            return new VascularCondenserWidgetHandler.Values(this.targetField.parse(), this.destroy);
        }

        @Override
        protected void updateParams(VascularCondenserWidgetHandler.Values values) {
            this.targetField.setNumberText(values.target());
            this.destroy = values.destroy();
        }
    }
}

