/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.emi.recipe;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.api.plc.recipe.ManufactureStep;
import com.neep.neepmeat.plc.recipe.CombineStep;
import com.neep.neepmeat.plc.recipe.ImplantStep;
import com.neep.neepmeat.plc.recipe.InjectStep;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public abstract class ManufactureEmiRecipe<T>
implements EmiRecipe {
    protected final T base;
    protected final List<ManufactureStep<?>> steps;

    protected ManufactureEmiRecipe(T base, List<ManufactureStep<?>> steps) {
        this.base = base;
        this.steps = steps;
    }

    static void drawThing(int x, int y, ManufactureStep<?> step, WidgetHolder widgets) {
        if (step instanceof CombineStep) {
            CombineStep combineStep = (CombineStep)step;
            widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)combineStep.getItem()), x - 1, y + 1).drawBack(false);
        } else if (step instanceof InjectStep) {
            InjectStep injectStep = (InjectStep)step;
            widgets.addSlot((EmiIngredient)EmiStack.of((class_3611)injectStep.fluid().getFluid()), x - 1, y + 1).drawBack(false);
        } else if (step instanceof ImplantStep) {
            ImplantStep implantStep = (ImplantStep)step;
            widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)implantStep.getItem()), x - 1, y + 1).drawBack(false);
        } else {
            widgets.addSlot((EmiIngredient)EmiStack.EMPTY, x, y + 2).drawBack(false);
        }
    }

    static void appendStepIngredients(List<ManufactureStep<?>> steps, List<EmiIngredient> ingredients) {
        for (ManufactureStep<?> step : steps) {
            if (step instanceof CombineStep) {
                CombineStep combineStep = (CombineStep)step;
                ingredients.add((EmiIngredient)EmiStack.of((class_1935)combineStep.getItem()));
                continue;
            }
            if (step instanceof InjectStep) {
                InjectStep injectStep = (InjectStep)step;
                ingredients.add((EmiIngredient)EmiStack.of((class_3611)injectStep.fluid().getFluid()));
                continue;
            }
            if (!(step instanceof ImplantStep)) continue;
            ImplantStep implantStep = (ImplantStep)step;
            ingredients.add((EmiIngredient)EmiStack.of((class_1935)implantStep.getItem()));
        }
    }

    public static int borderCol() {
        return PLCCols.BORDER.col;
    }

    public T getBase() {
        return this.base;
    }

    public int getDisplayWidth() {
        return 160;
    }

    public int getDisplayHeight() {
        return 150;
    }

    static class OutlineWidget
    extends Widget {
        private final Bounds bounds;

        public OutlineWidget(Bounds bounds) {
            this.bounds = bounds;
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            class_332.method_25294((class_4587)matrices, (int)this.bounds.x(), (int)this.bounds.y(), (int)(this.bounds.x() + this.bounds.width()), (int)(this.bounds.y() + this.bounds.height()), (int)-16777216);
            GUIUtil.renderBorder(matrices, this.bounds.x(), this.bounds.y(), this.bounds.width(), this.bounds.height(), ManufactureEmiRecipe.borderCol(), 0);
            GUIUtil.renderBorder(matrices, this.bounds.x() + 1, this.bounds.y() + 1, this.bounds.width() - 2, this.bounds.height() - 2, PLCCols.TRANSPARENT.col, 0);
        }
    }

    public static class EntryWidget
    extends Widget {
        private final int originX;
        private final int originY;
        private final ManufactureStep<?> step;
        private final class_2561 name;
        private final class_327 textRenderer;
        private final int width;

        public EntryWidget(int originX, int originY, ManufactureStep<?> step, int width, WidgetHolder widgets) {
            this.textRenderer = class_310.method_1551().field_1772;
            this.originX = originX;
            this.originY = originY;
            this.step = step;
            this.name = step.getName();
            this.width = width;
            ManufactureEmiRecipe.drawThing(originX + this.width() - 14, originY, step, widgets);
        }

        public int height() {
            Objects.requireNonNull(this.textRenderer);
            return Math.max(9 + 3, 19);
        }

        public int width() {
            return this.width;
        }

        public Bounds getBounds() {
            return new Bounds(this.originX, this.originY, this.width(), this.height());
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            int x = this.originX + 2;
            int y = this.originY + 2;
            this.textRenderer.method_30881(matrices, this.name, (float)x, (float)y, ManufactureEmiRecipe.borderCol());
            GUIUtil.renderBorder(matrices, this.originX, this.originY, this.width() + 3, this.height(), ManufactureEmiRecipe.borderCol(), 0);
        }
    }

    static class LabelledSlot
    extends Widget {
        private final int originX;
        private final int originY;
        private final class_2561 name;
        private final int slotOriginX;
        private final int slotOriginY;
        private final class_327 textRenderer;

        public LabelledSlot(int originX, int originY, class_2561 name, EmiStack stack, WidgetHolder widgets) {
            this(originX, originY, name, stack, widgets, null);
        }

        public LabelledSlot(int originX, int originY, class_2561 name, EmiStack stack, WidgetHolder widgets, EmiRecipe recipe) {
            this.textRenderer = class_310.method_1551().field_1772;
            this.name = name;
            this.originX = originX;
            this.originY = originY;
            this.slotOriginX = originX + this.textRenderer.method_27525((class_5348)name) + 2;
            this.slotOriginY = originY;
            widgets.addSlot((EmiIngredient)stack, this.slotOriginX, this.slotOriginY).drawBack(false).recipeContext(recipe);
        }

        public int height() {
            Objects.requireNonNull(this.textRenderer);
            return Math.max(9 + 3, 19);
        }

        public int width() {
            return this.textRenderer.method_27525((class_5348)this.name) + 2 + 20;
        }

        public Bounds getBounds() {
            return new Bounds(this.originX, this.originY, this.width(), this.height());
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.textRenderer.method_30881(matrices, this.name, (float)this.originX, (float)this.originY, ManufactureEmiRecipe.borderCol());
            GUIUtil.renderBorder(matrices, this.slotOriginX, this.slotOriginY, 17, 17, ManufactureEmiRecipe.borderCol(), 0);
            GUIUtil.renderBorder(matrices, this.slotOriginX + 1, this.slotOriginY + 1, 15, 15, PLCCols.TRANSPARENT.col, 0);
        }
    }
}

