/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.emi.recipe;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.api.plc.recipe.ManufactureStep;
import com.neep.neepmeat.compat.emi.NMEmiPlugin;
import com.neep.neepmeat.compat.emi.recipe.ManufactureEmiRecipe;
import com.neep.neepmeat.plc.recipe.CombineStep;
import com.neep.neepmeat.plc.recipe.ImplantStep;
import com.neep.neepmeat.plc.recipe.InjectStep;
import com.neep.neepmeat.plc.recipe.TransformingToolRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class ToolManufactureEmiRecipe
extends ManufactureEmiRecipe<class_1792> {
    private static final class_2960 GHOST_AXE = new class_2960("neepmeat", "textures/gui/ghost_axe.png");
    private static final class_2960 GHOST_SWORD = new class_2960("neepmeat", "textures/gui/ghost_sword.png");
    private final class_2960 id;
    private final ManufactureStep<?> finalStep;

    public ToolManufactureEmiRecipe(TransformingToolRecipe recipe) {
        super(recipe.getBase(), recipe.getSteps());
        this.finalStep = recipe.getSteps().get(0);
        this.id = new class_2960(recipe.method_8114().method_12836(), "/" + recipe.method_8114().method_12832());
    }

    public static int borderCol() {
        return PLCCols.BORDER.col;
    }

    static void appendStepIngredients(List<ManufactureStep<?>> steps, List<EmiIngredient> ingredients) {
        for (ManufactureStep<?> step : steps) {
            if (step instanceof CombineStep) {
                CombineStep combineStep = (CombineStep)step;
                ingredients.add((EmiIngredient)EmiStack.of((class_1935)combineStep.getItem()));
                continue;
            }
            if (step instanceof InjectStep) {
                InjectStep injectStep = (InjectStep)step;
                ingredients.add((EmiIngredient)EmiStack.of((class_3611)((class_3611)injectStep.fluid().getObject())));
                continue;
            }
            if (!(step instanceof ImplantStep)) continue;
            ImplantStep implantStep = (ImplantStep)step;
            ingredients.add((EmiIngredient)EmiStack.of((class_1935)implantStep.getItem()));
        }
    }

    static void drawThing(int x, int y, ManufactureStep<?> step, WidgetHolder widgets) {
        if (step instanceof CombineStep) {
            CombineStep combineStep = (CombineStep)step;
            widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)combineStep.getItem()), x - 1, y + 1).drawBack(false);
        } else if (step instanceof InjectStep) {
            InjectStep injectStep = (InjectStep)step;
            widgets.addSlot((EmiIngredient)EmiStack.of((class_3611)injectStep.fluid().getFluid()), x - 1, y + 1).drawBack(false);
        } else if (step instanceof ImplantStep) {
            ImplantStep implantStep = (ImplantStep)step;
            widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)implantStep.getItem()), x - 1, y + 1).drawBack(false);
        } else {
            widgets.addSlot((EmiIngredient)EmiStack.EMPTY, x, y + 2).drawBack(false);
        }
    }

    public EmiRecipeCategory getCategory() {
        return NMEmiPlugin.SURGERY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiStack.of((class_1935)((class_1935)this.base)));
    }

    public List<EmiStack> getOutputs() {
        return List.of();
    }

    @Override
    public int getDisplayWidth() {
        return 160;
    }

    @Override
    public int getDisplayHeight() {
        return 150;
    }

    public void addWidgets(WidgetHolder widgets) {
        int startX = 5;
        int startY = 5;
        widgets.add((Widget)new OutlineWidget(new Bounds(0, 0, this.getDisplayWidth(), this.getDisplayHeight())));
        ManufactureEmiRecipe.LabelledSlot widgetBase = new ManufactureEmiRecipe.LabelledSlot(startX, startY, class_2561.method_30163((String)"Base: "), EmiStack.of((class_1935)((class_1935)this.base)), widgets);
        widgets.add((Widget)widgetBase);
        int entryX = startX + 1;
        int entryY = startY + 22;
        ToolWidget toolWidget = new ToolWidget(entryX, entryY, this.getDisplayWidth() - 20, widgets, GHOST_AXE);
        widgets.add((Widget)toolWidget);
        entryY += toolWidget.height() + 2;
        toolWidget = new ToolWidget(entryX, entryY, this.getDisplayWidth() - 20, widgets, GHOST_SWORD);
        widgets.add((Widget)toolWidget);
        ManufactureEmiRecipe.EntryWidget widget = new ManufactureEmiRecipe.EntryWidget(entryX, entryY += toolWidget.height() + 2, this.finalStep, this.getDisplayWidth() - 20, widgets);
        widgets.add((Widget)widget);
    }

    static class OutlineWidget
    extends Widget {
        private final Bounds bounds;

        public OutlineWidget(Bounds bounds) {
            this.bounds = bounds;
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            class_332.method_25294((class_4587)matrices, (int)this.bounds.x(), (int)this.bounds.y(), (int)(this.bounds.x() + this.bounds.width()), (int)(this.bounds.y() + this.bounds.height()), (int)-16777216);
            GUIUtil.renderBorder(matrices, this.bounds.x(), this.bounds.y(), this.bounds.width(), this.bounds.height(), ToolManufactureEmiRecipe.borderCol(), 0);
            GUIUtil.renderBorder(matrices, this.bounds.x() + 1, this.bounds.y() + 1, this.bounds.width() - 2, this.bounds.height() - 2, PLCCols.TRANSPARENT.col, 0);
        }
    }

    public static class ToolWidget
    extends Widget {
        private final int originX;
        private final int originY;
        private final class_2960 texture;
        private final ManufactureStep<?> step;
        private final class_2561 name;
        private final class_327 textRenderer;
        private final int width;

        public ToolWidget(int originX, int originY, int width, WidgetHolder widgets, class_2960 texture) {
            this.textRenderer = class_310.method_1551().field_1772;
            this.originX = originX;
            this.originY = originY;
            this.texture = texture;
            this.step = new CombineStep(ItemVariant.blank());
            this.name = this.step.getName();
            this.width = width;
            widgets.addTexture(new EmiTexture(texture, 0, 0, 16, 16, 16, 16, 16, 16), originX + this.width() - 14, originY);
        }

        public int height() {
            Objects.requireNonNull(this.textRenderer);
            return Math.max(9 + 3, 19);
        }

        public int width() {
            return this.width;
        }

        public Bounds getBounds() {
            return new Bounds(this.originX, this.originY, this.width(), this.height());
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            int x = this.originX + 2;
            int y = this.originY + 2;
            this.textRenderer.method_30881(matrices, this.name, (float)x, (float)y, ToolManufactureEmiRecipe.borderCol());
            GUIUtil.renderBorder(matrices, this.originX, this.originY, this.width() + 3, this.height(), ToolManufactureEmiRecipe.borderCol(), 0);
        }
    }
}

