/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.entity;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.init.NMEntities;
import com.neep.neepmeat.machine.live_machine.block.LargestHopperBlock;
import com.neep.neepmeat.util.IterateRandomly;
import it.unimi.dsi.fastutil.ints.IntIterator;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2968;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5688;
import org.jetbrains.annotations.Nullable;

public class ActiveWasteFallingBlockEntity
extends class_1540 {
    protected static final class_2940<class_2338> BLOCK_POS = class_2945.method_12791(ActiveWasteFallingBlockEntity.class, (class_2941)class_2943.field_13324);
    public int timeFalling;
    public boolean dropItem = true;
    @Nullable
    public class_2487 blockEntityData;
    private class_2680 block = class_2246.field_10102.method_9564();
    private boolean destroyedOnLanding;
    private boolean hurtEntities;
    private int fallHurtMax = 40;
    private float fallHurtAmount;

    public ActiveWasteFallingBlockEntity(class_1299<? extends ActiveWasteFallingBlockEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    private ActiveWasteFallingBlockEntity(class_1937 world, double x, double y, double z, class_2680 block) {
        this(NMEntities.FALLING_ACTIVE_WASTE, world);
        this.block = block;
        this.field_23807 = true;
        this.method_5814(x, y, z);
        this.method_18799(class_243.field_1353);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.method_6963(this.method_24515());
    }

    public static ActiveWasteFallingBlockEntity spawnFromBlock(class_3218 serverWorld, class_2338 pos, class_2680 state) {
        ActiveWasteFallingBlockEntity fallingBlockEntity = new ActiveWasteFallingBlockEntity((class_1937)serverWorld, (double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, state.method_28498((class_2769)class_2741.field_12508) ? (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)) : state);
        serverWorld.method_8652(pos, state.method_26227().method_15759(), 3);
        serverWorld.method_8649((class_1297)fallingBlockEntity);
        return fallingBlockEntity;
    }

    public boolean method_5732() {
        return false;
    }

    public class_2338 method_6964() {
        return (class_2338)this.field_6011.method_12789(BLOCK_POS);
    }

    public void method_6963(class_2338 pos) {
        this.field_6011.method_12778(BLOCK_POS, (Object)pos);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    protected void method_5693() {
        this.field_6011.method_12784(BLOCK_POS, (Object)class_2338.field_10980);
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    private boolean canPlaceAt(class_1937 world, class_2338 pos, class_2680 state) {
        class_2680 oldState = world.method_8320(pos);
        if (oldState.method_27852(class_2246.field_10008)) {
            return false;
        }
        boolean canReplace = world.method_8320(pos).method_26166((class_1750)new class_2968(this.method_37908(), pos, class_2350.field_11033, class_1799.field_8037, class_2350.field_11036));
        boolean canPlace = state.method_26184((class_4538)this.method_37908(), pos);
        return canReplace && canPlace;
    }

    public void method_5773() {
        if (this.block.method_26215()) {
            this.method_31472();
        } else {
            class_2248 block = this.block.method_26204();
            ++this.timeFalling;
            if (!this.method_5740()) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
            if (!this.method_37908().field_9236) {
                class_2338 blockPos = this.method_24515();
                if (this.method_24828()) {
                    class_2680 oldState = this.method_37908().method_8320(blockPos);
                    if (LargestHopperBlock.isLargeHopper(oldState) || LargestHopperBlock.isLargeHopper(this.method_37908().method_8320(blockPos.method_10074()))) {
                        this.method_31472();
                        this.method_32752(block, blockPos);
                        this.dropItemExact((class_1935)block, 0.0f);
                        return;
                    }
                    if (!this.field_5974.method_43056() || !this.jump(this.method_37908(), blockPos)) {
                        this.method_18799(this.method_18798().method_18805(0.7, -0.5, 0.7));
                        class_2338 placePos = blockPos;
                        while (!this.canPlaceAt(this.method_37908(), placePos, this.block)) {
                            placePos = placePos.method_10084();
                        }
                        if (this.block.method_28498((class_2769)class_2741.field_12508) && this.method_37908().method_8316(placePos).method_15772() == class_3612.field_15910) {
                            this.block = (class_2680)this.block.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.TRUE);
                        }
                        if (this.method_37908().method_8652(placePos, this.block, 3)) {
                            class_2586 blockEntity;
                            ((class_3218)this.method_37908()).method_14178().field_17254.method_18702((class_1297)this, (class_2596)new class_2626(placePos, this.method_37908().method_8320(placePos)));
                            this.method_31472();
                            if (block instanceof class_5688) {
                                ((class_5688)block).method_10127(this.method_37908(), placePos, this.block, oldState, (class_1540)this);
                            }
                            if (this.blockEntityData != null && this.block.method_31709() && (blockEntity = this.method_37908().method_8321(placePos)) != null) {
                                class_2487 nbtCompound = blockEntity.method_38244();
                                for (String string : this.blockEntityData.method_10541()) {
                                    nbtCompound.method_10566(string, this.blockEntityData.method_10580(string).method_10707());
                                }
                                try {
                                    blockEntity.method_11014(nbtCompound);
                                }
                                catch (Exception var15) {
                                    NeepMeat.LOGGER.error("Failed to load block entity from falling block", (Throwable)var15);
                                }
                                blockEntity.method_5431();
                            }
                        } else if (this.dropItem && this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
                            this.method_31472();
                            this.method_32752(block, blockPos);
                            this.method_5706((class_1935)block);
                        }
                    }
                } else if (!(this.method_37908().field_9236 || (this.timeFalling <= 100 || blockPos.method_10264() > this.method_37908().method_31607() && blockPos.method_10264() <= this.method_37908().method_31600()) && this.timeFalling <= 600)) {
                    if (this.dropItem && this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
                        this.method_5706((class_1935)block);
                    }
                    this.method_31472();
                }
            }
            this.method_18799(this.method_18798().method_1021(0.98));
        }
    }

    @Nullable
    public class_1542 dropItemExact(class_1935 item, float yOffset) {
        if (this.method_37908().field_9236) {
            return null;
        }
        class_1799 stack = item.method_8389().method_7854();
        class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318() + (double)yOffset, this.method_23321(), stack, 0.0, 0.0, 0.0);
        itemEntity.method_6988();
        this.method_37908().method_8649((class_1297)itemEntity);
        return itemEntity;
    }

    private boolean jump(class_1937 world, class_2338 pos) {
        class_2350[] directions = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
        IntIterator intIterator = new IterateRandomly(4).iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            class_2338 side = pos.method_10093(directions[i]);
            class_2338 sideDown = side.method_10074();
            if (!world.method_22347(side) || !world.method_22347(sideDown)) continue;
            this.method_23327((double)side.method_10263() + 0.5, this.method_23318(), (double)side.method_10260() + 0.5);
            this.method_5814((double)side.method_10263() + 0.5, this.method_23318(), (double)side.method_10260() + 0.5);
            this.method_6963(side);
            this.method_24830(false);
            return true;
        }
        return false;
    }

    public class_2680 method_6962() {
        return this.block;
    }

    public void method_6965(float fallHurtAmount, int fallHurtMax) {
        this.hurtEntities = true;
        this.fallHurtAmount = fallHurtAmount;
        this.fallHurtMax = fallHurtMax;
    }

    public void method_32752(class_2248 block, class_2338 pos) {
        if (block instanceof class_5688) {
            ((class_5688)block).method_10129(this.method_37908(), pos, (class_1540)this);
        }
    }

    public void setDestroyedOnLanding() {
        this.destroyedOnLanding = true;
    }

    protected class_2561 method_23315() {
        return class_2561.method_43469((String)"entity.minecraft.falling_block_type", (Object[])new Object[]{this.block.method_26204().method_9518()});
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this, class_2248.method_9507((class_2680)this.method_6962()));
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.block = class_2248.method_9531((int)packet.method_11166());
        this.field_23807 = true;
        double d = packet.method_11175();
        double e = packet.method_11174();
        double f = packet.method_11176();
        this.method_5814(d, e, f);
        this.method_6963(this.method_24515());
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.block));
        nbt.method_10569("Time", this.timeFalling);
        nbt.method_10556("DropItem", this.dropItem);
        nbt.method_10556("HurtEntities", this.hurtEntities);
        nbt.method_10548("FallHurtAmount", this.fallHurtAmount);
        nbt.method_10569("FallHurtMax", this.fallHurtMax);
        if (this.blockEntityData != null) {
            nbt.method_10566("TileEntityData", (class_2520)this.blockEntityData);
        }
        nbt.method_10556("CancelDrop", this.destroyedOnLanding);
    }

    protected void method_5749(class_2487 nbt) {
        this.block = class_2512.method_10681((class_2487)nbt.method_10562("BlockState"));
        this.timeFalling = nbt.method_10550("Time");
        if (nbt.method_10573("HurtEntities", 99)) {
            this.hurtEntities = nbt.method_10577("HurtEntities");
            this.fallHurtAmount = nbt.method_10583("FallHurtAmount");
            this.fallHurtMax = nbt.method_10550("FallHurtMax");
        } else if (this.block.method_26164(class_3481.field_15486)) {
            this.hurtEntities = true;
        }
        if (nbt.method_10573("DropItem", 99)) {
            this.dropItem = nbt.method_10577("DropItem");
        }
        if (nbt.method_10573("TileEntityData", 10)) {
            this.blockEntityData = nbt.method_10562("TileEntityData");
        }
        this.destroyedOnLanding = nbt.method_10577("CancelDrop");
        if (this.block.method_26215()) {
            this.block = class_2246.field_10102.method_9564();
        }
    }
}

