/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.entity;

import com.neep.neepmeat.api.block.PressureWashable;
import com.neep.neepmeat.entity.SimpleProjectileEntity;
import com.neep.neepmeat.init.NMParticles;
import com.neep.neepmeat.network.NMTrackedData;
import com.neep.neepmeat.particle.PressureWashParticleType;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1900;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class PressureWashEntity
extends SimpleProjectileEntity {
    private static final class_2940<Integer> COLOUR = class_2945.method_12791(PressureWashEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_3611> FLUID = class_2945.method_12791(PressureWashEntity.class, NMTrackedData.FLUID);
    private final Set<class_2338> visited = new HashSet<class_2338>();
    private int power;
    private FluidVariant fluidVariant = FluidVariant.blank();

    public PressureWashEntity(class_1299<? extends PressureWashEntity> type, class_1937 world) {
        super(type, world);
    }

    public void setPower(int power, FluidVariant fluidVariant) {
        this.power = power;
        this.fluidVariant = fluidVariant;
        this.field_6011.method_12778(FLUID, (Object)fluidVariant.getFluid());
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOUR, (Object)0xFFFFFF);
        this.field_6011.method_12784(FLUID, (Object)class_3612.field_15906);
    }

    protected void processBlock(class_2338 pos, class_2680 state) {
        if (!this.method_37908().method_8608() && this.power > 0) {
            if (this.visited.contains(pos)) {
                return;
            }
            this.visited.add(pos);
            PressureWashable washable = PressureWashable.get(state);
            if (washable != null && this.method_36971(this.method_37908(), pos)) {
                int col = washable.tint();
                if (col != -1) {
                    this.field_6011.method_12778(COLOUR, (Object)col);
                }
                int removed = washable.wash(this.method_37908(), pos, state, this.method_18798(), this.power, this.fluidVariant);
                this.power = Math.max(0, this.power - removed);
            }
            if (this.power <= 0) {
                this.splashRemove();
            }
        }
    }

    protected void method_5622(class_2680 state) {
        super.method_5622(state);
    }

    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        if (!this.method_37908().method_8608()) {
            class_1309 livingEntity;
            class_1297 owner = this.method_24921();
            class_1297 entity = entityHitResult.method_17782();
            entity.method_5643(class_1282.method_5519((class_1297)this, owner instanceof class_1309 ? (livingEntity = (class_1309)owner) : null), 1.0f);
            if (FluidVariantAttributes.getTemperature((FluidVariant)this.fluidVariant) >= 1300) {
                PressureWashEntity.setOnFireFor(entity, 40);
            }
        }
    }

    public static void setOnFireFor(class_1297 entity, int ticks) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            ticks = class_1900.method_8238((class_1309)livingEntity, (int)ticks);
        }
        if (entity.method_20802() < ticks) {
            entity.method_20803(ticks);
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (FluidVariantAttributes.getTemperature((FluidVariant)FluidVariant.of((class_3611)((class_3611)this.field_6011.method_12789(FLUID)))) >= 1000 && this.method_37908().method_8608()) {
            this.method_37908().method_8406((class_2394)class_2398.field_11237, this.method_23317(), this.method_23318(), this.method_23321(), this.field_5974.method_43385(0.0, 0.1), this.field_5974.method_43385(0.0, 0.1), this.field_5974.method_43385(0.0, 0.1));
        }
    }

    protected void applyToNearbyBlocks() {
        class_238 box = this.method_5829();
        double d = 0.1;
        class_2338 blockPos = new class_2338(box.field_1323 - d, box.field_1322 - d, box.field_1321 - d);
        class_2338 blockPos2 = new class_2338(box.field_1320 + d, box.field_1325 + d, box.field_1324 + d);
        if (this.method_37908().method_22343(blockPos, blockPos2)) {
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int i = blockPos.method_10263(); i <= blockPos2.method_10263(); ++i) {
                for (int j = blockPos.method_10264(); j <= blockPos2.method_10264(); ++j) {
                    for (int k = blockPos.method_10260(); k <= blockPos2.method_10260(); ++k) {
                        mutable.method_10103(i, j, k);
                        class_2680 blockState = this.method_37908().method_8320((class_2338)mutable);
                        this.processBlock((class_2338)mutable, blockState);
                    }
                }
            }
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        class_243 vel = this.method_18798();
        if (this.method_37908().method_8608()) {
            int col = (Integer)this.field_6011.method_12789(COLOUR);
            class_3611 fluid = (class_3611)this.field_6011.method_12789(FLUID);
            this.method_37908().method_8406((class_2394)new PressureWashParticleType.Parameters(NMParticles.PRESSURE_WASH_BEAM, 0.0f, col, fluid), this.method_23317(), this.method_23318(), this.method_23321(), vel.field_1352 + this.field_5974.method_43385(0.0, 0.1), vel.field_1351 + this.field_5974.method_43385(0.0, 0.1), vel.field_1350 + this.field_5974.method_43385(0.0, 0.1));
        }
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_1021(0.8));
        }
        if (this.field_6012 > 40) {
            this.method_31472();
        }
        if (vel.method_1033() < 0.05) {
            this.splashRemove();
        }
        this.applyToNearbyBlocks();
    }

    private void splashRemove() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)new PressureWashParticleType.Parameters(NMParticles.FLUID_DRIP, 1.0f, 0xFFFFFF, this.fluidVariant.getFluid()), this.method_23317(), this.method_23318(), this.method_23321(), 10, 0.6, 0.6, 0.6, 0.1);
        }
        this.method_31472();
    }

    @Override
    protected double getGravity() {
        return 0.04;
    }

    public boolean method_5740() {
        return false;
    }
}

