/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.entity;

import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1313;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3486;
import net.minecraft.class_3532;

public abstract class SimpleEntity
extends class_1297 {
    private static final class_2940<Float> SIDEWAYS_SPEED = class_2945.method_12791(SimpleEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> FORWARD_SPEED = class_2945.method_12791(SimpleEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> UPWARD_SPEED = class_2945.method_12791(SimpleEntity.class, (class_2941)class_2943.field_13320);
    protected int trackingIncrements;
    protected double serverX;
    protected double serverY;
    protected double serverZ;
    protected double serverPitch;
    protected double serverYaw;
    private float sidewaysSpeed;
    private float forwardSpeed;
    private float upwardSpeed;

    public SimpleEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5693() {
        this.field_6011.method_12784(SIDEWAYS_SPEED, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(FORWARD_SPEED, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(UPWARD_SPEED, (Object)Float.valueOf(0.0f));
    }

    protected float getBaseMovementSpeedMultiplier() {
        return 0.8f;
    }

    public boolean shouldSwim() {
        return false;
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.serverX = x;
        this.serverY = y;
        this.serverZ = z;
        this.serverYaw = yaw;
        this.serverPitch = pitch;
        this.trackingIncrements = interpolationSteps;
    }

    protected void interpolatePosition() {
        if (this.trackingIncrements > 0) {
            double d = this.method_23317() + (this.serverX - this.method_23317()) / (double)this.trackingIncrements;
            double e = this.method_23318() + (this.serverY - this.method_23318()) / (double)this.trackingIncrements;
            double f = this.method_23321() + (this.serverZ - this.method_23321()) / (double)this.trackingIncrements;
            double g = class_3532.method_15338((double)(this.serverYaw - (double)this.method_36454()));
            this.method_36456(this.method_36454() + (float)g / (float)this.trackingIncrements);
            this.method_36457(this.method_36455() + (float)(this.serverPitch - (double)this.method_36455()) / (float)this.trackingIncrements);
            --this.trackingIncrements;
            this.method_5814(d, e, f);
            this.method_5710(this.method_36454(), this.method_36455());
        }
    }

    public void tickMovement() {
        if (this.method_5787()) {
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        this.interpolatePosition();
        class_243 vec3d = this.method_18798();
        double h = vec3d.field_1352;
        double i = vec3d.field_1351;
        double j = vec3d.field_1350;
        if (Math.abs(vec3d.field_1352) < 0.003) {
            h = 0.0;
        }
        if (Math.abs(vec3d.field_1351) < 0.003) {
            i = 0.0;
        }
        if (Math.abs(vec3d.field_1350) < 0.003) {
            j = 0.0;
        }
        this.method_18800(h, i, j);
        this.field_6002.method_16107().method_15396("travel");
        this.sidewaysSpeed *= 0.98f;
        this.forwardSpeed *= 0.98f;
        this.travel(new class_243((double)this.sidewaysSpeed, (double)this.upwardSpeed, (double)this.forwardSpeed));
        this.field_6002.method_16107().method_15407();
        this.field_6002.method_16107().method_15396("push");
        this.tickCramming();
        this.field_6002.method_16107().method_15407();
    }

    public class_243 applyVerticalSpeed(double d, boolean bl, class_243 vec3d) {
        if (!this.method_5740() && !this.method_5624()) {
            double e = bl && Math.abs(vec3d.field_1351 - 0.005) >= 0.003 && Math.abs(vec3d.field_1351 - d / 16.0) < 0.003 ? -0.003 : vec3d.field_1351 - d / 16.0;
            return new class_243(vec3d.field_1352, e, vec3d.field_1350);
        }
        return vec3d;
    }

    protected void swimInWater(class_243 movementInput) {
        double y = this.method_23318();
        float forward = this.method_5624() ? 0.9f : this.getBaseMovementSpeedMultiplier();
        float g = 0.02f;
        this.method_5724(g, movementInput);
        this.method_5784(class_1313.field_6308, this.method_18798());
        class_243 vec3d = this.method_18798();
        this.method_18799(vec3d.method_18805((double)forward, (double)0.8f, (double)forward));
        class_243 vec3d2 = this.applyVerticalSpeed(0.08f, false, this.method_18798());
        this.method_18799(vec3d2);
        if (this.field_5976 && this.method_5654(vec3d2.field_1352, vec3d2.field_1351 + (double)0.6f - this.method_23318() + y, vec3d2.field_1350)) {
            this.method_18800(vec3d2.field_1352, 0.3f, vec3d2.field_1350);
        }
    }

    protected void swimInLava(class_243 movementInput, double d) {
        class_243 vec3d3;
        double e = this.method_23318();
        this.method_5724(0.02f, movementInput);
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (this.method_5861(class_3486.field_15518) <= this.method_29241()) {
            this.method_18799(this.method_18798().method_18805(0.5, (double)0.8f, 0.5));
            vec3d3 = this.applyVerticalSpeed(d, false, this.method_18798());
            this.method_18799(vec3d3);
        } else {
            this.method_18799(this.method_18798().method_1021(0.5));
        }
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -d / 4.0, 0.0));
        }
        vec3d3 = this.method_18798();
        if (this.field_5976 && this.method_5654(vec3d3.field_1352, vec3d3.field_1351 + (double)0.6f - this.method_23318() + e, vec3d3.field_1350)) {
            this.method_18800(vec3d3.field_1352, 0.3f, vec3d3.field_1350);
        }
    }

    protected void moveOnLand(class_243 movementInput, double d) {
        class_2338 blockPos = this.method_23314();
        float slipperiness = this.field_6002.method_8320(blockPos).method_26204().method_9499();
        float f = this.field_5952 ? slipperiness * 0.91f : 0.91f;
        class_243 vec3d6 = this.applyMovementInput(movementInput, slipperiness);
        double q = vec3d6.field_1351;
        if (!this.field_6002.field_9236 || this.field_6002.method_22340(blockPos)) {
            if (!this.method_5740()) {
                q -= d;
            }
        } else {
            q = this.method_23318() > (double)this.field_6002.method_31607() ? -0.1 : 0.0;
        }
        this.method_18800(vec3d6.field_1352 * (double)f, q * (double)0.98f, vec3d6.field_1350 * (double)f);
    }

    public void travel(class_243 movementInput) {
        if (this.method_5787()) {
            double d = 0.08;
            if (this.method_5799() && this.shouldSwim()) {
                this.swimInWater(movementInput);
            } else if (this.method_5771() && this.shouldSwim()) {
                this.swimInLava(movementInput, d);
            } else {
                this.moveOnLand(movementInput, d);
            }
        }
    }

    public class_243 applyMovementInput(class_243 movementInput, float slipperiness) {
        this.method_5724(this.getMovementSpeed(slipperiness), movementInput);
        this.method_5784(class_1313.field_6308, this.method_18798());
        return this.method_18798();
    }

    public float getMovementSpeed() {
        return 0.1f;
    }

    private float getMovementSpeed(float slipperiness) {
        return this.getMovementSpeed() * (0.2f / (slipperiness * slipperiness * slipperiness));
    }

    protected void tickCramming() {
        List list = this.field_6002.method_8333((class_1297)this, this.method_5829(), class_1301.method_5911((class_1297)this));
        if (!list.isEmpty()) {
            int j;
            int i = this.field_6002.method_8450().method_8356(class_1928.field_19405);
            if (i > 0 && list.size() > i - 1 && this.field_5974.method_43048(4) == 0) {
                j = 0;
                for (class_1297 entity : list) {
                    if (entity.method_5765()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.method_5643(class_1282.field_5844, 6.0f);
                }
            }
            for (j = 0; j < list.size(); ++j) {
                class_1297 entity = (class_1297)list.get(j);
                this.method_5697(entity);
            }
        }
    }

    protected void method_5749(class_2487 nbt) {
    }

    protected void method_5652(class_2487 nbt) {
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_30948() {
        return false;
    }

    public boolean method_30949(class_1297 other) {
        return other.method_30948();
    }

    public boolean method_5810() {
        return true;
    }
}

