/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.entity.scutter;

import com.neep.meatlib.inventory.ImplementedInventory;
import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.entity.scutter.ScutterBreakCropGoal;
import com.neep.neepmeat.entity.scutter.ScutterEntity;
import com.neep.neepmeat.entity.scutter.ScutterFindGrownCropsGoal;
import com.neep.neepmeat.entity.scutter.ScutterMoveToCropGoal;
import com.neep.neepmeat.entity.scutter.ScutterReturnHomeGoal;
import com.neep.neepmeat.init.NMItems;
import com.neep.neepmeat.init.NMSounds;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class FarmingScutter
extends ScutterEntity {
    private final ImplementedInventory inventory = ImplementedInventory.ofSize(6);
    private final InventoryStorage storage = InventoryStorage.of((class_1263)this.inventory, null);
    private final LinkedHashSet<class_2338> targets = new LinkedHashSet();
    @Nullable
    private class_2338 storagePos;
    private class_2338 homePos = new class_2338(this.method_19538());

    public FarmingScutter(class_1299<? extends ScutterEntity> type, class_1937 world) {
        super(type, world);
    }

    public void setStoragePos(@Nullable class_2338 pos) {
        this.storagePos = pos;
    }

    public void setHomePos(class_2338 homePos) {
        this.homePos = homePos;
    }

    public class_2338 getHomePos() {
        return this.homePos;
    }

    public static boolean isGrownCrop(class_2680 state) {
        class_2302 cropBlock;
        class_2248 class_22482 = state.method_26204();
        return class_22482 instanceof class_2302 && (cropBlock = (class_2302)class_22482).method_9825(state);
    }

    public static boolean hasMoisture(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12510) || state.method_26164(NMTags.FARMLAND);
    }

    public class_2487 method_5647(class_2487 nbt) {
        super.method_5647(nbt);
        this.inventory.writeNbt(nbt);
        nbt.method_10566("home", (class_2520)class_2512.method_10692((class_2338)this.homePos));
        if (this.storagePos != null) {
            nbt.method_10566("storage", (class_2520)class_2512.method_10692((class_2338)this.storagePos));
        }
        return nbt;
    }

    public void method_5651(class_2487 nbt) {
        super.method_5651(nbt);
        this.inventory.readNbt(nbt);
        this.homePos = class_2512.method_10691((class_2487)nbt.method_10562("home"));
        if (nbt.method_10545("storage")) {
            this.storagePos = class_2512.method_10691((class_2487)nbt.method_10562("storage"));
        }
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new ScutterBreakCropGoal(this));
        this.field_6201.method_6277(2, (class_1352)new ScutterMoveToCropGoal(this, 0.3f, 32));
        this.field_6201.method_6277(3, (class_1352)new ScutterFindGrownCropsGoal(this, 40));
        this.field_6201.method_6277(4, (class_1352)new ScutterReturnHomeGoal(this, 0.3f, 32));
    }

    public class_1269 method_5664(class_1657 player, class_243 hitPos, class_1268 hand) {
        if (player.method_5715()) {
            class_1799 stack = new class_1799((class_1935)NMItems.FARMING_SCUTTER);
            if (this.method_5797() != null) {
                stack.method_7977(this.method_5797());
            }
            this.method_5775(stack);
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                this.method_5775(this.inventory.method_5438(i));
            }
            this.method_5650(class_1297.class_5529.field_26999);
            return class_1269.field_5812;
        }
        return super.method_5664(player, hitPos, hand);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608() && this.method_37908().method_8510() % 20L == 0L && this.isAtHome() && !this.inventory.method_5442()) {
            this.depositItems();
        }
        this.targets.removeIf(p -> !FarmingScutter.isGrownCrop(this.method_37908().method_8320(p)));
    }

    public void method_6007() {
        super.method_6007();
    }

    public void harvest(class_1937 world, class_2338 pos, class_2680 state, class_2302 block) {
        class_2586 blockEntity = state.method_31709() ? world.method_8321(pos) : null;
        List stacks = class_2248.method_9609((class_2680)state, (class_3218)((class_3218)world), (class_2338)pos, (class_2586)blockEntity, (class_1297)this, (class_1799)class_1799.field_8037);
        try (Transaction transaction = Transaction.openOuter();){
            for (class_1799 stack : stacks) {
                this.storage.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
            }
            transaction.commit();
        }
        world.method_8501(pos, block.method_9828(0));
        world.method_8396(null, this.method_24515(), block.method_9573(state).method_10595(), class_3419.field_15245, 1.0f, 1.0f);
    }

    public void depositItems() {
        Storage homeStorage;
        if (this.storagePos != null && (homeStorage = (Storage)ItemStorage.SIDED.find(this.method_37908(), this.storagePos, (Object)class_2350.field_11036)) != null) {
            try (Transaction transaction = Transaction.openOuter();){
                long transferred = StorageUtil.move((Storage)this.storage, (Storage)homeStorage, v -> true, (long)Long.MAX_VALUE, (TransactionContext)transaction);
                if (transferred > 0L) {
                    this.method_37908().method_8396(null, this.method_24515(), NMSounds.DEPOSIT_ITEMS, class_3419.field_15254, 1.0f, 1.0f);
                    transaction.commit();
                }
            }
        }
        for (class_1799 stack : this.inventory.getItems()) {
            this.method_5775(stack);
        }
        this.inventory.method_5448();
    }

    public void addTargets(Collection<class_2338> nearest) {
        this.targets.addAll(nearest);
    }

    public Set<class_2338> getTargets() {
        return this.targets;
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)NMItems.FARMING_SCUTTER);
    }

    public ImplementedInventory getInventory() {
        return this.inventory;
    }

    public boolean needsEmptying() {
        return this.inventory.emptyStacks() == 0.0f;
    }

    public boolean isAtHome() {
        return this.method_19538().method_24802((class_2374)class_243.method_24953((class_2382)this.getHomePos()), 1.0);
    }

    public boolean method_5733() {
        return true;
    }
}

