/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.entity.skyworm;

import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.entity.SimpleEntity;
import com.neep.neepmeat.entity.skyworm.SkywormAction;
import com.neep.neepmeat.entity.skyworm.SkywormDropEggAction;
import com.neep.neepmeat.init.NMBlocks;
import com.neep.neepmeat.init.NMEntities;
import com.neep.neepmeat.network.ParticleSpawnS2C;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class SkywormEntity
extends SimpleEntity {
    private SkywormAction<?> action;
    public static final class_2940<Integer> BULGE = class_2945.method_12791(SkywormEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> FROM_BELOW = class_2945.method_12791(SkywormEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> ALLOW_WOBBLE = class_2945.method_12791(SkywormEntity.class, (class_2941)class_2943.field_13323);
    public double targetY;
    public int bulgeDirection = 0;

    public static void spawnEvent(class_1542 entity, class_1937 world, class_2338 pos, @Nullable class_1297 owner) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (owner instanceof class_1657) {
                class_1657 player = (class_1657)owner;
                if (!SkywormEntity.checkBlocks(world, pos)) {
                    return;
                }
                entity.method_31472();
                if (world.method_8320(pos).method_27852(class_2246.field_10164)) {
                    world.method_8501(pos, NMBlocks.CONTAMINATED_DIRT.method_9564());
                }
                class_243 centrePos = class_243.method_26410((class_2382)pos, (double)1.0);
                PlayerLookup.around((class_3218)serverWorld, (class_2382)pos, (double)32.0).forEach(p -> ParticleSpawnS2C.send(p, class_2398.field_11240, centrePos, new class_243(0.0, 2.0, 0.0), new class_243(0.2, 2.0, 0.2), 10));
                SkywormEntity worm = (SkywormEntity)NMEntities.SKYWORM.method_5883(world);
                class_243 targetPosition = class_243.method_24953((class_2382)pos).method_1031(0.0, 4.0, 0.0);
                worm.setAction(new SkywormDropEggAction(worm, targetPosition.field_1351));
                class_243 position = targetPosition.method_1031(0.0, 200.0, 0.0);
                worm.method_23327(position.field_1352, position.field_1351, position.field_1350);
                worm.method_5814(position.field_1352, position.field_1351, position.field_1350);
                world.method_8649((class_1297)worm);
            }
        }
    }

    public static SkywormEntity setup(class_1937 world, class_243 position) {
        SkywormEntity worm = (SkywormEntity)NMEntities.SKYWORM.method_5883(world);
        worm.method_23327(position.field_1352, position.field_1351, position.field_1350);
        worm.method_5814(position.field_1352, position.field_1351, position.field_1350);
        return worm;
    }

    public void setAction(SkywormAction<?> action) {
        this.action = action;
    }

    private static boolean checkBlocks(class_1937 world, class_2338 origin) {
        class_2338.class_2339 mutable = origin.method_25503();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                mutable.method_25504((class_2382)origin, i, 0, j);
                if (world.method_8320((class_2338)mutable).method_26164(NMTags.WORM_ALTAR)) continue;
                return false;
            }
        }
        return true;
    }

    public SkywormEntity(class_1299<? extends SkywormEntity> type, class_1937 world) {
        super(type, world);
    }

    public void setTargetY(double y) {
        this.targetY = y;
    }

    @Override
    protected void method_5693() {
        this.field_6011.method_12784(BULGE, (Object)-1);
        this.field_6011.method_12784(FROM_BELOW, (Object)false);
        this.field_6011.method_12784(ALLOW_WOBBLE, (Object)true);
    }

    @Override
    protected void method_5749(class_2487 nbt) {
    }

    @Override
    protected void method_5652(class_2487 nbt) {
    }

    public void method_5773() {
        super.method_5773();
        if (this.action != null && !this.method_37908().method_8608()) {
            this.action.method_6268();
        }
        if (this.method_5787()) {
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        this.interpolatePosition();
        this.tickBulge();
    }

    private void tickBulge() {
        if (this.field_6012 % 2 == 0) {
            int bulge = this.getBulge();
            this.setBulge(class_3532.method_15340((int)(bulge + this.bulgeDirection), (int)-1, (int)this.getLength()));
        }
    }

    public void setBulgeDirection(int direction) {
        this.bulgeDirection = direction;
    }

    protected void method_5825() {
    }

    public int getBulge() {
        return (Integer)this.field_6011.method_12789(BULGE);
    }

    public void setBulge(int bulge) {
        this.field_6011.method_12778(BULGE, (Object)bulge);
    }

    public void setFromBelow(boolean fromBelow) {
        this.field_6011.method_12778(FROM_BELOW, (Object)fromBelow);
    }

    public boolean getFromBelow() {
        return (Boolean)this.field_6011.method_12789(FROM_BELOW);
    }

    public void setAllowWobble(boolean wobble) {
        this.field_6011.method_12778(ALLOW_WOBBLE, (Object)wobble);
    }

    @Override
    public boolean method_30949(class_1297 other) {
        return false;
    }

    public boolean method_30632(class_2338 pos, class_2680 state) {
        return false;
    }

    public int getLength() {
        return 50;
    }

    public boolean method_31746() {
        return false;
    }

    public boolean allowWobble() {
        return (Boolean)this.field_6011.method_12789(ALLOW_WOBBLE);
    }

    public class_5819 getRandom() {
        return this.field_5974;
    }
}

