/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.guide.article;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.neep.neepmeat.client.screen.tablet.ArticleTextWidget;
import com.neep.neepmeat.guide.article.CenteredTextContent;
import com.neep.neepmeat.guide.article.CodeContent;
import com.neep.neepmeat.guide.article.ImageContent;
import com.neep.neepmeat.guide.article.TextContent;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.IntConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public interface Article {
    public static final class_2960 FONT_ID = new class_2960("neepmeat", "vt323");
    public static final Map<String, Function<JsonObject, Content>> DESERIALISERS = new HashMap<String, Function<JsonObject, Content>>();
    public static final Function<JsonObject, Content> TEXT = DESERIALISERS.put("text", object -> {
        JsonElement textObject = object.get("text");
        if (textObject.isJsonArray()) {
            class_5250 text = class_5250.method_43477((class_7417)class_7417.field_39004);
            textObject.getAsJsonArray().forEach(element -> text.method_10852((class_2561)class_2561.class_2562.method_10872((JsonElement)element)));
            return new TextContent((class_2561)text);
        }
        class_5250 text = class_2561.class_2562.method_10872((JsonElement)object);
        return new TextContent((class_2561)text);
    });
    public static final Function<JsonObject, Content> CODE = DESERIALISERS.put("code", object -> {
        JsonElement textObject = object.get("text");
        if (textObject.isJsonArray()) {
            class_5250 text = class_5250.method_43477((class_7417)class_7417.field_39004);
            textObject.getAsJsonArray().forEach(element -> text.method_10852((class_2561)class_2561.class_2562.method_10872((JsonElement)element)));
            return new CodeContent(text);
        }
        class_5250 text = class_2561.class_2562.method_10872((JsonElement)object);
        return new CodeContent(text);
    });
    public static final Function<JsonObject, Content> CTEXT = DESERIALISERS.put("ctext", object -> {
        class_5250 text = class_2561.class_2562.method_10872((JsonElement)object);
        return new CenteredTextContent(text);
    });
    public static final Function<JsonObject, Content> IMAGE = DESERIALISERS.put("image", object -> {
        int width = class_3518.method_15260((JsonObject)object, (String)"width");
        int height = class_3518.method_15260((JsonObject)object, (String)"height");
        float scale = 0.5f;
        if (class_3518.method_34920((JsonObject)object, (String)"scale")) {
            scale = class_3518.method_15259((JsonObject)object, (String)"scale");
        }
        class_2960 image = new class_2960(class_3518.method_15265((JsonObject)object, (String)"path"));
        return new ImageContent(width, height, scale, image);
    });
    public static final Article EMPTY = new Simple();

    public Iterable<? extends Content> contents();

    default public IntList search(String term, float width, ArticleTextWidget parent) {
        IntArrayList result = new IntArrayList();
        AtomicInteger h = new AtomicInteger(0);
        IntConsumer append = arg_0 -> Article.lambda$search$6((IntList)result, h, arg_0);
        for (Content content : this.contents()) {
            content.search(term, append, width, parent);
            h.addAndGet(content.height(width, parent));
        }
        return result;
    }

    private static /* synthetic */ void lambda$search$6(IntList result, AtomicInteger h, int i) {
        result.add(h.get() + i);
    }

    public static interface Content {
        public int render(class_4587 var1, float var2, float var3, float var4, double var5, ArticleTextWidget var7);

        public int height(float var1, ArticleTextWidget var2);

        public void search(String var1, IntConsumer var2, float var3, ArticleTextWidget var4);
    }

    public static final class Simple
    extends Record
    implements Article {
        private final List<Content> contents;

        public Simple() {
            this((List<Content>)new ObjectArrayList());
        }

        public Simple(List<Content> contents) {
            this.contents = contents;
        }

        public static Article fromJson(JsonObject object) {
            String id = class_3518.method_15265((JsonObject)object, (String)"id");
            Simple article = new Simple();
            class_3518.method_15292((JsonObject)object, (String)"contents", (JsonArray)new JsonArray()).forEach(element -> {
                JsonObject content = (JsonObject)element;
                String contentType = class_3518.method_15265((JsonObject)content, (String)"type");
                article.contents.add(DESERIALISERS.getOrDefault(contentType, o -> {
                    throw new JsonParseException("Unknown article content type '" + contentType + "'");
                }).apply(content));
            });
            return article;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Simple.class, "contents", "contents"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Simple.class, "contents", "contents"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Simple.class, "contents", "contents"}, this, o);
        }

        public List<Content> contents() {
            return this.contents;
        }
    }
}

