/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.item;

import com.neep.meatlib.client.MeatlibFluidRendering;
import com.neep.meatlib.item.BaseItem;
import com.neep.meatlib.item.TooltipSupplier;
import com.neep.meatweapons.item.GunItem;
import com.neep.meatweapons.item.WeakTwoHanded;
import com.neep.meatweapons.network.MWAttackC2SPacket;
import com.neep.neepmeat.component.PressureWasherComponent;
import com.neep.neepmeat.entity.PressureWashEntity;
import com.neep.neepmeat.entity.SimpleProjectileEntity;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.init.NMEntities;
import com.neep.neepmeat.init.NMParticles;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.network.ParticleSpawnS2C;
import com.neep.neepmeat.particle.PressureWashParticleType;
import com.neep.neepmeat.util.MiscUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.item.CursorSlotWrapper;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5819;

public class PressureWasherItem
extends BaseItem
implements GunItem,
WeakTwoHanded {
    private final class_5819 random = class_5819.method_43047();

    public PressureWasherItem(TooltipSupplier tooltipSupplier, class_1792.class_1793 settings) {
        super(tooltipSupplier, settings.method_7889(1));
        FluidStorage.ITEM.registerForItems(this::getStorage, new class_1935[]{this});
    }

    @Override
    public boolean displayArmFirstPerson(class_1799 stack, class_1268 hand) {
        return false;
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    @Override
    public class_243 getMuzzleOffset(class_1309 entity, class_1799 stack) {
        boolean sneak = entity.method_5715();
        return new class_243(sneak ? 0.0 : (entity.method_6047().equals(stack) == (entity.method_6068() == class_1306.field_6183) ? -0.2 : 0.2), sneak ? -0.25 : -0.2, 0.5);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (user.method_5715()) {
                class_1799 stack = user.method_5998(hand);
                PressureWasherComponent component = (PressureWasherComponent)NMComponents.PRESSURE_WASHER.get((Object)stack);
                long amount = component.getAmount();
                component.setAmount(0L);
                component.setFluid(FluidVariant.blank());
                stack.method_7974(this.method_7841());
                if (amount > 0L) {
                    world.method_8396(null, user.method_24515(), class_3417.field_14876, class_3419.field_15248, 0.2f, 1.0f);
                }
                return class_1271.method_22427((Object)stack);
            }
        }
        return super.method_7836(world, user, hand);
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        return super.method_31565(stack, slot, clickType, player);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (player.field_7512 != null && !otherStack.method_7960()) {
            CursorSlotWrapper wrapper = CursorSlotWrapper.get((class_1703)player.field_7512);
            class_1799 slotStack = slot.method_7677();
            Storage storage = (Storage)FluidStorage.ITEM.find(otherStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)wrapper));
            InventoryStorage inventory = InventoryStorage.of((class_1263)player.field_7514, (class_2350)class_2350.field_11036);
            SingleSlotStorage inventorySlot = inventory.getSlot(slot.method_34266());
            StackStorage washerStorage = this.getStorage(stack, ContainerItemContext.ofPlayerSlot((class_1657)player, (SingleSlotStorage)inventorySlot));
            try (Transaction transaction = Transaction.openOuter();){
                AtomicReference<FluidVariant> lastVariant = new AtomicReference<FluidVariant>(FluidVariant.blank());
                long moved = StorageUtil.move((Storage)storage, (Storage)washerStorage, v -> {
                    lastVariant.set((FluidVariant)v);
                    return true;
                }, (long)washerStorage.getCapacity(), (TransactionContext)transaction);
                if (moved > 0L && !lastVariant.get().isBlank()) {
                    player.method_5783(FluidVariantAttributes.getFillSound((FluidVariant)lastVariant.get()), 1.0f, 1.0f);
                }
                transaction.commit();
            }
            return true;
        }
        return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    @Override
    public void tickTrigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            PressureWasherComponent component = (PressureWasherComponent)NMComponents.PRESSURE_WASHER.get((Object)stack);
            long perEntity = 450L;
            long amount = component.getAmount();
            FluidVariant variant = component.getFluid();
            if (amount >= perEntity && !variant.isBlank()) {
                class_243 eyePos = player.method_33571();
                double speed = 1.0;
                double spread = 0.05;
                class_243 transform = this.getMuzzleOffset((class_1309)player, stack).method_1037((float)(-pitch)).method_1024((float)(-yaw));
                class_243 particlePos = eyePos.method_1019(transform);
                class_243 velocity = player.method_5720().method_1021(speed);
                velocity = SimpleProjectileEntity.makeVelocity(velocity.field_1352, velocity.field_1351, velocity.field_1350, (float)speed, 0.2f, this.random).method_1019(player.method_18798());
                class_243 spreadVec = new class_243(spread, spread, spread);
                ParticleSpawnS2C.send((class_3222)player, new PressureWashParticleType.Parameters(NMParticles.PRESSURE_WASH_BEAM, 1.0f, 0xFFFFFF, variant.getFluid()), particlePos, velocity, spreadVec, 2);
                player.method_17356(NMSounds.PRESSURE_WASHER_SQUIRT, class_3419.field_15248, 1.0f, (float)this.random.method_43385(1.0, 0.1));
                if (world.method_8510() % 5L == 0L) {
                    PressureWashEntity projectile = (PressureWashEntity)NMEntities.PRESSURE_WASH.method_5883(world);
                    projectile.method_33574(particlePos);
                    projectile.method_7432((class_1297)player);
                    projectile.method_23327(particlePos.field_1352, particlePos.field_1351, particlePos.field_1350);
                    projectile.method_7485(velocity.field_1352, velocity.field_1351, velocity.field_1350, (float)speed, 0.1f);
                    projectile.setPower(3, variant);
                    world.method_8649((class_1297)projectile);
                    component.setAmount(Math.max(0L, amount - perEntity));
                }
            }
        }
    }

    public int method_31571(class_1799 stack) {
        PressureWasherComponent component = (PressureWasherComponent)NMComponents.PRESSURE_WASHER.getNullable((Object)stack);
        if (component != null) {
            return MeatlibFluidRendering.getColor(component.getFluid(), true);
        }
        return super.method_31571(stack);
    }

    public boolean method_31567(class_1799 stack) {
        PressureWasherComponent component = (PressureWasherComponent)NMComponents.PRESSURE_WASHER.getNullable((Object)stack);
        if (component != null) {
            return stack.method_7919() == this.method_7841() || component.getAmount() != 0L;
        }
        return false;
    }

    public int method_31569(class_1799 stack) {
        PressureWasherComponent component = (PressureWasherComponent)NMComponents.PRESSURE_WASHER.getNullable((Object)stack);
        if (component != null) {
            return (int)(13.0 * (double)component.getAmount() / (double)component.getCapacity());
        }
        return 0;
    }

    public class_2561 method_7864(class_1799 stack) {
        PressureWasherComponent component = (PressureWasherComponent)NMComponents.PRESSURE_WASHER.getNullable((Object)stack);
        if (component != null && component.getAmount() > 0L) {
            return class_2561.method_43469((String)(this.method_7876() + ".full"), (Object[])new Object[]{FluidVariantAttributes.getName((FluidVariant)component.getFluid()), MiscUtil.dropletsToMb(component.getAmount())});
        }
        return super.method_7864(stack);
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        PressureWasherComponent component = (PressureWasherComponent)NMComponents.PRESSURE_WASHER.getNullable((Object)stack);
        if (component != null) {
            FluidVariant variant = component.getFluid();
            long mb = MiscUtil.dropletsToMb(component.getAmount());
            int col = FluidVariantRendering.getColor((FluidVariant)variant);
            class_5250 text = FluidVariantAttributes.getName((FluidVariant)variant).method_27661();
            text.method_27693(": " + mb + "mb");
            text.method_10862(text.method_10866().method_36139(col));
            tooltip.add((class_2561)text);
        }
        super.method_7851(stack, world, tooltip, tooltipContext);
    }

    @Override
    public void syncAnimation(class_1937 world, class_1309 player, class_1799 stack, int animation, boolean broadcast) {
    }

    public class_5819 getRandom() {
        return this.random;
    }

    public StackStorage getStorage(class_1799 stack, ContainerItemContext context) {
        return new StackStorage(context);
    }

    public record StackStorage(ContainerItemContext context) implements SingleSlotStorage<FluidVariant>
    {
        private class_1799 getStack() {
            return this.context.getItemVariant().toStack((int)this.context.getAmount());
        }

        public long insert(FluidVariant insertedResource, long maxAmount, TransactionContext transaction) {
            long insertedAmount;
            StoragePreconditions.notBlankNotNegative((TransferVariant)insertedResource, (long)maxAmount);
            long amount = this.getAmount();
            FluidVariant resource = this.getResource();
            if ((insertedResource.equals(resource) || resource.isBlank()) && (insertedAmount = Math.min(maxAmount, this.getCapacity() - amount)) > 0L) {
                if (resource.isBlank()) {
                    this.setResource(insertedResource, transaction);
                    this.setAmount(insertedAmount, transaction);
                } else {
                    this.setAmount(amount + insertedAmount, transaction);
                }
                return insertedAmount;
            }
            return 0L;
        }

        public long extract(FluidVariant extractedResource, long maxAmount, TransactionContext transaction) {
            long extractedAmount;
            StoragePreconditions.notBlankNotNegative((TransferVariant)extractedResource, (long)maxAmount);
            FluidVariant resource = this.getResource();
            long amount = this.getAmount();
            if (extractedResource.equals(resource) && (extractedAmount = Math.min(maxAmount, amount)) > 0L) {
                this.setAmount(amount - extractedAmount, transaction);
                if (amount - extractedAmount == 0L) {
                    this.setResource(FluidVariant.blank(), transaction);
                }
                return extractedAmount;
            }
            return 0L;
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public FluidVariant getResource() {
            return StackStorage.getResource(this.context.getItemVariant());
        }

        public static FluidVariant getResource(ItemVariant stack) {
            return ((PressureWasherComponent)NMComponents.PRESSURE_WASHER.get((Object)stack.toStack())).getFluid();
        }

        public void setResource(FluidVariant resource, TransactionContext transaction) {
            class_1799 stack = this.getStack();
            PressureWasherComponent component = (PressureWasherComponent)NMComponents.PRESSURE_WASHER.get((Object)stack);
            component.setFluid(resource);
            this.context.exchange(ItemVariant.of((class_1799)stack.method_7972()), 1L, transaction);
        }

        public long getAmount() {
            return StackStorage.getAmount(this.context.getItemVariant());
        }

        public static long getAmount(ItemVariant stack) {
            return ((PressureWasherComponent)NMComponents.PRESSURE_WASHER.get((Object)stack.toStack())).getAmount();
        }

        public void setAmount(long amount, TransactionContext transaction) {
            class_1799 stack = this.getStack();
            PressureWasherComponent component = (PressureWasherComponent)NMComponents.PRESSURE_WASHER.get((Object)stack);
            component.setAmount(amount);
            this.context.exchange(ItemVariant.of((class_1799)stack.method_7972()), 1L, transaction);
        }

        public long getCapacity() {
            return ((PressureWasherComponent)NMComponents.PRESSURE_WASHER.get((Object)this.getStack())).getCapacity();
        }
    }
}

