/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.item.util;

import com.google.common.collect.Iterators;
import com.neep.neepmeat.api.processing.PowerUtils;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;

public class LivingItemStorage
extends SnapshotParticipant<Integer>
implements InsertionOnlyStorage<FluidVariant>,
StorageView<FluidVariant> {
    public static final int ENERGY_PER_DURABILITY = 500;
    protected final class_1799 stack;
    protected final ContainerItemContext context;

    public LivingItemStorage(class_1799 stack, ContainerItemContext context) {
        this.stack = stack.method_7972();
        this.context = context;
    }

    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        long energy = PowerUtils.amountToAbsEnergy(maxAmount, insertedVariant.getFluid());
        int currentEnergy = (this.stack.method_7936() - this.stack.method_7919()) * 500;
        long insertedEnergy = Math.min(energy, (long)(this.energyCapacity() - currentEnergy));
        if (insertedEnergy > 0L) {
            this.updateSnapshots(transaction);
            int insertedDamage = (int)(insertedEnergy / 500L);
            this.stack.method_7974(this.stack.method_7919() - insertedDamage);
            this.context.exchange(ItemVariant.of((class_1799)this.stack), 1L, transaction);
        }
        return PowerUtils.absToAmount(insertedVariant.getFluid(), insertedEnergy);
    }

    public boolean isResourceBlank() {
        return true;
    }

    public FluidVariant getResource() {
        return FluidVariant.blank();
    }

    public long getAmount() {
        return 0L;
    }

    public long getCapacity() {
        return 0L;
    }

    protected int energyCapacity() {
        return this.stack.method_7936() * 500;
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        return Iterators.singletonIterator((Object)((Object)this));
    }

    protected Integer createSnapshot() {
        return (this.stack.method_7936() - this.stack.method_7919()) * 500;
    }

    protected void readSnapshot(Integer snapshot) {
        this.stack.method_7974(this.stack.method_7936() - snapshot / 500);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return 0L;
    }
}

