/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.death_blades;

import com.neep.neepmeat.block.entity.MotorisedMachineBlockEntity;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMDamageSources;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.init.NMParticles;
import com.neep.neepmeat.machine.death_blades.DeathBladesBlock;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.machine.synthesiser.MobSynthesisRegistry;
import com.neep.neepmeat.transport.block.fluid_transport.entity.FluidDrainBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_5575;

public class DeathBladesBlockEntity
extends MotorisedMachineBlockEntity {
    protected static final int MAX_COOLDOWN = 10;
    protected float angularSpeed;
    protected float angle;
    protected float clientAngle;
    protected float cooldown;

    public DeathBladesBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, 0.1f, 0.2f, 1.5f);
    }

    public DeathBladesBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.DEATH_BLADES, pos, state);
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        this.cooldown = Math.min(10.0f, this.cooldown + this.progressIncrement);
        this.angle = class_3532.method_15393((float)(this.angle + this.angularSpeed));
        if (this.cooldown >= 10.0f && this.angularSpeed > 0.0f) {
            this.cooldown = 0.0f;
            class_238 box = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            switch ((class_2350)this.method_11010().method_11654((class_2769)DeathBladesBlock.field_10927)) {
                case field_11036: 
                case field_11033: {
                    box = new class_238(this.field_11867.method_10069(-1, 0, -1), this.field_11867.method_10069(2, 1, 2));
                    break;
                }
                case field_11043: 
                case field_11035: {
                    box = new class_238(this.field_11867.method_10069(-1, -1, 0), this.field_11867.method_10069(2, 2, 1));
                    break;
                }
                case field_11034: 
                case field_11039: {
                    box = new class_238(this.field_11867.method_10069(0, -1, -1), this.field_11867.method_10069(1, 2, 2));
                }
            }
            this.field_11863.method_18023(class_5575.method_31795(class_1309.class), box, e -> true).stream().filter(e -> e.field_6235 == 0 && !e.method_29504()).forEach(e -> this.damageEntity((class_3218)this.field_11863, (class_1309)e));
        }
        return true;
    }

    private void damageEntity(class_3218 world, class_1309 entity) {
        int damageAmount = (int)Math.max(4.0f * this.power, 2.0f);
        if (entity.method_6032() > (float)damageAmount) {
            entity.method_5643(class_1282.field_5869, (float)damageAmount);
        } else {
            DeathBladesBlockEntity.killEntity(world, entity);
        }
    }

    public static void killEntity(class_3218 world, class_1309 entity) {
        class_2586 class_25862 = world.method_8321(entity.method_24515().method_10074());
        if (class_25862 instanceof FluidDrainBlockEntity) {
            FluidDrainBlockEntity be = (FluidDrainBlockEntity)class_25862;
            try (Transaction transaction = Transaction.openOuter();){
                class_1282 damageSource = NMDamageSources.MINCER;
                be.getBuffer(null).insert(FluidVariant.of((class_3611)NMFluids.STILL_TISSUE_SLURRY), DeathBladesBlockEntity.getEntityAmount(entity), (TransactionContext)transaction);
                world.method_14199((class_2394)NMParticles.MEAT_SPLASH, entity.method_23317(), entity.method_23318(), entity.method_23321(), 20, 0.4, 0.4, 0.4, 0.01);
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    player.method_5643(damageSource, Float.MAX_VALUE);
                } else {
                    entity.method_31472();
                }
                transaction.commit();
            }
        }
        entity.method_5768();
    }

    public static long getEntityAmount(class_1309 entity) {
        MobSynthesisRegistry.Entry entry = MobSynthesisRegistry.get((class_1297)entity);
        if (entry != null) {
            return entry.meat() / 2L;
        }
        return MobSynthesisRegistry.meatFromSize((class_1297)entity) / 2L;
    }

    @Override
    public void setInputPower(float power) {
        this.angularSpeed = power < this.minPower ? 0.0f : power * 20.0f;
        super.setInputPower(power);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("angularSpeed", this.angularSpeed);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.angularSpeed = nbt.method_10583("angularSpeed");
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, DeathBladesBlockEntity be) {
        be.clientAngle = be.angle;
        be.angle = class_3532.method_15393((float)(be.angle + be.angularSpeed));
    }
}

