/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.deployer;

import com.neep.meatlib.block.BaseFacingBlock;
import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.entity.player.FakePlayerEntity;
import com.neep.meatlib.inventory.ImplementedInventory;
import com.neep.meatlib.util.LazySupplier;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.machine.motor.MotorEntity;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5819;

public class DeployerBlockEntity
extends SyncableBlockEntity
implements MotorisedBlock,
MotorisedBlock.DiagnosticsProvider {
    protected final float minPower = 0.02f;
    private final ImplementedInventory inventory = ImplementedInventory.ofSize(9);
    private final InventoryStorage inventoryStorage = InventoryStorage.of((class_1263)this.inventory, null);
    public float shuttleOffset;
    public boolean powered;
    public boolean roundRobin = false;
    public boolean interactBlock = true;
    protected MotorEntity motor;
    protected LazySupplier<FakePlayerEntity> playerSupplier = LazySupplier.of(() -> {
        class_1937 patt2025$temp = this.field_11863;
        if (patt2025$temp instanceof class_3218) {
            class_3218 serverWorld = (class_3218)patt2025$temp;
            return FakePlayerEntity.get(serverWorld);
        }
        return null;
    });
    private int roundRobinIndex = 0;
    private float power = 0.0f;

    public DeployerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.powered = nbt.method_10577("powered");
        this.roundRobin = nbt.method_10577("round_robin");
        this.interactBlock = nbt.method_10577("interact_block");
        this.roundRobinIndex = nbt.method_10550("round_index");
        this.inventory.readNbt(nbt.method_10562("inventory"));
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10556("powered", this.powered);
        nbt.method_10556("round_robin", this.roundRobin);
        nbt.method_10556("interact_block", this.interactBlock);
        nbt.method_10569("round_index", this.roundRobinIndex);
        nbt.method_10566("inventory", (class_2520)this.inventory.writeNbt(new class_2487()));
    }

    private int currentStack() {
        int slot = this.roundRobin ? this.roundRobin() : this.chooseNonEmptySlot(this.field_11863.method_8409());
        return slot;
    }

    private int roundRobin() {
        this.roundRobinIndex %= 9;
        int slot = this.roundRobinIndex;
        int j = (this.roundRobinIndex + 1) % 9;
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            if (this.inventory.method_5438((j + i) % 9).method_7960()) continue;
            this.roundRobinIndex = (j + i) % 9;
            break;
        }
        return slot;
    }

    private int chooseNonEmptySlot(class_5819 random) {
        int i = 0;
        int j = 1;
        for (int k = 0; k < this.inventory.method_5439(); ++k) {
            if (this.inventory.method_5438(k).method_7960() || random.method_43048(j++) != 0) continue;
            i = k;
        }
        return i;
    }

    public void deploy(class_3218 world, int slot) {
        class_1799 stack = this.inventory.method_5441(slot);
        if (stack.method_7960() && !this.interactBlock) {
            return;
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)BaseFacingBlock.field_10927);
        class_3222 player = this.playerSupplier.get();
        player.method_32747(world);
        class_2382 unit = facing.method_10163();
        player.method_23327((double)this.field_11867.method_10263() + 0.5 + (double)unit.method_10263() * 0.5, (double)this.field_11867.method_10264() + 0.5 - (double)player.method_18381(player.method_18376()) + (double)unit.method_10264() * 0.5, (double)this.field_11867.method_10260() + 0.5 + (double)unit.method_10260() * 0.5);
        player.method_36457(this.pitch(facing));
        player.method_36456(this.yaw(facing));
        player.method_31548().method_5447(player.method_31548().field_7545, stack.method_7960() ? class_1799.field_8037 : stack);
        class_2338 targetPos = this.field_11867.method_10093(facing);
        class_243 hitPos = new class_243((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5);
        class_3965 hit = new class_3965(hitPos, facing.method_10153(), targetPos, true);
        if (this.interactBlock) {
            class_2680 state = world.method_8320(hit.method_17777());
            class_1269 actionResult = state.method_26174((class_1937)world, (class_1657)player, class_1268.field_5808, hit);
            if (!actionResult.method_23665()) {
                class_1269 class_12692 = stack.method_7981(new class_1838((class_1657)player, class_1268.field_5808, hit));
            }
        } else {
            player.field_13974.method_14256(player, (class_1937)world, stack, class_1268.field_5808);
        }
        class_1799 removed = player.method_31548().method_5441(player.method_31548().field_7545);
        this.inventory.method_5447(slot, removed);
        class_1661 playerInventory = player.method_31548();
        if (!playerInventory.method_5442()) {
            playerInventory.method_7388();
        }
    }

    private float pitch(class_2350 facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> 90.0f;
            case class_2350.field_11036 -> -90.0f;
            case class_2350.field_11043, class_2350.field_11039, class_2350.field_11034, class_2350.field_11035 -> 0.0f;
        };
    }

    private float yaw(class_2350 facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033, class_2350.field_11036, class_2350.field_11035 -> 0.0f;
            case class_2350.field_11043 -> 180.0f;
            case class_2350.field_11039 -> 90.0f;
            case class_2350.field_11034 -> -90.0f;
        };
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        if (!this.field_11863.method_8608() && this.field_11863.method_8510() % 10L == 0L && motor.getMechPUPower() >= (double)0.02f) {
            int slot = this.currentStack();
            this.deploy((class_3218)this.field_11863, slot);
            return true;
        }
        return false;
    }

    @Override
    public void setInputPower(float power) {
        this.power = power;
        if (!this.powered && power > 0.0f) {
            this.powered = true;
            this.sync();
        } else if (this.powered && power == 0.0f) {
            this.powered = false;
            this.sync();
        }
    }

    public void method_11012() {
        if (this.playerSupplier.isInitialised()) {
            this.playerSupplier.get().method_5650(class_1297.class_5529.field_26999);
        }
        super.method_11012();
    }

    @Override
    public MotorisedBlock.Diagnostics getDiagnostics() {
        return MotorisedBlock.Diagnostics.insufficientPower(this.power < 0.02f, this.power, 0.02f);
    }

    @Override
    public void method_5431() {
        super.method_5431();
        this.tryUpdateComparators();
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public Storage<ItemVariant> getStorage(class_2350 unused) {
        return this.inventoryStorage;
    }
}

