/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.fabricator;

import com.google.common.collect.Iterators;
import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.inventory.ImplementedInventory;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.machine.fabricator.FabricatorBlock;
import com.neep.neepmeat.machine.fabricator.FabricatorScreenHandler;
import com.neep.neepmeat.machine.fabricator.RecipeMatching;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.mixin.CraftingInventoryAccessor;
import com.neep.neepmeat.screen_handler.DummyScreenHandler;
import com.neep.neepmeat.transport.util.ItemPipeUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class FabricatorBlockEntity
extends SyncableBlockEntity
implements MotorisedBlock,
ExtendedScreenHandlerFactory {
    public static final class_2960 CHANNEL_ID = new class_2960("fabricator_animation");
    private final ObjectArrayList<BlockApiCache<Storage<ItemVariant>, class_2350>> caches = new ObjectArrayList(Collections.nCopies(6, null));
    private final FabricatorInventory inventory = new FabricatorInventory();
    private final FabricatorStorage storage = new FabricatorStorage();
    private float increment;
    private float progress;
    public boolean animation;

    public FabricatorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    private boolean findMatching(int batchSize, Storage<ItemVariant> input, List<class_1856> ingredients, List<ItemVariant> takenResources, TransactionContext transaction) throws RecipeMatching.FabricatorLoopException {
        for (StorageView view : input) {
            if (ingredients.isEmpty()) {
                return true;
            }
            if (view.isResourceBlank() || view.getAmount() <= 0L) continue;
            ItemVariant resource = (ItemVariant)view.getResource();
            Iterator<class_1856> it = ingredients.iterator();
            while (it.hasNext()) {
                class_1856 ingredient = it.next();
                if (ingredient.method_8103()) {
                    it.remove();
                    continue;
                }
                if (!ingredient.method_8093(((ItemVariant)view.getResource()).toStack())) continue;
                if (view instanceof FabricatorStorage) {
                    FabricatorStorage fabricatorStorage = (FabricatorStorage)view;
                    throw new RecipeMatching.FabricatorLoopException();
                }
                long extracted = view.extract((Object)resource, (long)batchSize, transaction);
                if (extracted != (long)batchSize) continue;
                takenResources.add((ItemVariant)view.getResource());
                it.remove();
            }
        }
        return ingredients.isEmpty();
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        this.progress = Math.min(5.0f, this.progress + this.increment);
        if (this.progress >= 5.0f) {
            this.progress = 0.0f;
            try {
                this.motorCraft();
            }
            catch (RecipeMatching.FabricatorLoopException fabricatorLoopException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public void setInputPower(float power) {
        this.increment = power;
    }

    private void motorCraft() throws RecipeMatching.FabricatorLoopException {
        class_3955 recipe = this.getCurrentRecipe();
        if (recipe != null) {
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)FabricatorBlock.FACING);
            CombinedStorage<ItemVariant, Storage<ItemVariant>> input = this.getInput(facing);
            ArrayList<class_1856> ingredients = new ArrayList<class_1856>((Collection<class_1856>)recipe.method_8117());
            ArrayList<ItemVariant> takenResources = new ArrayList<ItemVariant>();
            try (Transaction transaction = Transaction.openOuter();){
                boolean foundAll = this.findMatching(1, (Storage<ItemVariant>)input, (List<class_1856>)ingredients, (List<ItemVariant>)takenResources, (TransactionContext)transaction);
                if (!foundAll) {
                    transaction.abort();
                    return;
                }
                class_1799 result = recipe.method_8110();
                long ejected = ItemPipeUtil.EjectOperation.of(this.field_11863, this.field_11867, facing).useRouting(true).stackToAny(ItemVariant.of((class_1799)result), result.method_7947(), (TransactionContext)transaction).amount();
                if (ejected != (long)result.method_7947()) {
                    transaction.abort();
                    return;
                }
                for (ItemVariant taken : takenResources) {
                    long ejected1;
                    class_1799 remainder = taken.getItem().getRecipeRemainder(taken.toStack());
                    if (remainder.method_7960() || (ejected1 = ItemPipeUtil.EjectOperation.of(this.field_11863, this.field_11867, facing).stackToAny(ItemVariant.of((class_1799)remainder), remainder.method_7947(), (TransactionContext)transaction).amount()) == (long)remainder.method_7947()) continue;
                    transaction.abort();
                    return;
                }
                this.sendAnimation();
                transaction.commit();
            }
        }
    }

    private class_1799 craft(int batchSize, TransactionContext transaction) throws RecipeMatching.FabricatorLoopException {
        class_3955 recipe = this.getCurrentRecipe();
        if (recipe != null) {
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)FabricatorBlock.FACING);
            CombinedStorage<ItemVariant, Storage<ItemVariant>> input = this.getInput(facing);
            ArrayList<class_1856> ingredients = new ArrayList<class_1856>((Collection<class_1856>)recipe.method_8117());
            ArrayList<ItemVariant> takenResources = new ArrayList<ItemVariant>();
            try (Transaction inner = transaction.openNested();){
                boolean foundAll = this.findMatching(batchSize, (Storage<ItemVariant>)input, (List<class_1856>)ingredients, (List<ItemVariant>)takenResources, (TransactionContext)inner);
                if (!foundAll) {
                    inner.abort();
                    class_1799 class_17992 = class_1799.field_8037;
                    return class_17992;
                }
                class_1799 result = recipe.method_8110().method_7972();
                result.method_7939(batchSize * result.method_7947());
                for (ItemVariant taken : takenResources) {
                    long ejected1;
                    class_1799 remainder = taken.getItem().getRecipeRemainder(taken.toStack());
                    if (remainder.method_7960() || (ejected1 = ItemPipeUtil.EjectOperation.of(this.field_11863, this.field_11867, facing).stackToAny(ItemVariant.of((class_1799)remainder), remainder.method_7947(), (TransactionContext)inner).amount()) == (long)remainder.method_7947()) continue;
                    inner.abort();
                    class_1799 class_17993 = class_1799.field_8037;
                    return class_17993;
                }
                transaction.addCloseCallback((t, r) -> {
                    if (r.wasCommitted()) {
                        this.sendAnimation();
                    }
                });
                inner.commit();
                class_1799 class_17994 = result;
                return class_17994;
            }
        }
        return class_1799.field_8037;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.inventory.writeNbt(nbt);
        this.storage.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory.readNbt(nbt);
        this.storage.readNbt(nbt);
    }

    private CombinedStorage<ItemVariant, Storage<ItemVariant>> getInput(class_2350 facing) {
        ArrayList<Storage<ItemVariant>> storages = new ArrayList<Storage<ItemVariant>>();
        for (class_2350 direction : class_2350.values()) {
            Storage<ItemVariant> storage;
            if (direction != facing.method_10153() && direction != facing.method_10170() && direction != facing.method_10160() || (storage = this.findStorage(direction)) == null) continue;
            storages.add(storage);
        }
        return new CombinedStorage(storages);
    }

    @Nullable
    private Storage<ItemVariant> findStorage(class_2350 face) {
        if (this.caches.get(face.ordinal()) == null) {
            this.caches.set(face.ordinal(), (Object)BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)this.field_11863), (class_2338)this.field_11867.method_10093(face)));
        }
        return (Storage)((BlockApiCache)this.caches.get(face.ordinal())).find((Object)face.method_10153());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new FabricatorScreenHandler(playerInventory, this.inventory, syncId, this);
    }

    public class_2561 method_5476() {
        return class_2561.method_30163((String)"Enter Pattern");
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.method_11016());
    }

    @Nullable
    public class_3955 getCurrentRecipe() {
        return this.storage.getRecipe();
    }

    public Storage<ItemVariant> getStorage(class_2350 direction) {
        return direction == null || direction == this.method_11010().method_11654((class_2769)FabricatorBlock.FACING) ? this.storage : null;
    }

    public void sendAnimation() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            PlayerLookup.tracking((class_2586)this).forEach(p -> {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10807(this.method_11016());
                ServerPlayNetworking.send((class_3222)p, (class_2960)CHANNEL_ID, (class_2540)buf);
            });
        }
    }

    @Override
    public void method_31664(class_2680 state) {
        super.method_31664(state);
    }

    public class FabricatorInventory
    extends class_1715
    implements ImplementedInventory {
        public FabricatorInventory() {
            super((class_1703)new DummyScreenHandler(i -> FabricatorBlockEntity.this.method_5431()), 3, 3);
        }

        @Override
        public class_2371<class_1799> getItems() {
            return ((CraftingInventoryAccessor)((Object)this)).getStacks();
        }

        @Override
        public void method_5431() {
            FabricatorBlockEntity.this.storage.invalidateRecipe();
            FabricatorBlockEntity.this.method_5431();
        }

        public int method_17398() {
            return 3;
        }

        public int method_17397() {
            return 3;
        }

        public void method_7683(class_1662 finder) {
            for (class_1799 itemStack : this.getItems()) {
                finder.method_7404(itemStack);
            }
        }
    }

    public class FabricatorStorage
    extends SnapshotParticipant<class_1799>
    implements Storage<ItemVariant>,
    StorageView<ItemVariant>,
    NbtSerialisable {
        private boolean needsLoading = true;
        @Nullable
        private class_3955 recipe;
        private class_1799 bufferedStack = class_1799.field_8037;
        private class_1799 previewStack = class_1799.field_8037;

        public FabricatorBlockEntity getParent() {
            return FabricatorBlockEntity.this;
        }

        private void updateRecipe() {
            this.recipe = FabricatorBlockEntity.this.field_11863.method_8433().method_8132(class_3956.field_17545, (class_1263)FabricatorBlockEntity.this.inventory, FabricatorBlockEntity.this.field_11863).orElse(null);
            if (this.recipe != null) {
                this.previewStack = this.recipe.method_8110().method_7972();
            }
        }

        @Nullable
        public class_3955 getRecipe() {
            this.load();
            return this.recipe;
        }

        public boolean supportsInsertion() {
            return false;
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (!this.bufferedStack.method_7960() && resource.matches(this.bufferedStack) || resource.matches(this.previewStack)) {
                int amountToExtract;
                long requiredExtra = maxAmount - (long)this.bufferedStack.method_7947();
                if (requiredExtra > 0L) {
                    this.updateSnapshots(transaction);
                    int remainingCapacity = this.previewStack.method_7914() - this.bufferedStack.method_7947();
                    int maxBatchSize = Math.min(remainingCapacity / this.previewStack.method_7947(), 64);
                    int desiredBatchSize = (int)Math.ceil((double)requiredExtra / (double)this.previewStack.method_7947());
                    int batchSize = Math.min(maxBatchSize, desiredBatchSize);
                    try {
                        this.bufferedStack = FabricatorBlockEntity.this.craft(batchSize, transaction);
                        if (batchSize > 1 && this.bufferedStack.method_7960()) {
                            this.bufferedStack = FabricatorBlockEntity.this.craft(1, transaction);
                        }
                    }
                    catch (RecipeMatching.FabricatorLoopException ignored) {
                        return 0L;
                    }
                    int extractable = (int)Math.min((long)this.bufferedStack.method_7947(), maxAmount);
                    if (extractable > 0) {
                        this.bufferedStack.method_7934(extractable);
                        return extractable;
                    }
                } else if (!this.bufferedStack.method_7960() && (amountToExtract = (int)Math.min((long)this.bufferedStack.method_7947(), maxAmount)) > 0) {
                    this.updateSnapshots(transaction);
                    this.bufferedStack.method_7934(amountToExtract);
                    return amountToExtract;
                }
            }
            return 0L;
        }

        public boolean isResourceBlank() {
            this.load();
            return this.bufferedStack.method_7960() && this.previewStack.method_7960();
        }

        public ItemVariant getResource() {
            this.load();
            if (!this.bufferedStack.method_7960()) {
                return ItemVariant.of((class_1799)this.bufferedStack);
            }
            return ItemVariant.of((class_1799)this.previewStack);
        }

        public long getAmount() {
            this.load();
            if (!this.bufferedStack.method_7960()) {
                return this.bufferedStack.method_7947();
            }
            return this.previewStack.method_7947();
        }

        public long getCapacity() {
            this.load();
            if (!this.bufferedStack.method_7960()) {
                return this.bufferedStack.method_7947();
            }
            return this.previewStack.method_7947();
        }

        public Iterator<StorageView<ItemVariant>> iterator() {
            this.load();
            return Iterators.singletonIterator((Object)this);
        }

        private void load() {
            if (this.needsLoading) {
                this.needsLoading = false;
                this.updateRecipe();
            }
        }

        @Override
        public class_2487 writeNbt(class_2487 nbt) {
            if (this.recipe != null) {
                nbt.method_10582("recipe", this.recipe.method_8114().toString());
            }
            nbt.method_10566("buffered", (class_2520)this.bufferedStack.method_7953(new class_2487()));
            return nbt;
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.recipe = nbt.method_10545("recipe") ? (class_3955)MeatlibRecipes.getInstance().getVanilla(class_3956.field_17545, class_2960.method_12829((String)nbt.method_10558("recipe"))).orElse(null) : null;
            this.bufferedStack = class_1799.method_7915((class_2487)nbt.method_10562("buffered"));
        }

        protected class_1799 createSnapshot() {
            return this.bufferedStack.method_7972();
        }

        protected void readSnapshot(class_1799 snapshot) {
            this.bufferedStack = snapshot.method_7972();
        }

        protected void onFinalCommit() {
            FabricatorBlockEntity.this.method_5431();
        }

        public void invalidateRecipe() {
            this.needsLoading = true;
        }
    }
}

