/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.grinder;

import com.neep.meatlib.util.NbtSerialisable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2487;

public interface CrusherRecipeContext {
    public Storage<ItemVariant> getInputStorage();

    public Storage<ItemVariant> getOutputStorage();

    public Storage<ItemVariant> getExtraStorage();

    public XpStorage getXpStorage();

    public float getChanceMod();

    public static class XpStorage
    extends SnapshotParticipant<Float>
    implements NbtSerialisable {
        private float xp;

        public float insert(float maxAmount, TransactionContext transaction) {
            if (maxAmount > 0.0f) {
                this.updateSnapshots(transaction);
                this.xp += maxAmount;
                return maxAmount;
            }
            return 0.0f;
        }

        public float extract(float maxAmount, TransactionContext transaction) {
            if (maxAmount > 0.0f) {
                this.updateSnapshots(transaction);
                float extracted = Math.min(this.xp, maxAmount);
                this.xp -= extracted;
                return extracted;
            }
            return 0.0f;
        }

        public float getAmount() {
            return this.xp;
        }

        @Override
        public class_2487 writeNbt(class_2487 nbt) {
            nbt.method_10548("amount", this.xp);
            return nbt;
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.xp = nbt.method_10583("amount");
        }

        protected Float createSnapshot() {
            return Float.valueOf(this.xp);
        }

        protected void readSnapshot(Float snapshot) {
            this.xp = snapshot.floatValue();
        }
    }
}

