/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.integrator;

import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.machine.integrator.IntegratorBlockEntity;
import java.util.Collections;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public class IntegratorStorage {
    protected IntegratorBlockEntity parent;
    protected ImmatureStorage immatureStorage = new ImmatureStorage();
    public static final String NBT_IMMATURE_STORAGE = "variant";
    public Storage<ItemVariant> itemStorage = new ItemStorage();

    public IntegratorStorage(IntegratorBlockEntity parent) {
        this.parent = parent;
    }

    public Storage<FluidVariant> getFluidStorage(class_1937 world, class_2338 pos, class_2680 state, class_2350 direction) {
        if (!this.parent.isMature) {
            return this.immatureStorage;
        }
        return null;
    }

    public void writeNbt(class_2487 nbt) {
        class_2487 immature = new class_2487();
        this.immatureStorage.writeNbt(immature);
        nbt.method_10566(NBT_IMMATURE_STORAGE, (class_2520)immature);
    }

    public void readNbt(class_2487 nbt) {
        class_2487 immature = nbt.method_10562(NBT_IMMATURE_STORAGE);
        this.immatureStorage.readNbt(immature);
    }

    protected static class ImmatureStorage
    extends SingleVariantStorage<FluidVariant>
    implements InsertionOnlyStorage<FluidVariant>,
    SingleSlotStorage<FluidVariant> {
        protected long capacity = 81000L;

        protected ImmatureStorage() {
        }

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return this.capacity;
        }

        public void writeNbt(class_2487 nbt) {
            nbt.method_10544("amount", this.amount);
            nbt.method_10566("resource", (class_2520)((FluidVariant)this.variant).toNbt());
        }

        public void readNbt(class_2487 nbt) {
            this.amount = nbt.method_10537("amount");
            this.variant = FluidVariant.fromNbt((class_2487)((class_2487)nbt.method_10580("resource")));
        }

        public boolean supportsExtraction() {
            return super.supportsExtraction();
        }

        @NotNull
        public Iterator<StorageView<FluidVariant>> iterator() {
            return super.iterator();
        }

        protected boolean canInsert(FluidVariant variant) {
            return variant.getFluid().method_15791(NMTags.BLOOD);
        }

        protected void onFinalCommit() {
        }
    }

    protected class ItemStorage
    implements Storage<ItemVariant> {
        protected ItemStorage() {
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            float inserted;
            Integer inc = IntegratorBlockEntity.DATA_MAP.get(resource.getItem());
            if (inc != null && (inserted = IntegratorStorage.this.parent.insertEnlightenment(inc.intValue(), transaction)) == (float)inc.intValue()) {
                transaction.addOuterCloseCallback(result -> IntegratorStorage.this.parent.method_10997().method_8396(null, IntegratorStorage.this.parent.method_11016(), class_3417.field_15099, class_3419.field_15245, 1.0f, 1.0f));
                return 1L;
            }
            return 0L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public Iterator<StorageView<ItemVariant>> iterator() {
            return Collections.emptyIterator();
        }
    }
}

