/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.large_crusher;

import com.neep.meatlib.inventory.ImplementedInventory;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.grinder.CrusherRecipeContext;
import com.neep.neepmeat.machine.large_crusher.LargeCrusherBlockEntity;
import com.neep.neepmeat.recipe.CrushingRecipe;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class LargeCrusherStorage
implements NbtSerialisable {
    protected final List<InputSlot> slots;
    protected final CombinedStorage<ItemVariant, InputSlot> inputStorage;
    final ImplementedInventory outputInventory = ImplementedInventory.ofSize(8);
    final InventoryStorage outputStorage = InventoryStorage.of((class_1263)this.outputInventory, null);
    private final CrusherRecipeContext.XpStorage xpStorage = new CrusherRecipeContext.XpStorage();

    public LargeCrusherStorage(LargeCrusherBlockEntity parent) {
        this.slots = List.of(new InputSlot(parent::sync), new InputSlot(parent::sync), new InputSlot(parent::sync), new InputSlot(parent::sync));
        this.inputStorage = new CombinedStorage(this.slots);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (InputSlot slot : this.slots) {
            list.add((Object)slot.toNbt(new class_2487()));
        }
        nbt.method_10566("input", (class_2520)list);
        nbt.method_10566("output", (class_2520)this.outputInventory.writeNbt(new class_2487()));
        nbt.method_10566("xp", (class_2520)this.xpStorage.writeNbt(new class_2487()));
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        class_2499 list = nbt.method_10554("input", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.slots.get(i).readNbt(list.method_10602(i));
        }
        this.outputInventory.readNbt(nbt.method_10562("output"));
        this.xpStorage.readNbt(nbt.method_10562("xp"));
    }

    protected class InputSlot
    extends WritableStackStorage
    implements CrusherRecipeContext {
        @Nullable
        private CrushingRecipe recipe;
        private float progress;

        public InputSlot(Runnable parent) {
            super(parent);
        }

        public void tick(float progressIncrement, TransactionContext transaction) {
            if (this.recipe != null) {
                this.progress += progressIncrement;
                if (this.progress >= (float)this.recipe.getTime()) {
                    if (this.recipe.ejectOutputs(this, transaction)) {
                        this.recipe.takeInputs(this, transaction);
                    }
                    this.recipe = null;
                    this.progress = 0.0f;
                    this.syncIfPossible();
                }
            } else if (!this.isEmpty()) {
                CrushingRecipe foundRecipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.ADVANCED_CRUSHING, this).orElse(null);
                if (foundRecipe == null) {
                    foundRecipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.GRINDING, this).orElse(null);
                }
                if (foundRecipe != null) {
                    this.recipe = foundRecipe;
                } else if (!this.isEmpty()) {
                    this.recipe = MeatlibRecipes.getInstance().get(NMrecipeTypes.ADVANCED_CRUSHING, new class_2960("neepmeat", "advanced_crushing/destroy")).orElse(null);
                }
                this.syncIfPossible();
            }
        }

        @Override
        public void writeNbt(class_2487 nbt) {
            if (this.recipe != null) {
                nbt.method_10582("recipe", this.recipe.method_8114().toString());
            }
            super.writeNbt(nbt);
        }

        @Override
        public void readNbt(class_2487 nbt) {
            super.readNbt(nbt);
            this.recipe = nbt.method_10545("recipe") ? (CrushingRecipe)MeatlibRecipes.getInstance().get(NMrecipeTypes.GRINDING, class_2960.method_12829((String)nbt.method_10558("recipe"))).orElse(null) : null;
        }

        @Override
        public Storage<ItemVariant> getInputStorage() {
            return this;
        }

        @Override
        public Storage<ItemVariant> getOutputStorage() {
            return LargeCrusherStorage.this.outputStorage;
        }

        @Override
        public Storage<ItemVariant> getExtraStorage() {
            return LargeCrusherStorage.this.outputStorage;
        }

        @Override
        public CrusherRecipeContext.XpStorage getXpStorage() {
            return LargeCrusherStorage.this.xpStorage;
        }

        @Override
        public float getChanceMod() {
            return 0.0f;
        }

        @Nullable
        public CrushingRecipe getRecipe() {
            return this.recipe;
        }
    }
}

