/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.large_motor;

import com.google.common.collect.ImmutableMap;
import com.neep.meatlib.block.MeatlibBlock;
import com.neep.meatlib.block.MeatlibBlockSettings;
import com.neep.meatlib.item.BaseBlockItem;
import com.neep.meatlib.item.ItemSettings;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.neepmeat.api.big_block.BigBlock;
import com.neep.neepmeat.api.big_block.BigBlockPattern;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.machine.large_motor.LargeMotorStructureBlock;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.util.MiscUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class LargeMotorBlock
extends BigBlock<LargeMotorStructureBlock>
implements MeatlibBlock,
class_2343 {
    private final BigBlockPattern volume;
    public final class_265 normalShape;
    private final Map<class_2350, class_265> shapeMap = ImmutableMap.of((Object)class_2350.field_11043, (Object)LargeMotorBlock.cuboid(-0.5, 0.0, -1.0, 2.0, 2.5, 2.0), (Object)class_2350.field_11034, (Object)LargeMotorBlock.cuboid(0.0, 0.0, -0.5, 2.0, 2.5, 2.0), (Object)class_2350.field_11035, (Object)LargeMotorBlock.cuboid(-0.5, 0.0, 0.0, 2.0, 2.5, 2.0), (Object)class_2350.field_11039, (Object)LargeMotorBlock.cuboid(-1.0, 0.0, -0.5, 2.0, 2.5, 2.0));
    public static final class_2753 FACING = class_2741.field_12481;

    private static class_265 cuboid(double minX, double minY, double minZ, double sizeX, double sizeY, double sizeZ) {
        return class_259.method_1081((double)minX, (double)minY, (double)minZ, (double)(minX + sizeX), (double)(minY + sizeY), (double)(minZ + sizeZ));
    }

    public LargeMotorBlock(RegistrationContext ctx, ItemSettings itemSettings, class_4970.class_2251 settings) {
        super(ctx, settings);
        ctx.append(this, new BaseBlockItem(this, ctx, itemSettings));
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
        this.volume = BigBlockPattern.makeRange(-1, 0, 0, 1, 2, -1, ((LargeMotorStructureBlock)this.getStructure()).method_9564());
        this.normalShape = this.volume.toVoxelShape();
    }

    @Override
    protected LargeMotorStructureBlock registerStructureBlock(RegistrationContext ctx) {
        return ctx.append((Object)this, new LargeMotorStructureBlock(this, (class_4970.class_2251)MeatlibBlockSettings.copyOf((class_4970)this)), "large_motor_structure");
    }

    @Override
    public BigBlockPattern getVolume(class_2680 blockState) {
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)FACING);
        return this.volume.rotateY(facing.method_10144() - 180.0f);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapeMap.get(state.method_11654((class_2769)FACING));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042());
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            world.method_35230(pos, NMBlockEntities.LARGE_MOTOR).ifPresent(MotorEntity::onRemoved);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    public static class_265 rotateShape(class_265 shape, class_2350 direction) {
        AtomicReference<class_265> newShape = new AtomicReference<class_265>(class_259.method_1073());
        shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> newShape.set(class_259.method_1084((class_265)((class_265)newShape.get()), (class_265)LargeMotorBlock.rotatedCuboid(direction, minX, minY, minZ, maxX, maxY, maxZ))));
        return newShape.get().method_1097();
    }

    public static class_265 rotatedCuboid(class_2350 direction, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        return switch (direction) {
            case class_2350.field_11043 -> class_259.method_1081((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
            case class_2350.field_11035 -> class_259.method_1081((double)xMax, (double)yMin, (double)(1.0 - zMin), (double)xMin, (double)yMax, (double)(1.0 - zMax));
            case class_2350.field_11039 -> class_259.method_1081((double)zMin, (double)yMin, (double)xMin, (double)zMax, (double)yMax, (double)xMax);
            case class_2350.field_11034 -> class_259.method_1081((double)(1.0 - zMin), (double)yMin, (double)xMin, (double)(1.0 - zMax), (double)yMax, (double)xMax);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(direction));
        };
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return MiscUtil.checkType(type, NMBlockEntities.LARGE_MOTOR, (world1, pos, state1, blockEntity) -> blockEntity.serverTick(), null, world);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return NMBlockEntities.LARGE_MOTOR.method_11032(pos, state);
    }
}

