/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.process;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.block.TreeVacuumBlock;
import com.neep.neepmeat.machine.live_machine.block.entity.TreeVacuumBlockEntity;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;

public class TreeVacuumProcess
implements Process {
    private static final List<ComponentType<?>> REQUIRED = List.of(LivingMachineComponents.TREE_VACUUM, LivingMachineComponents.ITEM_OUTPUT, LivingMachineComponents.MOTOR_PORT);

    @Override
    public void serverTick(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.TREE_VACUUM, LivingMachineComponents.ITEM_OUTPUT, LivingMachineComponents.MOTOR_PORT).ifPresent(result -> {
            Collection vacuums = result.t1();
            Collection outputs = result.t2();
            Collection motors = result.t3();
            TreeVacuumBlockEntity vacuum = (TreeVacuumBlockEntity)vacuums.iterator().next();
            class_1937 world = be.method_10997();
            float f = vacuum.progress + be.getProgressIncrement();
            Objects.requireNonNull(vacuum);
            float f2 = vacuum.progress = Math.min(f, 5.0f);
            Objects.requireNonNull(vacuum);
            if (f2 >= 5.0f) {
                class_2350 facing = (class_2350)vacuum.method_11010().method_11654((class_2769)TreeVacuumBlock.FACING);
                class_2338 trunkPos = vacuum.method_11016().method_10079(facing, 2);
                try (Transaction transaction = Transaction.openOuter();){
                    vacuum.progress = 0.0f;
                    boolean broken = this.traverseTree(world, trunkPos, 300, 7, be.getCombinedItemOutput(), (TransactionContext)transaction);
                    vacuum.syncAnimation(broken);
                    transaction.commit();
                }
            }
        });
    }

    private boolean traverseTree(class_1937 world, class_2338 origin, int maxVisit, int maxBreak, Storage<ItemVariant> output, TransactionContext transaction) {
        class_2350[] directions = new class_2350[]{class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039, class_2350.field_11033};
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        if (!TreeVacuumProcess.isTree(world.method_8320(origin))) {
            return false;
        }
        visited.add(origin);
        queue.add(origin);
        int treeBlocksVisited = 0;
        int treeBlocksBroken = 0;
        while (!queue.isEmpty() && treeBlocksVisited < maxVisit && treeBlocksBroken < maxBreak) {
            class_2338 current = (class_2338)queue.poll();
            class_2338.class_2339 mutable = current.method_25503();
            boolean foundOther = false;
            for (class_2350 direction : directions) {
                mutable.method_25505((class_2382)current, direction);
                if (visited.contains(mutable)) continue;
                visited.add(mutable.method_10062());
                class_2680 offsetState = world.method_8320((class_2338)mutable);
                if (!TreeVacuumProcess.isTree(offsetState)) continue;
                foundOther = true;
                ++treeBlocksVisited;
                queue.add(mutable.method_10062());
            }
            if (foundOther) continue;
            List dropped = class_2248.method_9562((class_2680)world.method_8320(current), (class_3218)((class_3218)world), (class_2338)current, (class_2586)world.method_8321(current));
            for (class_1799 stack : dropped) {
                output.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), transaction);
            }
            world.method_22352(current, false);
            ++treeBlocksBroken;
        }
        return treeBlocksBroken > 0;
    }

    private static boolean isTree(class_2680 state) {
        class_2248 block = state.method_26204();
        return !(block instanceof TreeVacuumBlock) && !(block instanceof TreeVacuumBlock.Structure) && (block instanceof class_2397 || state.method_26164(class_3481.field_15475) || state.method_26164(class_3481.field_15503));
    }

    @Override
    public List<ComponentType<?>> getRequired() {
        return REQUIRED;
    }

    @Override
    public class_2561 getName() {
        return NeepMeat.translationKey("process", "tree_vacuum");
    }
}

