/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.phage_ray;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.neep.meatlib.graphics.GraphicsEffects;
import com.neep.meatlib.network.PacketBufUtil;
import com.neep.meatlib.util.ClientComponents;
import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.init.NMBlocks;
import com.neep.neepmeat.init.NMGraphicsEffects;
import com.neep.neepmeat.machine.phage_ray.PhageRayBlockEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class PhageRayEntity
extends class_1297 {
    public static final class_2960 CHANNEL_ID = new class_2960("neepmeat", "phage_ray");
    protected static final class_2940<Boolean> RUNNING = class_2945.method_12791(PhageRayEntity.class, (class_2941)class_2943.field_13323);
    @Nullable
    private PhageRayBlockEntity parent;
    boolean trigger = false;
    int triggerTicks = 0;
    private double range = 30.0;
    private final ClientComponents.Holder<PhageRayEntity> holder = new ClientComponents.EntityHolder<PhageRayEntity>(this);
    private final HashMap<class_2338, Float> targets = Maps.newHashMap();

    public PhageRayEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.field_23807 = true;
    }

    private void syncBeamEffect(class_3222 player, class_1937 world, class_243 start, class_243 end, class_243 velocity, float scale, int maxTime) {
        if (this.method_37908().field_9236) {
            throw new IllegalStateException("packet create called on the client!");
        }
        class_2540 byteBuf = GraphicsEffects.createPacket(NMGraphicsEffects.PHAGE_RAY, world);
        PacketBufUtil.writeVec3d(byteBuf, start);
        PacketBufUtil.writeVec3d(byteBuf, end);
        PacketBufUtil.writeVec3d(byteBuf, velocity);
        byteBuf.writeFloat(scale);
        byteBuf.writeInt(maxTime);
        byteBuf.method_10804(this.method_5628());
        ServerPlayNetworking.send((class_3222)player, (class_2960)GraphicsEffects.CHANNEL_ID, (class_2540)byteBuf);
    }

    protected void method_5693() {
        this.field_6011.method_12784(RUNNING, (Object)false);
    }

    public boolean method_5698(class_1297 attacker) {
        return super.method_5698(attacker);
    }

    protected void method_5749(class_2487 nbt) {
    }

    protected void method_5652(class_2487 nbt) {
    }

    @Nullable
    public class_1297 method_5642() {
        return this.method_31483();
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608() && this.field_6012 > 5 && (this.parent == null || this.parent.method_11015())) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (this.method_5787() && this.method_31483() != null) {
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
            this.method_36456(this.method_31483().method_36454());
            this.method_36457(this.limitPitch(this.method_31483().method_36455()));
            this.method_5710(this.method_36454(), this.method_36455());
        }
        if (this.method_37908().method_8608()) {
            this.clientTick();
        }
        if (this.isRunning() && this.trigger) {
            ++this.triggerTicks;
            if (!this.method_5817()) {
                this.trigger = false;
            }
        } else {
            this.triggerTicks = 0;
        }
    }

    public void tickProcess(boolean canHarvest, Storage<ItemVariant> combinedItemOutput, TransactionContext transaction) {
        boolean canRun;
        boolean bl = canRun = this.parent != null && this.parent.canRun();
        if ((Boolean)this.field_6011.method_12789(RUNNING) != canRun) {
            this.field_6011.method_12778(RUNNING, (Object)canRun);
        }
        if (this.isRunning() && this.trigger && this.triggerTicks >= 20 && !this.method_37908().method_8608()) {
            this.spawnBeams();
            this.breakBlocks(canHarvest, combinedItemOutput, transaction);
        }
    }

    private void spawnBeams() {
        int beamInterval = 10;
        if (this.triggerTicks % beamInterval == 0) {
            for (class_3222 player : PlayerLookup.tracking((class_1297)this)) {
                this.syncBeamEffect(player, this.method_37908(), this.getBeamOrigin(), this.getBeamEnd(), class_243.field_1353, 1.2f, beamInterval);
            }
        }
    }

    public boolean trigger() {
        return this.trigger;
    }

    private Set<class_2338> getTargets(class_243 origin, class_243 end) {
        class_243 v = new class_243(0.0, 0.5, 0.0);
        class_243 u = this.method_5720().method_1036(v).method_1029().method_1021(0.5);
        List<class_243> starts = List.of(origin.method_1020(u).method_1020(v), origin.method_1020(u).method_1019(v), origin.method_1019(u).method_1019(v), origin.method_1019(u).method_1020(v));
        List<class_243> ends = List.of(end.method_1020(u).method_1020(v), end.method_1020(u).method_1019(v), end.method_1019(u).method_1019(v), end.method_1019(u).method_1020(v));
        HashSet newTargets = Sets.newHashSet();
        for (int i = 0; i < 4; ++i) {
            class_3959 context = new class_3959(starts.get(i), ends.get(i), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this);
            class_3965 result = this.method_37908().method_17742(context);
            if (result.method_17783() != class_239.class_240.field_1332) continue;
            newTargets.add(result.method_17777());
            this.targets.putIfAbsent(result.method_17777(), Float.valueOf(0.0f));
        }
        return newTargets;
    }

    private void breakBlocks(boolean canHarvest, Storage<ItemVariant> output, TransactionContext transaction) {
        class_1937 world = this.method_37908();
        if (this.method_5782() && this.method_31483() != null) {
            if (this.method_37908().method_8510() % 2L == 0L) {
                Set<class_2338> newTargets = this.getTargets(this.getBeamOrigin(), this.getBeamEnd());
                this.targets.entrySet().removeIf(e -> !newTargets.contains(e.getKey()));
            }
            Iterator<Map.Entry<class_2338, Float>> it = this.targets.entrySet().iterator();
            while (it.hasNext()) {
                class_2680 state;
                Map.Entry<class_2338, Float> target = it.next();
                class_2338 pos = target.getKey();
                if (target.getValue().floatValue() >= 1.0f && !this.method_37908().method_8320(target.getKey()).method_27852(NMBlocks.PHAGE_RAY.getStructure())) {
                    if (canHarvest) {
                        state = world.method_8320(target.getKey());
                        List dropped = class_2248.method_9562((class_2680)state, (class_3218)((class_3218)world), (class_2338)pos, (class_2586)world.method_8321(pos));
                        for (class_1799 stack : dropped) {
                            output.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), transaction);
                        }
                    }
                    world.method_22352(target.getKey(), false);
                    it.remove();
                    continue;
                }
                state = this.method_37908().method_8320(target.getKey());
                target.setValue(Float.valueOf(target.getValue().floatValue() + PhageRayEntity.calcBlockBreakingDelta(state, (class_1922)this.method_37908(), target.getKey(), true, 20.0f)));
            }
        }
    }

    public static float calcBlockBreakingDelta(class_2680 state, class_1922 world, class_2338 pos, boolean allowOverride, float speed) {
        if (allowOverride && state.method_26164(NMTags.PHAGE_RAY_OVERRIDE)) {
            return 0.1f;
        }
        float f = state.method_26214(world, pos);
        if (f == -1.0f) {
            return 0.0f;
        }
        return speed / f / 30.0f;
    }

    void setPlayerTrigger(boolean trigger) {
        this.trigger = trigger;
    }

    public class_243 getBeamOrigin() {
        return this.method_19538().method_1031(0.0, 1.5, 0.0);
    }

    public class_243 getBeamEnd() {
        return this.getBeamOrigin().method_1019(this.method_5720().method_1021(this.range));
    }

    public class_243 getClientBeamEnd(float tickDelta) {
        return this.getBeamOrigin().method_1019(this.method_5828(tickDelta).method_1021(this.range));
    }

    private float limitPitch(float pitch) {
        return class_3532.method_15363((float)pitch, (float)-90.0f, (float)30.0f);
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    protected void method_5627(class_1297 passenger) {
        super.method_5627(passenger);
    }

    public class_243 method_24829(class_1309 passenger) {
        return this.method_19538().method_1031(0.0, (double)this.method_17682(), 0.0);
    }

    public boolean method_5822() {
        return false;
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        super.method_5784(movementType, movement);
    }

    public boolean method_30949(class_1297 other) {
        return super.method_30949(other);
    }

    public boolean method_30948() {
        return true;
    }

    public boolean isRunning() {
        return (Boolean)this.field_6011.method_12789(RUNNING);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!this.method_37908().method_8608()) {
            if (this.method_5782()) {
                return class_1269.field_5811;
            }
            return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    public void method_5865(class_1297 passenger) {
        this.updatePassengerPosition(passenger, class_1297::method_5814);
    }

    private void updatePassengerPosition(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        if (this.method_5626(passenger)) {
            class_243 v = new class_243(2.0, 0.0, 0.0).method_1024((float)(-Math.toRadians(this.method_36454())));
            v = v.method_1031(this.method_23317(), this.method_23318() + 1.0, this.method_23321());
            positionUpdater.accept(passenger, v.field_1352, v.field_1351, v.field_1350);
        }
    }

    public void method_5644(class_1297 passenger) {
        super.method_5644(passenger);
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }

    public void setParent(PhageRayBlockEntity phageRayBlockEntity) {
        this.parent = phageRayBlockEntity;
    }

    public void clientTick() {
        this.holder.get().clientTick();
    }

    @Nullable
    public class_1799 method_31480() {
        return NMBlocks.PHAGE_RAY.method_8389().method_7854();
    }

    static {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHANNEL_ID, (server, player, handler, buf, responseSender) -> {
            boolean trigger = buf.readBoolean();
            server.execute(() -> {
                class_1297 patt13944$temp = player.method_5854();
                if (patt13944$temp instanceof PhageRayEntity) {
                    PhageRayEntity phageRay = (PhageRayEntity)patt13944$temp;
                    phageRay.setPlayerTrigger(trigger);
                }
            });
        });
    }
}

