/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.power_flower;

import com.google.common.collect.Iterators;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.FluidPump;
import com.neep.neepmeat.api.processing.MeatFluidUtil;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMBlocks;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.machine.power_flower.PowerFlowerControllerBlock;
import com.neep.neepmeat.machine.power_flower.PowerFlowerFluidPortBlock;
import com.neep.neepmeat.machine.power_flower.PowerFlowerGrowthBlock;
import com.neep.neepmeat.transport.fluid_network.node.AcceptorModes;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class PowerFlowerControllerBlockEntity
extends SyncableBlockEntity {
    public static final FluidVariant INPUT_VARIANT = FluidVariant.of((class_3611)class_3612.field_15910);
    private int topPanels;
    private int blocks;
    private final FluidPump fluidPump = FluidPump.of(-0.5f, () -> AcceptorModes.PUSH);
    private final WritableSingleFluidStorage waterStorage = new WritableSingleFluidStorage(324000L, this::method_5431){

        protected boolean canInsert(FluidVariant variant) {
            return variant.isOf((Object)class_3612.field_15910);
        }
    };
    private final WritableSingleFluidStorage foodStorage = new WritableSingleFluidStorage(324000L, this::method_5431){

        protected boolean canInsert(FluidVariant variant) {
            return PowerFlowerControllerBlockEntity.foodEnergy((FluidVariant)variant).energy != 0;
        }
    };
    private final WritableSingleFluidStorage outputStorage = new WritableSingleFluidStorage(324000L, this::method_5431){

        protected boolean canInsert(FluidVariant variant) {
            return variant.isOf((Object)NMFluids.STILL_ETHEREAL_FUEL);
        }
    };
    private final CombinedStorage storage = new CombinedStorage();
    public static final FoodEnergyEntry NONE = new FoodEnergyEntry(0, 0);
    public static final FoodEnergyEntry MEAT = new FoodEnergyEntry(3, 1);
    public static final FoodEnergyEntry FEED = new FoodEnergyEntry(4, 1);

    public PowerFlowerControllerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public static FoodEnergyEntry foodEnergy(FluidVariant fluid) {
        if (fluid.isOf((Object)NMFluids.STILL_MEAT)) {
            return MEAT;
        }
        if (fluid.isOf((Object)NMFluids.STILL_FEED)) {
            return FEED;
        }
        if (fluid.isOf((Object)NMFluids.STILL_C_MEAT)) {
            return new FoodEnergyEntry(1 + (int)Math.ceil(MeatFluidUtil.getHunger(fluid)), 1);
        }
        return NONE;
    }

    public void serverTick() {
        if (this.field_11863.method_8510() % 80L == 0L) {
            this.search(this.field_11867);
            this.updateState();
        }
        try (Transaction transaction = Transaction.openOuter();){
            long inserted;
            long outputAmount = 0L;
            FoodEnergyEntry food = PowerFlowerControllerBlockEntity.foodEnergy((FluidVariant)this.foodStorage.variant);
            int consume = 1;
            if (food.energy != 0) {
                int foodDroplets = consume * (this.blocks - this.topPanels);
                long foodExtracted = this.foodStorage.extract((TransferVariant)((FluidVariant)this.foodStorage.variant), foodDroplets, (TransactionContext)transaction);
                outputAmount += PowerUtils.absToAmount((class_3611)NMFluids.STILL_ETHEREAL_FUEL, foodExtracted * (long)food.energy);
            }
            if (this.topPanels > 0) {
                int passivePower = (Integer)NeepMeat.CONFIG.powerFlower.solarCoefficient.getRealValue() * this.topPanels;
                long passiveAmount = PowerUtils.absToAmount((class_3611)NMFluids.STILL_ETHEREAL_FUEL, passivePower);
                long extracted = this.waterStorage.extract((TransferVariant)INPUT_VARIANT, passiveAmount, (TransactionContext)transaction);
                outputAmount += Math.min(passiveAmount, extracted);
            }
            if ((inserted = this.outputStorage.insert(FluidVariant.of((class_3611)NMFluids.STILL_ETHEREAL_FUEL), outputAmount, (TransactionContext)transaction)) == outputAmount) {
                transaction.commit();
            } else {
                transaction.abort();
            }
        }
    }

    protected void updateState() {
        this.field_11863.method_8501(this.field_11867, (class_2680)NMBlocks.POWER_FLOWER_CONTROLLER.method_9564().method_11657((class_2769)PowerFlowerControllerBlock.VALID, (Comparable)Boolean.valueOf(this.blocks > 0)));
    }

    private void search(class_2338 start) {
        this.blocks = 0;
        this.topPanels = 0;
        HashSet visited = Sets.newHashSet();
        ArrayDeque queue = Queues.newArrayDeque();
        visited.add(this.field_11867);
        queue.add(start);
        while (!queue.isEmpty()) {
            class_2338 current = (class_2338)queue.poll();
            class_2338.class_2339 mutable = current.method_25503();
            for (class_2350 direction : class_2350.values()) {
                mutable.method_25505((class_2382)current, direction);
                if (visited.contains(mutable)) continue;
                class_2680 nextState = this.field_11863.method_8320((class_2338)mutable);
                if (nextState.method_26204() instanceof PowerFlowerGrowthBlock) {
                    if ((Integer)nextState.method_11654((class_2769)PowerFlowerGrowthBlock.GROWTH) == 1) {
                        ++this.topPanels;
                    }
                    ++this.blocks;
                    queue.add(mutable.method_10062());
                    visited.add(mutable.method_10062());
                    if (this.blocks < (Integer)NeepMeat.CONFIG.powerFlower.maxBlocks.getRealValue()) continue;
                    return;
                }
                if (nextState.method_27852(NMBlocks.POWER_FLOWER_CONTROLLER)) {
                    this.blocks = 0;
                    this.topPanels = 0;
                    return;
                }
                class_2586 class_25862 = this.field_11863.method_8321((class_2338)mutable);
                if (!(class_25862 instanceof PowerFlowerFluidPortBlock.PFPortBlockEntity)) continue;
                PowerFlowerFluidPortBlock.PFPortBlockEntity port = (PowerFlowerFluidPortBlock.PFPortBlockEntity)class_25862;
                port.setController(this.field_11867);
                visited.add(mutable.method_10062());
            }
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("blocks", this.blocks);
        nbt.method_10569("panels", this.topPanels);
        nbt.method_10566("water_storage", (class_2520)this.waterStorage.toNbt(new class_2487()));
        nbt.method_10566("food_storage", (class_2520)this.foodStorage.toNbt(new class_2487()));
        nbt.method_10566("output_storage", (class_2520)this.outputStorage.toNbt(new class_2487()));
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.topPanels = nbt.method_10550("panels");
        this.blocks = nbt.method_10550("blocks");
        this.waterStorage.readNbt(nbt.method_10562("water_storage"));
        this.foodStorage.readNbt(nbt.method_10562("food_storage"));
        this.outputStorage.readNbt(nbt.method_10562("output_storage"));
    }

    public Storage<FluidVariant> getFluidStorage() {
        return this.storage;
    }

    public FluidPump getFluidPump(class_2350 direction) {
        return this.fluidPump;
    }

    public Storage<FluidVariant> getOutputStorage(class_2350 direction) {
        return this.outputStorage;
    }

    public int getTop() {
        return this.topPanels;
    }

    public int getNumBlocks() {
        return this.blocks;
    }

    private class CombinedStorage
    implements Storage<FluidVariant> {
        private CombinedStorage() {
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (resource.isOf((Object)class_3612.field_15910)) {
                return PowerFlowerControllerBlockEntity.this.waterStorage.insert(resource, maxAmount, transaction);
            }
            return PowerFlowerControllerBlockEntity.this.foodStorage.insert(resource, maxAmount, transaction);
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public Iterator<StorageView<FluidVariant>> iterator() {
            return Iterators.concat((Iterator)PowerFlowerControllerBlockEntity.this.waterStorage.iterator(), (Iterator)PowerFlowerControllerBlockEntity.this.foodStorage.iterator());
        }
    }

    public record FoodEnergyEntry(int energy, int consume) {
    }
}

