/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.pylon;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.util.ClientComponents;
import com.neep.meatlib.util.LazySupplier;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.DataPort;
import com.neep.neepmeat.api.DataResource;
import com.neep.neepmeat.api.enlightenment.EnlightenmentUtil;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.entity.GlomeEntity;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMBlocks;
import com.neep.neepmeat.machine.advanced_integrator.AdvancedIntegratorBlockEntity;
import com.neep.neepmeat.machine.advanced_integrator.SimpleDataPort;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.machine.well_head.BlockEntityFinder;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class PylonBlockEntity
extends SyncableBlockEntity
implements MotorisedBlock {
    protected final int radius = 7;
    public float angle;
    private float speed;
    private float level;
    private final SimpleDataPort port = new SimpleDataPort(this);
    private final LazySupplier<BlockEntityFinder<AdvancedIntegratorBlockEntity>> integratorFinder = LazySupplier.of(() -> new BlockEntityFinder<AdvancedIntegratorBlockEntity>(this.method_10997(), NMBlockEntities.ADVANCED_INTEGRATOR, 40).addAll(BlockEntityFinder.chunkRange(this.method_11016())).predicate(be -> be.method_11016().method_19771((class_2382)this.method_11016(), 14.0)));
    protected final Random random = new Random(0L);
    private final ClientComponents.Holder<PylonBlockEntity> holder = new ClientComponents.BlockEntityHolder<PylonBlockEntity>(this);

    public PylonBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public PylonBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.PYLON, pos, state);
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, PylonBlockEntity be) {
    }

    public boolean isRunning() {
        return this.getSpeed() >= ((Float)NeepMeat.CONFIG.pylon.runningSpeed.getRealValue()).floatValue();
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        this.integratorFinder.get().tick();
        float prevSpeed = this.speed;
        this.speed = motor.getSpeed();
        if (prevSpeed != this.speed) {
            this.sync();
        }
        if (this.isRunning()) {
            if (this.field_11863.method_8510() % 80L == 0L) {
                this.level = PylonBlockEntity.updateLevel(this.field_11863, this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260());
            }
            this.spawnGlomes();
            try (Transaction transaction = Transaction.openOuter();){
                float f = this.effectMultiplier();
                this.integratorFinder.get().result().forEach(i -> {
                    if (this.random.nextBoolean()) {
                        i.getDataStorage().insert(DataResource.NORMAL, (long)(1.0f + this.effectMultiplier() * 20.0f), (TransactionContext)transaction);
                    }
                });
                transaction.commit();
                float enlightenment = this.effectMultiplier() * 10.0f;
                class_243 centre = class_243.method_24953((class_2382)this.field_11867);
                PlayerLookup.around((class_3218)((class_3218)this.field_11863), (class_243)centre, (double)7.0).forEach(p -> EnlightenmentUtil.applyDose(p, enlightenment, p.method_5707(centre), 0.02));
            }
        }
        return false;
    }

    private static float updateLevel(class_1937 world, int x, int y, int z) {
        int level = 0;
        for (int depth = 1; depth <= 4; ++depth) {
            int j = y - depth;
            for (int i = x - depth; i <= x + depth; ++i) {
                for (int k = z - depth; k <= z + depth; ++k) {
                    if (!world.method_8320(new class_2338(i, j, k)).method_27852(NMBlocks.MEAT_STEEL_BLOCK)) continue;
                    ++level;
                }
            }
        }
        return (float)level / 164.0f;
    }

    protected class_238 getBox() {
        class_2338 volumeStart = this.method_11016().method_10059(new class_2382(7, 7, 7));
        int end = 15;
        return new class_238(volumeStart, volumeStart.method_10069(end, end, end));
    }

    private void spawnGlomes() {
        class_2338 volumeStart = this.method_11016().method_10059(new class_2382(7, 7, 7));
        int end = 15;
        float em = this.effectMultiplier();
        if ((double)this.random.nextFloat() < 0.05 * (double)this.effectMultiplier()) {
            if (!this.field_11863.method_18458((double)this.method_11016().method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), 32.0)) {
                return;
            }
            class_2338 entityBlockPos = volumeStart.method_10069(this.random.nextInt(end), this.random.nextInt(end), this.random.nextInt(end));
            class_243 entityPos = class_243.method_24953((class_2382)entityBlockPos);
            if (this.field_11863.method_22347(entityBlockPos)) {
                GlomeEntity entity = new GlomeEntity(this.field_11863, entityPos.field_1352, entityPos.field_1351 - 0.2, entityPos.field_1350, 0.0, 0.0, 0.0);
                this.field_11863.method_8649((class_1297)entity);
            }
        }
    }

    private float effectMultiplier() {
        return class_3532.method_15363((float)(this.speed / ((Float)NeepMeat.CONFIG.pylon.maxSpeed.getRealValue()).floatValue()), (float)0.0f, (float)1.0f) * Math.max(this.level, 0.01f);
    }

    public boolean isUnstable() {
        float m = this.effectMultiplier();
        return (double)m >= 0.7;
    }

    @Override
    public void setInputPower(float power) {
    }

    public float getSpeed() {
        return this.speed;
    }

    @Override
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("level", this.level);
        nbt.method_10548("speed", this.speed);
        this.port.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.speed = nbt.method_10583("speed");
        this.level = nbt.method_10583("level");
        this.port.readNbt(nbt);
    }

    public DataPort getPort(Void unused) {
        return this.port;
    }

    public void clientTick() {
        this.holder.get().clientTick();
    }
}

