/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.separator;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.machine.separator.SeparatorBlock;
import com.neep.neepmeat.machine.separator.SeparatorScreenHandler;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class SeparatorBlockEntity
extends SyncableBlockEntity
implements MotorisedBlock,
ExtendedScreenHandlerFactory {
    private float power;
    private int remainder = 4;
    private boolean takeBabies = false;
    private final Delegate delegate = new Delegate();

    public SeparatorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        int waitTime = (int)(20.0f + (1.0f - Math.min(this.power, 1000.0f) / 1000.0f) * 100.0f);
        if (this.power > 0.0f && this.field_11863.method_8510() % (long)waitTime == 0L) {
            int radius = 2;
            class_2338 centre = this.field_11867.method_10079((class_2350)this.method_11010().method_11654((class_2769)SeparatorBlock.field_11177), radius + 1);
            class_238 box = new class_238(centre);
            box = box.method_1009((double)radius, 2.0, (double)radius);
            List entities = this.field_11863.method_18023(class_5575.method_31795(class_1429.class), box, this::validEntity);
            entities.stream().skip(this.remainder).forEach(this::processEntity);
        }
        return false;
    }

    private boolean validEntity(class_1429 entity) {
        return this.takeBabies == entity.method_6109();
    }

    private void processEntity(class_1429 entity) {
        class_243 outputPos = class_243.method_24953((class_2382)this.field_11867.method_10093(((class_2350)this.method_11010().method_11654((class_2769)SeparatorBlock.field_11177)).method_10153()));
        entity.method_33574(outputPos);
    }

    @Override
    public void setInputPower(float power) {
        this.power = power;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("power", this.power);
        nbt.method_10569("remainder", this.remainder);
        nbt.method_10556("take_babies", this.takeBabies);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.power = nbt.method_10583("power");
        this.remainder = nbt.method_10550("remainder");
        this.takeBabies = nbt.method_10577("take_babies");
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.writeInt(this.remainder);
        buf.writeInt(this.takeBabies ? 1 : 0);
    }

    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new SeparatorScreenHandler(inv, syncId, this.delegate);
    }

    public class Delegate
    implements class_3913 {
        public static int SIZE = Properties.values().length;

        public int method_17390(int index) {
            if (index >= this.method_17389()) {
                return 0;
            }
            return switch (Properties.values()[index]) {
                default -> throw new IncompatibleClassChangeError();
                case Properties.REMAINDER -> SeparatorBlockEntity.this.remainder;
                case Properties.TAKE_BABIES -> SeparatorBlockEntity.this.takeBabies ? 1 : 0;
            };
        }

        public void method_17391(int index, int value) {
            if (index >= this.method_17389()) {
                return;
            }
            switch (Properties.values()[index]) {
                case REMAINDER: {
                    SeparatorBlockEntity.this.remainder = value;
                    break;
                }
                case TAKE_BABIES: {
                    SeparatorBlockEntity.this.takeBabies = value > 0;
                }
            }
        }

        public int method_17389() {
            return SIZE;
        }
    }

    public static enum Properties {
        REMAINDER,
        TAKE_BABIES;

    }
}

