/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.surgical_controller;

import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.network.plc.PLCRobotC2S;
import com.neep.neepmeat.plc.block.entity.PLCBlockEntity;
import com.neep.neepmeat.plc.robot.PLCRobot;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_4184;
import org.jetbrains.annotations.Nullable;

public class SurgicalRobot
implements PLCRobot,
NbtSerialisable {
    private final PLCBlockEntity parent;
    private MovementState movementState = MovementState.STATE_IDLE;
    public double cameraX;
    public double cameraY;
    public double cameraZ;
    private double x;
    private double y;
    private double z;
    public double clientX;
    public double clientY;
    public double clientZ;
    public float clientYaw;
    private double vx;
    private double vy;
    private double vz;
    public double prevX;
    public double prevY;
    public double prevZ;
    @Nullable
    private class_243 targetPos;
    @Nullable
    private class_2338 target;
    private final class_2338 basePos;
    private final class_243 dockingPos;
    private final class_243 attachPos;
    @Nullable
    private class_1657 controller;
    private float pitch;
    private float yaw;
    public ResourceAmount<ItemVariant> stored;
    private boolean moved = true;
    private static final String NBT_MOVEMENT_STATE = "movementState";
    private static final String NBT_NEXT_TYPE = "nextType";

    public SurgicalRobot(PLCBlockEntity parent) {
        this.parent = parent;
        this.basePos = parent.method_11016();
        this.dockingPos = class_243.method_26410((class_2382)this.basePos, (double)0.5);
        this.attachPos = class_243.method_26410((class_2382)this.basePos, (double)1.4);
        this.x = this.dockingPos.field_1352;
        this.y = this.dockingPos.field_1351;
        this.z = this.dockingPos.field_1350;
        this.clientX = this.x;
        this.clientY = this.y;
        this.clientZ = this.z;
        this.cameraX = this.x;
        this.cameraY = this.y;
        this.cameraZ = this.z;
    }

    public void setController(@Nullable class_1657 player) {
        this.controller = player;
    }

    @Nullable
    public class_1657 getController() {
        return this.controller;
    }

    public boolean shouldUpdatePosition(class_1937 world) {
        if (!world.method_8608()) {
            return this.getController() == null || this.parent.actionBlocksController();
        }
        return this.getController() != null;
    }

    public void tick() {
        if (this.shouldUpdatePosition(this.parent.method_10997())) {
            this.move();
        }
    }

    protected void move() {
        if (this.movementState == MovementState.STATE_IDLE) {
            if (!Objects.equals(this.target, this.basePos)) {
                this.movementState = MovementState.STATE_LAUNCHING;
            }
        } else if (this.movementState == MovementState.STATE_LAUNCHING) {
            if (this.moveTo(this.attachPos)) {
                this.movementState = MovementState.STATE_ACTIVE;
            }
        } else if (this.movementState == MovementState.STATE_ACTIVE) {
            if (this.targetPos != null) {
                this.moveTo(this.targetPos);
            }
        } else if (this.movementState == MovementState.STATE_RETURNING) {
            if (this.moveTo(this.attachPos)) {
                this.movementState = MovementState.STATE_DOCKING;
            }
        } else if (this.movementState == MovementState.STATE_DOCKING && this.moveTo(this.dockingPos)) {
            this.movementState = MovementState.STATE_IDLE;
        }
    }

    private boolean moveTo(class_243 toPos) {
        if (toPos.method_1028(this.x, this.y, this.z) >= 1.0E-4) {
            double dx = toPos.field_1352 - this.x;
            double dy = toPos.field_1351 - this.y;
            double dz = toPos.field_1350 - this.z;
            this.yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
            double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double vx = dx;
            double vy = dy;
            double vz = dz;
            if (dist > this.getSpeed()) {
                vx = vx / dist * this.getSpeed();
                vy = vy / dist * this.getSpeed();
                vz = vz / dist * this.getSpeed();
            }
            this.x += vx;
            this.y += vy;
            this.z += vz;
            this.moved = true;
            return false;
        }
        return true;
    }

    @Override
    public void setTarget(@Nullable PLC plc, @Nullable class_2338 target) {
        if (target == null) {
            this.target = null;
            this.targetPos = null;
            return;
        }
        this.target = target.method_10062();
        this.targetPos = this.getTarget(this.target);
    }

    private class_243 getTarget(class_2338 target) {
        return class_243.method_24953((class_2382)target);
    }

    public double getSpeed() {
        return 0.1;
    }

    public class_243 getPos() {
        return new class_243(this.x, this.y, this.z);
    }

    public class_2338 getBlockPos() {
        return new class_2338(this.x, this.y, this.z);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public boolean actuatorRemoved() {
        return this.parent.method_11015();
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10569(NBT_MOVEMENT_STATE, this.movementState.ordinal());
        nbt.method_10549("rx", this.x);
        nbt.method_10549("ry", this.y);
        nbt.method_10549("rz", this.z);
        nbt.method_10548("pitch", this.pitch);
        nbt.method_10548("yaw", this.yaw);
        if (this.stored != null) {
            class_2487 storedNbt = new class_2487();
            storedNbt.method_10566("item", (class_2520)((ItemVariant)this.stored.resource()).toNbt());
            storedNbt.method_10544("amount", this.stored.amount());
            nbt.method_10566("stored", (class_2520)storedNbt);
        }
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.movementState = MovementState.values()[nbt.method_10550(NBT_MOVEMENT_STATE)];
        this.x = nbt.method_10574("rx");
        this.y = nbt.method_10574("ry");
        this.z = nbt.method_10574("rz");
        this.pitch = nbt.method_10583("pitch");
        this.clientYaw = this.yaw = nbt.method_10583("yaw");
        if (nbt.method_10545("stored")) {
            class_2487 storedNbt = nbt.method_10562("stored");
            this.stored = new ResourceAmount((Object)ItemVariant.fromNbt((class_2487)storedNbt.method_10562("item")), storedNbt.method_10537("amount"));
        }
    }

    public boolean isActive() {
        return this.movementState == MovementState.STATE_ACTIVE;
    }

    @Override
    public boolean reachedTarget(PLC plc) {
        return this.targetPos == null || this.targetPos.method_1028(this.x, this.y, this.z) <= 0.010000000000000002;
    }

    public void returnToBase() {
        this.movementState = MovementState.STATE_RETURNING;
        this.setTarget(null, this.basePos);
    }

    public void setPos(double x, double y, double z) {
        if (!this.parent.method_10997().method_8608() && this.shouldUpdatePosition(this.parent.method_10997())) {
            return;
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.parent.method_5431();
    }

    public void stay() {
        this.setTarget(null, null);
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setPitchYaw(float pitch, float yaw) {
        this.pitch = pitch;
        this.yaw = yaw;
    }

    @Override
    public void spawnItem(@Nullable ResourceAmount<ItemVariant> stored) {
        if (stored == null) {
            return;
        }
        class_1264.method_5449((class_1937)this.parent.method_10997(), (double)this.x, (double)this.y, (double)this.z, (class_1799)((ItemVariant)stored.resource()).toStack((int)stored.amount()));
    }

    @Override
    public void dumpStored(PLC plc) {
        if (this.stored != null) {
            this.spawnItem(this.stored);
            this.stored = null;
        }
    }

    @Override
    public void setStored(PLC plc, @Nullable ResourceAmount<ItemVariant> stored) {
        this.stored = stored;
    }

    @Override
    public class_2338 getBasePos() {
        return this.parent.method_11016();
    }

    @Override
    @Nullable
    public ResourceAmount<ItemVariant> getStored(PLC plc) {
        return this.stored;
    }

    public void syncPosition(class_3218 serverWorld) {
        if (!this.moved) {
            return;
        }
        PLCRobotC2S.send(this.parent, serverWorld);
        this.moved = false;
    }

    public boolean getState() {
        return this.movementState == MovementState.STATE_RETURNING;
    }

    @Override
    public void setImplantTarget(PLC plc, class_243 implantSite, class_1297 target) {
        this.setTarget(plc, new class_2338(target.method_31477(), (int)Math.ceil(target.method_23318() + (double)target.method_17682()), target.method_31479()));
    }

    public static enum MovementState {
        STATE_IDLE,
        STATE_LAUNCHING,
        STATE_ACTIVE,
        STATE_RETURNING,
        STATE_DOCKING;

    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        private final SurgicalRobot robot;
        private final PLCBlockEntity be;
        public boolean forwardKey;
        public boolean backKey;
        public boolean leftKey;
        public boolean rightKey;
        public boolean upKey;
        public boolean downKey;

        public Client(SurgicalRobot robot, PLCBlockEntity be) {
            this.robot = robot;
            this.be = be;
        }

        public void tick() {
            this.motion();
            if (this.be.method_10997().method_8510() % 4L == 0L) {
                PLCRobotC2S.Client.send(this.be);
            }
        }

        public void motion() {
            if (!this.robot.parent.overrideController()) {
                double l;
                if (this.robot.controller == null) {
                    return;
                }
                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                double speed = 0.2;
                float pitch = camera.method_19329();
                float yaw = camera.method_19330();
                double vx = -Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
                double vz = Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
                class_243 normal = new class_243(-vz, 0.0, vx);
                double fvx = 0.0;
                double fvy = 0.0;
                double fvz = 0.0;
                if (this.forwardKey) {
                    fvx += vx;
                    fvz += vz;
                }
                if (this.backKey) {
                    fvx -= vx;
                    fvz -= vz;
                }
                if (this.leftKey) {
                    fvx -= normal.field_1352;
                    fvz -= normal.field_1350;
                }
                if (this.rightKey) {
                    fvx += normal.field_1352;
                    fvz += normal.field_1350;
                }
                if (this.upKey) {
                    fvy += speed;
                }
                if (this.downKey) {
                    fvy -= speed;
                }
                if ((l = Math.sqrt(fvx * fvx + fvz * fvz)) != 0.0) {
                    fvx = fvx / l * speed;
                    fvz = fvz / l * speed;
                    this.robot.vx = fvx;
                    this.robot.vz = fvz;
                }
                if (fvy != 0.0) {
                    this.robot.vy = fvy;
                }
                this.robot.x += this.robot.vx;
                this.robot.y += this.robot.vy;
                this.robot.z += this.robot.vz;
                this.robot.vz *= 0.05;
                this.robot.vy *= 0.05;
                this.robot.vx *= 0.05;
                this.robot.movementState = MovementState.STATE_ACTIVE;
                this.robot.setTarget(null, this.robot.getBlockPos());
            }
        }

        public void resetKeys() {
            this.forwardKey = false;
            this.backKey = false;
            this.leftKey = false;
            this.rightKey = false;
            this.upKey = false;
            this.downKey = false;
        }
    }
}

