/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.neepasm.compiler.parser;

import com.google.common.collect.Lists;
import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.instruction.SimpleInstructionProvider;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.DefaultParsedInstruction;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.InstructionParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.neepasm.program.KeyValue;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class DefaultInstructionParser
implements InstructionParser {
    private final InstructionProvider provider;

    public DefaultInstructionParser(InstructionProvider provider) {
        this.provider = provider;
    }

    @Override
    public PlcParsedInstruction parse(NeepAsmTokenView view, NeepAsmParser parser, @Nullable String scope) throws NeepASM.ParseException {
        if (!(this.provider instanceof SimpleInstructionProvider)) {
            throw new NeepASM.ParseException("default parser does not support arbitrary arguments");
        }
        ArrayList arguments = Lists.newArrayList();
        ArrayList kvs = Lists.newArrayList();
        boolean read = true;
        while (read) {
            view.fastForward();
            if (NeepAsmParser.isComment(view) || view.lineEnded()) {
                read = false;
            } else {
                Argument a = parser.parseWorldTarget(view);
                if (a != null) {
                    arguments.add(a);
                } else {
                    KeyValue kv = parser.parseKV(view);
                    if (kv != null) {
                        kvs.add(kv);
                    } else {
                        throw new NeepASM.ParseException("unexpected token", view.peek());
                    }
                }
            }
            if (arguments.size() > ((SimpleInstructionProvider)this.provider).maxArguments()) {
                throw new NeepASM.ParseException("too many targets provided");
            }
            view.fastForward();
        }
        return new DefaultParsedInstruction(this.provider, arguments, kvs);
    }
}

