/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.network;

import com.neep.meatlib.network.PacketBufUtil;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.client.screen.MachineHudOverlay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class MachineDiagnosticsRequest {
    public static final class_2960 ID = new class_2960("neepmeat", "machine_diagnostics");

    public static void registerReceiver() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ID, MachineDiagnosticsRequest::applyServer);
    }

    private static void applyServer(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        class_2960 worldId = class_2960.method_12829((String)buf.method_19772());
        class_3218 world = server.method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)worldId));
        class_2338 pos = PacketBufUtil.readBlockPos(buf);
        server.execute(() -> {
            MotorisedBlock.DiagnosticsProvider diagnosticsProvider = (MotorisedBlock.DiagnosticsProvider)MotorisedBlock.DiagnosticsProvider.LOOKUP.find((class_1937)world, pos, null);
            if (diagnosticsProvider != null) {
                MachineDiagnosticsRequest.send(player, diagnosticsProvider);
            }
        });
    }

    protected static void send(class_3222 player, @NotNull MotorisedBlock.DiagnosticsProvider diagnosticsProvider) {
        MotorisedBlock.Diagnostics diagnostics = diagnosticsProvider.getDiagnostics();
        if (diagnostics != null) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10794(diagnostics.nbt());
            ServerPlayNetworking.send((class_3222)player, (class_2960)ID, (class_2540)buf);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static void registerReceiver() {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)ID, Client::applyClient);
        }

        private static void applyClient(class_310 client, class_634 handler, class_2540 buf, PacketSender packet) {
            MotorisedBlock.Diagnostics diagnostics = new MotorisedBlock.Diagnostics(buf.method_10798());
            client.execute(() -> MachineHudOverlay.getInstance().receive(diagnostics));
        }

        public static void send(class_1937 world, class_2338 pos) {
            if (!world.method_8608()) {
                throw new IllegalStateException();
            }
            class_2540 buf = PacketByteBufs.create();
            buf.method_10814(world.method_27983().method_29177().toString());
            PacketBufUtil.writeBlockPos(buf, pos);
            ClientPlayNetworking.send((class_2960)ID, (class_2540)buf);
        }
    }
}

