/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.editor;

import com.neep.meatlib.util.Completions;
import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.api.plc.program.PLCProgram;
import com.neep.neepmeat.api.storage.WorldSupplier;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.LabelLookup;
import com.neep.neepmeat.neepasm.compiler.ParsedInstructionList;
import com.neep.neepmeat.network.plc.PLCSyncAction;
import com.neep.neepmeat.plc.block.entity.PLCBlockEntity;
import com.neep.neepmeat.plc.compiler.PLCCompilePipeline;
import com.neep.neepmeat.plc.program.PLCProgramImpl;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ProgramEditor
implements NbtSerialisable {
    public static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    private String programSource = "";
    @Nullable
    private PLCCompilePipeline<?> pipeline = null;
    private final PLCBlockEntity plc;
    private PLCProgram program = new PLCProgramImpl(() -> ((PLCBlockEntity)plc).method_10997());
    private boolean needsCompile = true;
    @Nullable
    private Misery compileFuture;

    public ProgramEditor(PLCBlockEntity plc) {
        this.plc = plc;
    }

    public void setProgramSource(String text) {
        this.programSource = text;
        this.needsCompile = true;
    }

    public String getSource() {
        return this.programSource;
    }

    public void updatePipeline() {
        this.pipeline = null;
    }

    private static <T extends ParsedInstructionList & LabelLookup> CompletableFuture<PLCProgram> thing(PLCCompilePipeline<T> pipeline, String source, Executor server) {
        CompletionStage<PLCProgram> stage = Completions.supplyAsync(() -> pipeline.parse(source), EXECUTOR).thenApplyAsync(Completions.checkedFunction(x$0 -> pipeline.compile((ParsedInstructionList)x$0)), server);
        return stage.toCompletableFuture().orTimeout(100L, TimeUnit.MILLISECONDS);
    }

    public void compile(Consumer<PLCProgram> completeAction) {
        if (this.pipeline == null) {
            this.pipeline = (PLCCompilePipeline)this.plc.getLanguage().apply(WorldSupplier.of(this.plc));
        }
        if (this.compileFuture != null) {
            return;
        }
        MinecraftServer server = this.plc.method_10997().method_8503();
        if (!this.needsCompile) {
            CompletableFuture<PLCProgram> future = new CompletableFuture<PLCProgram>();
            future.complete(this.program);
            this.compileFuture = new Misery(future, completeAction);
            return;
        }
        this.needsCompile = false;
        CompletableFuture<PLCProgram> future = ProgramEditor.thing(this.pipeline, this.programSource, (Executor)server);
        this.compileFuture = new Misery(future, completeAction);
    }

    public void tick() {
        if (this.compileFuture != null && this.compileFuture.isDone()) {
            try {
                PLCProgram result = this.compileFuture.get();
                if (result != this.program) {
                    this.program = result;
                    if (this.plc.getSurgeryRobot().getController() != null) {
                        PLCSyncAction.sendCompileStatus((class_3222)this.plc.getSurgeryRobot().getController(), "Compiled successfully", true, -1);
                    }
                }
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof NeepASM.ProgramBuildException) {
                    NeepASM.ProgramBuildException e1 = (NeepASM.ProgramBuildException)throwable;
                    if (this.plc.getSurgeryRobot().getController() != null) {
                        PLCSyncAction.sendCompileStatus((class_3222)this.plc.getSurgeryRobot().getController(), e1.getMessage(), false, e1.line());
                    }
                } else {
                    throwable = e.getCause();
                    if (throwable instanceof TimeoutException) {
                        TimeoutException timeout = (TimeoutException)throwable;
                        if (this.plc.getSurgeryRobot().getController() != null) {
                            PLCSyncAction.sendCompileStatus((class_3222)this.plc.getSurgeryRobot().getController(), "Compilation timeout. Program is too complex.", false, -1);
                        }
                    }
                }
                this.program = PLCProgram.EMPTY;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.compileFuture = null;
        }
    }

    public PLCProgram getProgram() {
        return this.program;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10582("source", this.programSource);
        nbt.method_10566("program", (class_2520)this.program.writeNbt(new class_2487()));
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.programSource = nbt.method_10558("source");
        this.program.readNbt(nbt.method_10562("program"));
    }

    private record Misery(Future<PLCProgram> future, Consumer<PLCProgram> completeAction) {
        public PLCProgram get() throws InterruptedException, ExecutionException {
            PLCProgram program = this.future.get();
            this.completeAction.accept(program);
            return program;
        }

        public boolean isDone() {
            return this.future.isDone();
        }
    }
}

